/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.common.model.ui.editors.dnd.ValidationException;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.ui.widget.editor.ButtonFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.taglib.html.jq.LinkAttributeProvider;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.LayoutUtil;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.IDContentProposalProvider;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.WizardDescriptions;
import org.jboss.tools.jst.web.ui.palette.html.wizard.NewHTMLWidgetWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItem;
import org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard.HTMLFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard.NewDatalistWizard;
import org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard.NewDatalistWizardPage;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NewTextInputWizardPage
extends NewHTMLWidgetWizardPage {
    static String[] PROPERTIES = new String[]{"text-type", "label", "id", "name", "list", "disabled", "value", "placeholder", "min", "max", "step", "pattern", "maxlength", "autofocus", "required"};
    static String DATALIST_NODE_EVENT = "datalistNode";
    Set<String> datalists = new HashSet<String>();
    IElementGenerator.ElementNode datalistNode = null;
    Button createDatalistButton = null;
    boolean listEnabled = true;

    public NewTextInputWizardPage() {
        super("newText", WizardMessages.newTextInputWizardTitle);
        this.setDescription(WizardMessages.newHTML5TextInputWizardDescription);
    }

    public void setListEnabled(boolean b) {
        this.listEnabled = b;
        this.setEnabled("list", b);
    }

    public void createDatalist(boolean showDialog) {
        new NewDatalistWizardEx(this.getWizard().getPaletteItem(), showDialog);
    }

    public IElementGenerator.ElementNode getDatalistNode() {
        return this.datalistNode;
    }

    @Override
    protected void createFieldPanel(Composite parent) {
        this.addEditor(JQueryFieldEditorFactory.createTextTypeEditor(), parent);
        this.addEditor(JQueryFieldEditorFactory.createNameEditor(), parent);
        this.createIDEditor(parent, false);
        this.createSeparator(parent);
        IFieldEditor label = JQueryFieldEditorFactory.createLabelEditor();
        label.setValue((Object)"Input:");
        this.addEditor(label, parent);
        IFieldEditor placeholder = JQueryFieldEditorFactory.createPlaceholderEditor();
        placeholder.setValue((Object)"Text");
        this.addEditor(placeholder, parent);
        this.createSeparator(parent);
        IFieldEditor list = HTMLFieldEditorFactory.createInputListEditor(new CreateDatalistAction());
        this.addEditor(list, parent);
        if (!this.listEnabled) {
            list.setEnabled(false);
        }
        if (parent != null) {
            IDContentProposalProvider p = new IDContentProposalProvider(this.getDatalistIDs("", true), list);
            p.setSharp(false);
            Object[] objectArray = list.getEditorControls();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof Button) {
                    this.createDatalistButton = (Button)o;
                }
                ++n2;
            }
        }
        this.addEditor(JQueryFieldEditorFactory.createValueEditor(), parent);
        LayoutUtil.TwoColumns columns = NewTextInputWizardPage.createTwoColumns(parent);
        this.addEditor(JQueryFieldEditorFactory.createPatternEditor(), columns.left());
        IFieldEditor maxlength = JQueryFieldEditorFactory.createMaxlengthEditor();
        this.addEditor(maxlength, columns.right());
        if (parent != null) {
            Object[] cs = maxlength.getEditorControls();
            GridData d = (GridData)((Text)cs[1]).getLayoutData();
            d.widthHint = 20;
            ((Text)cs[1]).setLayoutData((Object)d);
        }
        Group panel = null;
        if (parent != null) {
            panel = new Group(parent, 2048);
            panel.setText(WizardMessages.inputTypeNumberLabel);
            GridData d = new GridData(768);
            d.horizontalSpan = 3;
            panel.setLayoutData((Object)d);
            panel.setLayout((Layout)new GridLayout(3, false));
        }
        Composite[] columns3 = NewTextInputWizardPage.createColumns(panel, 3);
        IFieldEditor min = JQueryFieldEditorFactory.createMinEditor(WizardDescriptions.textInputMin);
        min.setValue((Object)"");
        this.addEditor(min, columns3[0]);
        IFieldEditor max = JQueryFieldEditorFactory.createMaxEditor(WizardDescriptions.textInputMax);
        max.setValue((Object)"");
        this.addEditor(max, columns3[1]);
        IFieldEditor step = JQueryFieldEditorFactory.createStepEditor(WizardDescriptions.textInputStep);
        this.addEditor(step, columns3[2]);
        this.createSeparator(parent);
        columns3 = NewTextInputWizardPage.createColumns(parent, 3);
        this.addEditor(JQueryFieldEditorFactory.createRequiredEditor(), columns3[0]);
        this.addEditor(JQueryFieldEditorFactory.createDisabledEditor(), columns3[1]);
        this.addEditor(JQueryFieldEditorFactory.createAutofocusEditor(), columns3[2]);
        this.updateNumberFieldsEnablement();
        this.updateListButtonEnablement();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("text-type".equals(name)) {
            this.updateNumberFieldsEnablement();
        }
        if ("list".equals(name)) {
            this.datalistNode = null;
            this.updateListButtonEnablement();
        } else if (DATALIST_NODE_EVENT.equals(name)) {
            this.updateListButtonEnablement();
        }
        super.propertyChange(evt);
    }

    void updateNumberFieldsEnablement() {
        boolean isNumber = "number".equals(this.getEditorValue("text-type"));
        this.setEnabled("min", isNumber);
        this.setEnabled("max", isNumber);
        this.setEnabled("step", isNumber);
    }

    void updateListButtonEnablement() {
        if (this.listEnabled && this.createDatalistButton != null && !this.createDatalistButton.isDisposed()) {
            boolean enabled = !this.datalists.contains(this.getEditorValue("list")) && this.datalistNode == null;
            this.createDatalistButton.setEnabled(enabled);
        }
    }

    @Override
    public void validate() throws ValidationException {
        String pattern = this.getEditorValue("pattern");
        if (pattern != null && pattern.length() > 0) {
            try {
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw new ValidationException(e.getMessage());
            }
        }
        super.validate();
    }

    public List<LinkAttributeProvider.ElementID> getDatalistIDs(final String mask, final boolean escapeHTML) {
        final ArrayList<LinkAttributeProvider.ElementID> ids = new ArrayList<LinkAttributeProvider.ElementID>();
        this.datalists = new HashSet<String>();
        if (this.getWizard().getFile() == null) {
            return ids;
        }
        StructuredModelWrapper.execute((IFile)this.getWizard().getFile(), (StructuredModelWrapper.ICommand)new StructuredModelWrapper.ICommand(){

            public void execute(IDOMDocument xmlDocument) {
                try {
                    NodeList list = (NodeList)XPathFactory.newInstance().newXPath().compile("//*/@id[starts-with(.,'" + mask + "')]").evaluate(xmlDocument, XPathConstants.NODESET);
                    int i = 0;
                    while (i < list.getLength()) {
                        IDOMAttr attr = (IDOMAttr)list.item(i);
                        Element element = attr.getOwnerElement();
                        if ("datalist".equals(element.getNodeName())) {
                            IStructuredDocumentRegion s = ((IDOMNode)element).getStartStructuredDocumentRegion();
                            String id = attr.getNodeValue();
                            int offset = attr.getValueRegionStartOffset() + 1;
                            String nodeString = s.getText();
                            ids.add(new LinkAttributeProvider.ElementID(id, offset, nodeString, escapeHTML));
                            NewTextInputWizardPage.this.datalists.add(id);
                        }
                        ++i;
                    }
                }
                catch (XPathExpressionException e) {
                    WebKbPlugin.getDefault().logError((Throwable)e);
                }
            }
        });
        return Collections.unmodifiableList(ids);
    }

    class CreateDatalistAction
    extends ButtonFieldEditor.ButtonPressedAction {
        public CreateDatalistAction() {
            super(WizardMessages.createLabel);
        }

        public void run() {
            NewTextInputWizardPage.this.createDatalist(NewTextInputWizardPage.this.getControl() != null);
        }
    }

    class NewDatalistWizardEx
    extends NewDatalistWizard {
        NewDatalistWizardEx(IPaletteItem item, boolean showDialog) {
            JSPMultiPageEditor e = (JSPMultiPageEditor)WebUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            this.setPaletteItem(item);
            this.setCommand(this.createDropCommand(e.getJspEditor()));
            WizardDialog d = new WizardDialog(NewTextInputWizardPage.this.getShell(), (IWizard)this);
            d.create();
            ((NewDatalistWizardPage)this.page).setEditorValue("id", NewTextInputWizardPage.this.getEditorValue("list"));
            if (NewTextInputWizardPage.this.getControl() != null) {
                IFieldEditor input = ((NewDatalistWizardPage)this.page).getEditor("input");
                input.setEnabled(false);
                Object[] objectArray = input.getEditorControls();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof Control) {
                        ((Control)o).setVisible(false);
                    }
                    ++n2;
                }
            }
            if (showDialog) {
                d.open();
            } else {
                this.doPerformFinish();
            }
            this.dispose();
        }

        @Override
        protected void doPerformFinish() {
            IElementGenerator.ElementNode root = NewDatalistWizardEx.createRoot();
            this.addContent(root);
            String id = this.getID(prefix);
            NewTextInputWizardPage.this.setEditorValue("list", id);
            NewTextInputWizardPage.this.datalistNode = (IElementGenerator.ElementNode)root.getChildren().get(0);
            NewTextInputWizardPage.this.propertyChange(new PropertyChangeEvent(NewTextInputWizardPage.this.createDatalistButton, DATALIST_NODE_EVENT, "", ""));
        }
    }
}

