/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.wizards.query.AbstractQueryWizardView;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.ui.Messages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;

public abstract class SelectWebProcessItemWizardView
extends AbstractQueryWizardView {
    private Properties p;
    private XModelObject process;
    private XModelObject[] items = null;
    private XModelObject selected = null;
    protected TableViewer tableViewer;
    protected Text filter;
    protected TContentProvider provider = new TContentProvider();

    public void setObject(Object data) {
        super.setObject(data);
        this.p = (Properties)data;
        this.process = (XModelObject)this.p.get("object");
        this.items = (XModelObject[])this.p.get("items");
        this.sortItems();
        this.setMessage(WizardKeys.getString((String)"SelectItemWizardView.Message"));
    }

    private void sortItems() {
        if (this.items == null) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                XModelObject oo1 = (XModelObject)o1;
                XModelObject oo2 = (XModelObject)o2;
                String key1 = SelectWebProcessItemWizardView.this.getKey(oo1);
                String key2 = SelectWebProcessItemWizardView.this.getKey(oo2);
                return key1.compareTo(key2);
            }
        };
        Arrays.sort(this.items, c);
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Control c1 = this.createTableViewer(composite);
        if (c1 != null) {
            c1.setLayoutData((Object)new GridData(1808));
        }
        Control c2 = this.createText(composite);
        c2.setLayoutData((Object)new GridData(768));
        this.getCommandBar().setCommands(new String[]{AbstractQueryWizardView.OK, AbstractQueryWizardView.CANCEL});
        this.getCommandBar().setEnabled(AbstractQueryWizardView.OK, false);
        return composite;
    }

    protected Control createTableViewer(Composite parent) {
        if (this.items == null) {
            this.items = this.process.getChildren(this.getItemEntity());
            this.sortItems();
        }
        this.provider.setObjects(this.items);
        this.provider.setPattern("");
        this.tableViewer = new TableViewer(parent, 2816);
        this.tableViewer.setColumnProperties(new String[]{"name"});
        this.tableViewer.setContentProvider((IContentProvider)this.provider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.tableViewer.setInput((Object)this);
        this.tableViewer.getTable().addMouseListener((MouseListener)new Ms());
        return this.tableViewer.getTable();
    }

    protected Control createText(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        c.setLayout((Layout)layout);
        Label l = new Label(c, 0);
        l.setText(Messages.SelectWebProcessItemWizardView_FilterLabel);
        this.filter = new Text(c, 2048);
        this.filter.setLayoutData((Object)new GridData(768));
        this.filter.addModifyListener((ModifyListener)new MA());
        this.filter.forceFocus();
        return c;
    }

    public void stopEditing() {
        this.readSelection();
    }

    public void action(String command) {
        this.stopEditing();
        if (OK.equalsIgnoreCase(command)) {
            this.p.put("selected", this.selected);
        }
        super.action(command);
    }

    protected abstract String getItemEntity();

    protected abstract String getKey(XModelObject var1);

    private void readSelection() {
        int i = this.tableViewer.getTable().getSelectionIndex();
        this.selected = i < 0 || this.provider == null ? null : this.provider.items.get(i);
    }

    private void makeSelection() {
        if (this.provider == null || this.provider.items == null) {
            return;
        }
        if (this.selected == null || !this.provider.items.contains(this.selected)) {
            this.selected = null;
            if (this.provider.items.size() > 0) {
                this.selected = this.provider.items.get(0);
            }
        }
        if (this.selected != null && this.tableViewer != null && this.tableViewer.getControl() != null && !this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.selected));
        }
    }

    class MA
    implements ModifyListener {
        MA() {
        }

        public void modifyText(ModifyEvent e) {
            SelectWebProcessItemWizardView.this.provider.setPattern(SelectWebProcessItemWizardView.this.filter.getText());
            SelectWebProcessItemWizardView.this.tableViewer.refresh();
            SelectWebProcessItemWizardView.this.readSelection();
            SelectWebProcessItemWizardView.this.getCommandBar().setEnabled(AbstractQueryWizardView.OK, SelectWebProcessItemWizardView.this.selected != null);
        }
    }

    class Ms
    extends MouseAdapter {
        Ms() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            SelectWebProcessItemWizardView.this.action(OK);
        }

        public void mouseDown(MouseEvent e) {
            SelectWebProcessItemWizardView.this.readSelection();
            SelectWebProcessItemWizardView.this.getCommandBar().setEnabled(AbstractQueryWizardView.OK, SelectWebProcessItemWizardView.this.selected != null);
        }
    }

    class TContentProvider
    implements IListContentProvider,
    ITableLabelProvider {
        XModelObject[] l = new XModelObject[0];
        ArrayList<XModelObject> items = new ArrayList();

        TContentProvider() {
        }

        public void setObjects(XModelObject[] l) {
            this.l = l;
        }

        public void setPattern(String s) {
            s = s == null ? "" : s.toLowerCase();
            this.items.clear();
            int i = 0;
            while (i < this.l.length) {
                String key = SelectWebProcessItemWizardView.this.getKey(this.l[i]);
                if (key != null && (s.length() == 0 || key.toLowerCase().indexOf(s) >= 0)) {
                    this.items.add(this.l[i]);
                }
                ++i;
            }
            SelectWebProcessItemWizardView.this.makeSelection();
        }

        public Object[] getElements(Object inputElement) {
            return this.items.toArray(new Object[0]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            try {
                viewer.refresh();
            }
            catch (Exception e) {
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (!(element instanceof XModelObject)) {
                return null;
            }
            return EclipseResourceUtil.getImage((XModelObject)((XModelObject)element));
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof XModelObject)) {
                return "";
            }
            return columnIndex == 0 ? SelectWebProcessItemWizardView.this.getKey((XModelObject)element) : "-";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return "name".equals(property);
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

