/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.attribute.editor.CheckBoxEditor;
import org.jboss.tools.common.model.ui.attribute.editor.DirectoryChoicerEditor;
import org.jboss.tools.common.model.ui.attribute.editor.DropDownEditor;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.StringEditor;
import org.jboss.tools.common.model.ui.widgets.DefaultSettings;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.project.helpers.IWebProjectTemplate;
import org.jboss.tools.jst.web.project.helpers.NewWebProjectContext;
import org.jboss.tools.jst.web.project.version.ProjectVersion;
import org.jboss.tools.jst.web.project.version.ProjectVersions;
import org.jboss.tools.jst.web.ui.Messages;

public class NewWebProjectWizardPage
extends WizardPage {
    protected Label introduction;
    protected PropertyEditor nameEditor;
    protected PropertyEditor locationEditor;
    protected PropertyEditor useDefaultPathEditor;
    protected PropertyEditor versionEditor;
    protected PropertyEditor templateEditor;
    protected LocalValueProvider nameAdapter;
    protected LocalValueProvider locationAdapter;
    protected LocalValueProvider useDefaultPathAdapter;
    protected LocalValueProvider versionAdapter;
    protected TemplateAdapter templateAdapter;
    protected InputChangeListener inputChangeListener = new InputChangeListener();
    private IPath defaultPath;
    private NewWebProjectContext context;
    protected IWebProjectTemplate template;
    Composite composite = null;
    int validationLock = 0;

    public NewWebProjectWizardPage(NewWebProjectContext context) {
        super(Messages.NewWebProjectWizardPage_Page1);
        this.context = context;
        this.template = context.getTemplate();
        IWidgetSettings settings = DefaultSettings.getDefault();
        this.nameEditor = new StringEditor(settings);
        this.nameAdapter = new NameAdapter();
        this.nameEditor.setInput((Object)this.nameAdapter);
        this.nameEditor.setLabelText(String.valueOf(this.getString(String.valueOf(this.getKey()) + "_" + "name")) + "*");
        this.locationEditor = new DirectoryChoicerEditor(settings);
        this.locationAdapter = new LocationAdapter();
        this.locationEditor.setInput((Object)this.locationAdapter);
        this.locationEditor.setLabelText(String.valueOf(this.getString(String.valueOf(this.getKey()) + "_" + "location")) + "*");
        this.useDefaultPathEditor = new CheckBoxEditor(settings);
        this.useDefaultPathAdapter = new UseDefaultPathAdapter();
        this.useDefaultPathEditor.setInput((Object)this.useDefaultPathAdapter);
        this.useDefaultPathEditor.setLabelText(String.valueOf(this.getString(String.valueOf(this.getKey()) + "_" + "use default path")) + "*");
        this.versionEditor = new DropDownEditor(settings);
        this.versionAdapter = new VersionAdapter();
        this.versionEditor.setInput((Object)this.versionAdapter);
        this.versionEditor.setLabelText(String.valueOf(this.getString(String.valueOf(this.getKey()) + "_" + "version")) + "*");
        this.templateEditor = new DropDownEditor(settings);
        this.templateAdapter = new TemplateAdapter();
        this.templateEditor.setInput((Object)this.templateAdapter);
        this.templateEditor.setLabelText(String.valueOf(this.getString(String.valueOf(this.getKey()) + "_" + "template")) + "*");
        this.defaultPath = ModelUIPlugin.getWorkspace().getRoot().getLocation();
        this.setPageComplete(false);
    }

    protected String getKey() {
        return "newStrutsProjectPage1";
    }

    public void createControl(Composite parent) {
        this.createControlImpl(parent);
    }

    private void createControlImpl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        this.composite.setLayout((Layout)layout);
        ExtendedFieldEditor editor = this.nameEditor.getFieldEditor(this.composite);
        editor.fillIntoGrid(this.composite, 2);
        editor = this.useDefaultPathEditor.getFieldEditor(this.composite);
        editor.fillIntoGrid(this.composite, 2);
        editor = this.locationEditor.getFieldEditor(this.composite);
        editor.fillIntoGrid(this.composite, 2);
        editor = this.versionEditor.getFieldEditor(this.composite);
        editor.fillIntoGrid(this.composite, 2);
        editor = this.templateEditor.getFieldEditor(this.composite);
        editor.fillIntoGrid(this.composite, 2);
        GridData gd = new GridData(1808);
        this.composite.setLayoutData((Object)gd);
        this.setControl((Control)this.composite);
        this.nameAdapter.setValue("");
        this.useDefaultPathAdapter.setValue(this.getProjectRootOption() != null ? "false" : "true");
        if (this.getProjectRootOption() == null) {
            this.locationAdapter.setValue(this.defaultPath.toOSString());
        } else {
            this.locationAdapter.setValue(this.getProjectRootOption());
        }
        this.versionAdapter.setValue(this.template.getDefaultVersion());
        this.templateAdapter.setValue(this.template.getDefaultTemplate(this.template.getDefaultVersion()));
    }

    protected String getProjectRootOption() {
        return null;
    }

    private String getProjectName() {
        String s = this.getStringValue(this.nameAdapter);
        return s == null ? null : s.trim();
    }

    private String getProjectLocation() {
        return this.getStringValue(this.locationAdapter);
    }

    protected String getStringValue(LocalValueProvider adapter) {
        Object o = adapter.getValue();
        return o == null ? null : o.toString();
    }

    private IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    private boolean validatePage() {
        String error;
        IWorkspace workspace = ModelUIPlugin.getWorkspace();
        String projectName = this.getProjectName();
        ProjectVersions versions = this.template.getProjectVersions();
        String versionsError = versions.getErrorMessage();
        if (versionsError != null) {
            this.setErrorMessage(versionsError);
            return false;
        }
        if ("".equals(projectName)) {
            this.setErrorMessage(null);
            this.setMessage(this.getString(String.valueOf(this.getKey()) + "_specifyProjectName"));
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectName, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        String projectLocation = this.getProjectLocation();
        if ("".equals(projectLocation)) {
            this.setErrorMessage(null);
            this.setMessage(this.getString(String.valueOf(this.getKey()) + "_specifyLocation"));
            return false;
        }
        if (!new Path(projectLocation).isAbsolute()) {
            this.setErrorMessage(this.getString(String.valueOf(this.getKey()) + "_locationError"));
            return false;
        }
        if (this.getProjectHandle().exists() || this.projectExistsIgnoreCase()) {
            this.setErrorMessage(this.getString(String.valueOf(this.getKey()) + "_projectExistsMessage"));
            return false;
        }
        IProject overlap = this.overlaps(projectLocation);
        if (overlap != null) {
            this.setErrorMessage(MessageFormat.format(Messages.NewWebProjectWizardPage_OverlappingLocation, overlap.getName()));
            return false;
        }
        if ("".equals(this.getStringValue(this.versionAdapter))) {
            this.setErrorMessage(versionsError);
            return false;
        }
        String versionName = this.versionAdapter.getStringValue(true);
        ProjectVersion version = versions.getVersion(versionName);
        String string = error = version == null ? MessageFormat.format(Messages.NewWebProjectWizardPage_CannotFindVersion, versionName) : version.getErrorMessage();
        if (error != null) {
            this.setErrorMessage(error);
            return false;
        }
        String templateName = this.getStringValue(this.templateAdapter);
        if (templateName == null || templateName.length() == 0) {
            String[] ts = this.template.getTemplateList(versionName);
            error = ts == null || ts.length == 0 ? MessageFormat.format(Messages.NewWebProjectWizardPage_NoTemplates, versionName) : Messages.NewWebProjectWizardPage_NoTemplateName;
            this.setErrorMessage(error);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this.updateContext();
        return true;
    }

    private boolean projectExistsIgnoreCase() {
        String name = this.getProjectName();
        return EclipseResourceUtil.projectExistsIgnoreCase((String)name);
    }

    private IProject overlaps(String projectLocation) {
        projectLocation = String.valueOf(projectLocation.replace('\\', '/').toLowerCase()) + "/";
        IProject[] ps = ModelPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < ps.length) {
            String location = String.valueOf(ps[i].getLocation().toString().replace('\\', '/').toLowerCase()) + "/";
            if (location.startsWith(projectLocation)) {
                return ps[i];
            }
            if (projectLocation.startsWith(location)) {
                return ps[i];
            }
            ++i;
        }
        return null;
    }

    public void updateContext() {
        this.context.setProject(this.getProjectHandle());
        this.context.setProjectLocation(this.getProjectLocation());
        this.context.setProjectTemplate(this.getStringValue(this.templateAdapter));
        this.context.setVersion(this.getStringValue(this.versionAdapter));
    }

    protected String[] getVersionList() {
        return this.template.getVersionList();
    }

    protected String[] getTemplateList(String version) {
        return this.template.getTemplateList(version);
    }

    private String getString(String key) {
        return WizardKeys.getString((String)key.replace(' ', '_'));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (NewWebProjectWizardPage.this.composite == null || NewWebProjectWizardPage.this.composite.isDisposed()) {
                        return;
                    }
                    NewWebProjectWizardPage.this.nameEditor.getFieldEditor(NewWebProjectWizardPage.this.composite).setFocus();
                }
            });
        }
    }

    class InputChangeListener
    implements PropertyChangeListener {
        InputChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NewWebProjectWizardPage.this.setPageComplete(NewWebProjectWizardPage.this.validatePage());
        }
    }

    class LocalValueProvider
    implements IValueProvider,
    IValueChangeListener,
    IAdaptable {
        protected Object value = "";
        protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        LocalValueProvider() {
        }

        public void addValueChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removeValueChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public void fireValueChange(Object oldValue, Object newValue) {
            this.pcs.firePropertyChange("IPropertyEditor.value", oldValue, newValue);
        }

        public Object getValue() {
            return this.value;
        }

        public String getStringValue(boolean returnNullAsEmptyString) {
            Object o = this.getValue();
            return o != null ? o.toString() : (returnNullAsEmptyString ? "" : null);
        }

        public void setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            this.fireValueChange(oldValue, this.value);
        }

        public void valueChange(PropertyChangeEvent event) {
            this.setValue(event.getNewValue());
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IValueProvider.class) {
                return this;
            }
            if (adapter == IValueChangeListener.class) {
                return this;
            }
            Assert.isTrue((boolean)true, (String)("LocalValueProvider instance itself cannot provide adapter for " + adapter.getName()));
            return null;
        }
    }

    class LocationAdapter
    extends LocalValueProvider {
        LocationAdapter() {
        }

        @Override
        public void setValue(Object value) {
            super.setValue(value);
            NewWebProjectWizardPage.this.setPageComplete(NewWebProjectWizardPage.this.validatePage());
        }
    }

    class NameAdapter
    extends LocalValueProvider {
        NameAdapter() {
        }

        @Override
        public void setValue(Object value) {
            super.setValue(value);
            if ("true".equals("" + NewWebProjectWizardPage.this.useDefaultPathAdapter.getValue())) {
                String name = value == null ? "" : value.toString().trim();
                NewWebProjectWizardPage.this.locationAdapter.setValue(NewWebProjectWizardPage.this.defaultPath.append(name).toOSString());
            }
            NewWebProjectWizardPage.this.setPageComplete(NewWebProjectWizardPage.this.validatePage());
        }
    }

    class TemplateAdapter
    extends LocalValueProvider {
        private ILabelProvider labelProvider = new LabelProvider();
        private IListContentProvider listContentProvider = new IListContentProvider(){

            public Object[] getElements(Object inputElement) {
                return NewWebProjectWizardPage.this.getTemplateList(NewWebProjectWizardPage.this.getStringValue(((TemplateAdapter)TemplateAdapter.this).NewWebProjectWizardPage.this.versionAdapter));
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };

        @Override
        public Object getAdapter(Class adapter) {
            if (adapter == IValueProvider.class) {
                return this;
            }
            if (adapter == IValueChangeListener.class) {
                return this;
            }
            if (adapter == ILabelProvider.class) {
                return this.labelProvider;
            }
            if (adapter == IListContentProvider.class) {
                return this.listContentProvider;
            }
            return super.getAdapter(adapter);
        }

        public void fireListChanged() {
            this.pcs.firePropertyChange("IPropertyEditor.listContent", null, null);
        }

        @Override
        public void valueChange(PropertyChangeEvent event) {
            super.valueChange(event);
            if (NewWebProjectWizardPage.this.validationLock == 0) {
                NewWebProjectWizardPage.this.setPageComplete(NewWebProjectWizardPage.this.validatePage());
            }
        }
    }

    class UseDefaultPathAdapter
    extends LocalValueProvider {
        UseDefaultPathAdapter() {
        }

        @Override
        public void setValue(Object value) {
            super.setValue(value);
            if (NewWebProjectWizardPage.this.getControl() != null) {
                NewWebProjectWizardPage.this.locationEditor.getFieldEditor(null).setEnabled("false".equals("" + this.getValue()), (Composite)NewWebProjectWizardPage.this.getControl());
                String name = NewWebProjectWizardPage.this.nameEditor.getValue().toString();
                name = name == null ? "" : name.trim();
                NewWebProjectWizardPage.this.locationAdapter.setValue(NewWebProjectWizardPage.this.defaultPath.append(name).toOSString());
            }
            NewWebProjectWizardPage.this.setPageComplete(NewWebProjectWizardPage.this.validatePage());
        }
    }

    class VersionAdapter
    extends LocalValueProvider {
        private ILabelProvider labelProvider = new LabelProvider();
        private IListContentProvider listContentProvider = new IListContentProvider(){

            public Object[] getElements(Object inputElement) {
                return NewWebProjectWizardPage.this.getVersionList();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };

        @Override
        public Object getAdapter(Class adapter) {
            if (adapter == IValueProvider.class) {
                return this;
            }
            if (adapter == IValueChangeListener.class) {
                return this;
            }
            if (adapter == ILabelProvider.class) {
                return this.labelProvider;
            }
            if (adapter == IListContentProvider.class) {
                return this.listContentProvider;
            }
            return super.getAdapter(adapter);
        }

        @Override
        public void valueChange(PropertyChangeEvent event) {
            super.valueChange(event);
            ++NewWebProjectWizardPage.this.validationLock;
            try {
                String v = NewWebProjectWizardPage.this.templateAdapter.getStringValue(true);
                NewWebProjectWizardPage.this.templateAdapter.fireListChanged();
                if (!v.equals(NewWebProjectWizardPage.this.templateAdapter.getValue())) {
                    NewWebProjectWizardPage.this.templateAdapter.setValue(NewWebProjectWizardPage.this.template.getDefaultTemplate(NewWebProjectWizardPage.this.versionAdapter.getStringValue(true)));
                }
            }
            finally {
                --NewWebProjectWizardPage.this.validationLock;
            }
            NewWebProjectWizardPage.this.setPageComplete(NewWebProjectWizardPage.this.validatePage());
        }
    }
}

