/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.tree;

import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.project.WebProject;

public class TLDTree
implements XFilteredTree {
    XModel model;
    XModelObject root;
    XModelObject[] children = null;

    public void setModel(XModel model) {
        this.model = model;
        this.root = model.getByPath("FileSystems/WEB-ROOT");
    }

    public XModelObject getRoot() {
        return this.root;
    }

    public boolean hasChildren(XModelObject object) {
        return object == this.root || this.root != null && object == this.root.getParent();
    }

    public XModelObject[] getChildren(XModelObject object) {
        if (object == this.root) {
            if (this.children == null) {
                XModelObject[] os = WebProject.getInstance(this.model).getTaglibMapping().getTaglibObjects().values().toArray(new XModelObject[0]);
                this.children = os;
            }
            return this.children;
        }
        return new XModelObject[0];
    }

    public XModelObject getChildAt(XModelObject object, int i) {
        if (object == this.root) {
            this.getChildren(object);
            if (this.children != null) {
                return this.children[i];
            }
        }
        return null;
    }

    public boolean isSelectable(XModelObject object) {
        return object != this.root;
    }

    public String getValue(XModelObject object) {
        if (object == this.root) {
            return "";
        }
        return this.getPath(object);
    }

    public String getPath(XModelObject object) {
        String p = object.getPath();
        if (p == null || !p.startsWith("FileSystems/")) {
            return p;
        }
        return XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
    }

    public void setConstraint(Object object) {
    }

    public XModelObject find(String value) {
        if (value == null || value.length() == 0) {
            return this.root;
        }
        return this.model.getByPath(value);
    }

    public XModelObject getParent(XModelObject object) {
        return object == this.root ? null : this.root;
    }

    public void dispose() {
    }
}

