/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tld;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.filesystems.impl.JarSystemImpl;
import org.jboss.tools.common.model.filesystems.impl.Libs;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.jst.web.tld.ITaglibMapping;

public class TaglibMapping
implements ITaglibMapping {
    private Map<String, String> taglibs = new HashMap<String, String>();
    private Map<String, XModelObject> taglibObjects = new HashMap<String, XModelObject>();
    private Map<String, XModelObject> taglibObjectsCopy = null;
    private Properties resolvedURIs = new Properties();
    private Properties declaredURIs = new Properties();
    private XModel model;
    private long timeStamp = -1L;
    private long jarsTimeStamp = -1L;
    TaglibModelTreeListener listener = null;
    boolean isLoading = false;

    public TaglibMapping(XModel model) {
        this.model = model;
        this.listener = new TaglibModelTreeListener();
        model.addModelTreeListener((XModelTreeListener)this.listener);
    }

    public void revalidate(XModelObject webxml) {
        if (webxml == null || this.isLoading) {
            return;
        }
        this.model = webxml.getModel();
        long jts = this.getJarsTimeStamp();
        if (this.timeStamp == webxml.getTimeStamp() && jts == this.jarsTimeStamp) {
            return;
        }
        this.isLoading = true;
        this.timeStamp = webxml.getTimeStamp();
        this.jarsTimeStamp = jts;
        if (this.model == null) {
            this.model = webxml.getModel();
        }
        this.taglibs.clear();
        this.taglibObjects.clear();
        this.resolvedURIs.clear();
        this.declaredURIs.clear();
        WebProject webprj = WebProject.getInstance(this.model);
        String base = String.valueOf(webprj.getWebInfLocation()) + "/web.xml";
        if (webxml.getChildren().length > 0) {
            XModelObject[] sz = WebAppHelper.getTaglibs(webxml);
            int i = 0;
            while (i < sz.length) {
                String resolvedURI;
                String uri = sz[i].getAttributeValue("taglib-uri");
                String location = sz[i].getAttributeValue("taglib-location");
                this.taglibs.put(uri, webprj.getAbsoluteLocation(location, base));
                XModelObject taglibObject = XModelImpl.getByRelativePath((XModel)this.model, (String)location);
                if (taglibObject != null && (resolvedURI = taglibObject.getAttributeValue("uri")) != null) {
                    this.resolvedURIs.setProperty(uri, resolvedURI);
                    this.declaredURIs.setProperty(resolvedURI, uri);
                }
                ++i;
            }
        }
        this.getFaceletTaglibs(webxml);
        this.loadTldsInWebInf();
        this.findTldsInJars();
        this.taglibObjectsCopy = null;
        this.isLoading = false;
    }

    private void getFaceletTaglibs(XModelObject webxml) {
        XModelObject webRoot = FileSystemsHelper.getWebRoot((XModel)this.model);
        if (webxml == null || webRoot == null) {
            return;
        }
        XModelObject cp = WebAppHelper.findWebAppContextParam(webxml, "facelets.LIBRARIES");
        if (cp == null) {
            cp = WebAppHelper.findWebAppContextParam(webxml, "javax.faces.FACELETS_LIBRARIES");
        }
        if (cp == null) {
            return;
        }
        String paths = cp.getAttributeValue("param-value");
        if (paths == null || paths.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(paths, ";,");
        while (st.hasMoreTokens()) {
            String uri;
            XModelObject facelet;
            String path = st.nextToken();
            String modelPath = path;
            if (modelPath.startsWith("/")) {
                modelPath = modelPath.substring(1);
            }
            if ((facelet = webRoot.getChildByPath(modelPath)) == null || (uri = facelet.getAttributeValue("uri")) == null) continue;
            this.resolvedURIs.put(path, uri);
            this.taglibObjects.put(uri, facelet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, XModelObject> getTaglibObjects() {
        Map<String, XModelObject> result = this.taglibObjectsCopy;
        if (result == null) {
            TaglibMapping taglibMapping = this;
            synchronized (taglibMapping) {
                this.taglibObjectsCopy = new HashMap<String, XModelObject>();
                this.taglibObjectsCopy.putAll(this.taglibObjects);
                result = this.taglibObjectsCopy;
            }
        }
        return result;
    }

    public String getDeclaredURI(String uri) {
        if (this.declaredURIs.containsValue(uri)) {
            return uri;
        }
        return this.declaredURIs.getProperty(uri);
    }

    @Override
    public String resolveURI(String uri) {
        String resolvedURI = this.resolvedURIs.getProperty(uri);
        return resolvedURI == null ? uri : resolvedURI;
    }

    @Override
    public XModelObject getTaglibObject(String uri) {
        XModelObject taglib = this.taglibObjects.get(uri = this.resolveURI(uri));
        if (taglib != null) {
            return taglib;
        }
        String location = this.taglibs.get(uri);
        return this.model == null || location == null ? null : XModelImpl.getByRelativePath((XModel)this.model, (String)location);
    }

    @Override
    public String getTaglibPath(String uri) {
        return this.getTaglibPath(uri, null);
    }

    public synchronized String getTaglibPath(String uri, String base) {
        WebProject webprj = WebProject.getInstance(this.model);
        if (webprj.getWebRootLocation() == null || this.timeStamp == -1L) {
            if (base != null) {
                File file = new File(base);
                while (file != null && file.exists()) {
                    File webInf = new File(file, "WEB-INF");
                    if (webInf.exists() && webInf.isDirectory()) {
                        webprj.setWebRootLocation(file.getAbsolutePath());
                        this.revalidate(WebAppHelper.getWebApp(this.model));
                        break;
                    }
                    file = file.getParentFile();
                }
            }
            if (webprj.getWebRootLocation() == null) {
                return null;
            }
        }
        if (uri.startsWith("urn:jsptld:")) {
            uri = uri.substring(11);
        } else if (uri.startsWith("urn:jsptagdir:")) {
            uri = uri.substring(14);
        }
        String location = this.taglibs.get(uri);
        if (location == null) {
            location = webprj.getAbsoluteLocation(uri, base);
        }
        return location;
    }

    private void loadTldsInWebInf() {
        XModelObject webinf;
        XModelObject xModelObject = webinf = this.model == null ? null : FileSystemsHelper.getWebInf((XModel)this.model);
        if (webinf == null) {
            return;
        }
        IResource r = (IResource)webinf.getAdapter(IResource.class);
        String url = null;
        try {
            if (r != null && r.getLocation() != null) {
                url = r.getLocation().toFile().toURL().toString();
            }
        }
        catch (MalformedURLException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
        if (url != null) {
            this.findTldsInFolder(webinf, url);
        }
    }

    private void findTldsInJars() {
        XModelObject fss = FileSystemsHelper.getFileSystems((XModel)this.model);
        if (fss == null) {
            return;
        }
        XModelObject[] fs = fss.getChildren("FileSystemJar");
        int i = 0;
        while (i < fs.length) {
            String n = fs[i].getAttributeValue("name");
            if (n.startsWith(Libs.LIB_PREFIX)) {
                this.findTldsInJar(fs[i]);
            }
            ++i;
        }
    }

    private long getJarsTimeStamp() {
        XModelObject fss = FileSystemsHelper.getFileSystems((XModel)this.model);
        if (fss == null) {
            return -1L;
        }
        long n = 0L;
        XModelObject[] fs = fss.getChildren("FileSystemJar");
        int i = 0;
        while (i < fs.length) {
            n += fs[i].getTimeStamp();
            ++i;
        }
        return n;
    }

    private void findTldsInJar(XModelObject jar) {
        XModelObject metainf = jar.getChildByPath("META-INF");
        if (metainf == null) {
            return;
        }
        String location = null;
        if (jar instanceof JarSystemImpl) {
            location = ((JarSystemImpl)jar).getTempLocation();
        }
        if (location == null) {
            location = XModelObjectUtil.getExpandedValue((XModelObject)jar, (String)"location", null);
        }
        String url = null;
        try {
            url = "jar:" + new File(location).toURL().toString() + "!/META-INF/";
        }
        catch (MalformedURLException e) {
            WebModelPlugin.getPluginLog().logError("TaglibMapping:findTldsInJar:" + e.getMessage(), (Throwable)e);
            return;
        }
        if (metainf != null) {
            this.findTldsInFolder(metainf, url);
        }
    }

    private void findTldsInFolder(XModelObject folder, String base) {
        XModelObject[] cs = folder.getChildren();
        if (cs == null) {
            return;
        }
        int i = 0;
        while (i < cs.length) {
            if (cs[i].getFileType() == 2) {
                this.findTldsInFolder(cs[i], String.valueOf(base) + cs[i].getAttributeValue("name") + "/");
            } else if (cs[i].getFileType() == 1) {
                String entity = cs[i].getModelEntity().getName();
                boolean ok = entity.startsWith("FileTLD");
                if (!ok && "META-INF".equals(folder.getAttributeValue("name")) && entity.startsWith("FileFaceletTaglib")) {
                    ok = true;
                }
                if (ok) {
                    String uri = cs[i].getAttributeValue("uri");
                    String location = String.valueOf(base) + FileAnyImpl.toFileName((XProperty)cs[i]);
                    if (folder instanceof FolderImpl) {
                        String path = WebProject.getInstance(cs[i].getModel()).getPathInWebRoot(cs[i]);
                        if (uri == null) {
                            WebModelPlugin.getDefault().logWarning("TaglibMapping: null 'uri' from object " + cs[i].getModelEntity().getName());
                        } else if (path != null) {
                            this.resolvedURIs.put(path, uri);
                        }
                    }
                    this.addLocation(uri, location);
                    this.taglibObjects.put(uri, cs[i]);
                }
            }
            ++i;
        }
    }

    public void addLocation(String uri, String location) {
        if (this.taglibs.get(uri) == null) {
            this.taglibs.put(uri, location);
        }
    }

    @Override
    public void invalidate() {
        if (this.timeStamp == -1L || this.isLoading) {
            return;
        }
        this.timeStamp = -1L;
        this.revalidate(WebAppHelper.getWebApp(this.model));
    }

    class TaglibModelTreeListener
    implements XModelTreeListener {
        TaglibModelTreeListener() {
        }

        public void nodeChanged(XModelTreeEvent event) {
        }

        public void structureChanged(XModelTreeEvent event) {
            String path;
            if (TaglibMapping.this.timeStamp == -1L || TaglibMapping.this.isLoading) {
                return;
            }
            if (event.kind() == 1) {
                XModelObject c = (XModelObject)event.getInfo();
                String extension = c.getAttributeValue("extension");
                if ("tld".equals(extension) || "jar".equals(extension)) {
                    TaglibMapping.this.invalidate();
                } else if (c.getModelEntity().getName().equals("FileSystemJar")) {
                    TaglibMapping.this.invalidate();
                }
            } else if (event.kind() == 2 && ((path = event.getInfo().toString()).endsWith(".tld") || path.endsWith(".jar"))) {
                TaglibMapping.this.invalidate();
            }
        }
    }
}

