/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.apt.internal.ui.xml;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.m2e.editor.xml.MvnIndexPlugin;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.IRelevanceCompletionProposal;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.DefaultXMLCompletionProposalComputer;
import org.jboss.tools.maven.apt.preferences.AnnotationProcessingMode;
import org.jboss.tools.maven.apt.ui.preferences.PreferenceMessages;

public class AnnotationProcessingModeCompletionProposalComputer
extends DefaultXMLCompletionProposalComputer {
    private static final String M2E_PROPERTIES_CONTEXT_TYPE = "org.eclipse.m2e.editor.xml.templates.contextType.properties";

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext ctx) {
        if (contentAssistRequest.getParent() == null || contentAssistRequest.getParent().getParentNode() == null) {
            return;
        }
        String containerName = contentAssistRequest.getParent().getParentNode().getNodeName();
        String propertyName = contentAssistRequest.getParent().getNodeName();
        if (!"properties".equals(containerName) && !"m2e.apt.activation".equals(propertyName)) {
            return;
        }
        int offset = contentAssistRequest.getReplacementBeginPosition();
        String prefix = AnnotationProcessingModeCompletionProposalComputer.extractPrefix(ctx.getViewer(), offset);
        contentAssistRequest.setMatchString(prefix);
        contentAssistRequest.setReplacementBeginPosition(offset - prefix.length());
        contentAssistRequest.setReplacementLength(prefix.length());
        this.addTemplateProposals(contentAssistRequest, ctx.getViewer());
    }

    /*
     * Unable to fully structure code
     */
    public static final String extractPrefix(ITextViewer viewer, int offset) {
        i = offset;
        document = viewer.getDocument();
        if (i <= document.getLength()) ** GOTO lbl7
        return "";
        {
            while ((ch = document.getChar(i - 1)) != '>' && ch != '<' && ch != ' ' && ch != '\n' && ch != '\t') {
                --i;
lbl7:
                // 2 sources

                if (i > 0) continue;
            }
            return document.get(i, offset - i);
        }
    }

    private Collection<Template> getTemplates(String prefix) {
        ArrayList<Template> proposals = new ArrayList<Template>(3);
        this.checkAndAdd(proposals, prefix, AnnotationProcessingMode.disabled, PreferenceMessages.AnnotationProcessingSettingsPage_Disabled_Mode_Label);
        this.checkAndAdd(proposals, prefix, AnnotationProcessingMode.jdt_apt, PreferenceMessages.AnnotationProcessingSettingsPage_Jdt_Apt_Mode_Label);
        this.checkAndAdd(proposals, prefix, AnnotationProcessingMode.maven_execution, PreferenceMessages.AnnotationProcessingSettingsPage_Maven_Execution_Mode);
        return proposals;
    }

    protected void checkAndAdd(Collection<Template> proposals, String prefix, AnnotationProcessingMode mode, String description) {
        String name = mode.name();
        if (name.startsWith(prefix)) {
            proposals.add(new Template(name, description, M2E_PROPERTIES_CONTEXT_TYPE, name, false));
        }
    }

    private void addTemplateProposals(ContentAssistRequest request, ITextViewer sourceViewer) {
        String prefix;
        int len;
        int offset = request.getReplacementBeginPosition();
        Region region = new Region(offset, len = (prefix = request.getMatchString()).length());
        TemplateContext templateContext = this.createContext(sourceViewer, (IRegion)region);
        if (templateContext == null) {
            return;
        }
        Collection<Template> proposals = this.getTemplates(prefix);
        for (Template template : proposals) {
            TemplateProposal proposal = this.createProposalForTemplate(prefix, region, templateContext, template);
            request.addProposal((ICompletionProposal)proposal);
        }
    }

    private TemplateProposal createProposalForTemplate(String prefix, Region region, TemplateContext context, final Template template) {
        return new AnnotationProcessingModePropertyProposal(template, context, (IRegion)region){

            public String getAdditionalProposalInfo() {
                return this.getTemplate().getDescription();
            }

            public String getDisplayString() {
                return template.getName();
            }
        };
    }

    private TemplateContext createContext(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = MvnIndexPlugin.getDefault().getTemplateContextRegistry().getContextType(M2E_PROPERTIES_CONTEXT_TYPE);
        if (contextType != null) {
            IDocument document = viewer.getDocument();
            return new DocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
        }
        return null;
    }

    private static class AnnotationProcessingModePropertyProposal
    extends TemplateProposal
    implements IRelevanceCompletionProposal {
        public AnnotationProcessingModePropertyProposal(Template template, TemplateContext context, IRegion region) {
            super(template, context, region, null, 2000);
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            try {
                int replaceOffset = this.getReplaceOffset();
                if (offset >= replaceOffset) {
                    String content = document.get(replaceOffset, offset - replaceOffset);
                    if (!content.isEmpty() && content.charAt(0) == '<') {
                        content = content.substring(1);
                    }
                    return this.getTemplate().getName().toLowerCase().startsWith(content.toLowerCase());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return false;
        }
    }
}

