/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.sourcelookup.ui.actions;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.maven.core.internal.identification.FileIdentificationManager;
import org.jboss.tools.maven.sourcelookup.SourceLookupActivator;
import org.jboss.tools.maven.sourcelookup.containers.JBossSourceContainer;
import org.jboss.tools.maven.sourcelookup.ui.SourceLookupUIActivator;
import org.jboss.tools.maven.sourcelookup.ui.internal.util.SourceLookupUtil;

public class AttachSourcesActionDelegate
implements IEditorActionDelegate {
    private String lastIdentifiedFile;

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor != null) {
            try {
                String value = SourceLookupActivator.getDefault().getAutoAddSourceAttachment();
                if ("never".equals(value)) {
                    return;
                }
                IEditorInput object = targetEditor.getEditorInput();
                if (!(object instanceof IClassFileEditorInput)) {
                    return;
                }
                IClassFileEditorInput input = (IClassFileEditorInput)object;
                IClassFile element = input.getClassFile();
                String className = element.getElementName();
                final boolean isMavenProject = this.isMavenProject(element.getJavaProject());
                String packagePath = null;
                while (element.getParent() != null) {
                    if (element instanceof IPackageFragment) {
                        packagePath = String.valueOf(element.getElementName().replace(".", "/")) + "/" + className.replace(".class", ".java");
                    } else if (element instanceof IPackageFragmentRoot) {
                        File attachementSource;
                        final IPackageFragmentRoot fragment = (IPackageFragmentRoot)element;
                        IPath attachmentPath = fragment.getSourceAttachmentPath();
                        if (attachmentPath != null && !attachmentPath.isEmpty() && (attachementSource = attachmentPath.toFile()).exists() && this.hasSource(attachementSource, packagePath)) break;
                        if (fragment.isArchive()) {
                            File file;
                            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(fragment.getPath());
                            File file2 = file = iFile == null || iFile.getLocation() == null ? fragment.getPath().toFile() : iFile.getLocation().toFile();
                            if (file.getAbsolutePath().equals(this.lastIdentifiedFile)) {
                                return;
                            }
                            final ArtifactKey[] result = new ArtifactKey[1];
                            Job identificationJob = new Job("Identify " + file.getName()){

                                protected IStatus run(IProgressMonitor monitor) {
                                    FileIdentificationManager identificationManager = new FileIdentificationManager();
                                    IStatus status = Status.OK_STATUS;
                                    try {
                                        result[0] = identificationManager.identify(file, monitor);
                                    }
                                    catch (CoreException e) {
                                        status = new Status(4, "org.jboss.tools.maven.sourcelookup.ui", "unable to identify " + file.getName(), (Throwable)e);
                                    }
                                    return status;
                                }
                            };
                            identificationJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                                public void done(IJobChangeEvent event) {
                                    AttachSourcesActionDelegate.this.postIdentification(fragment, file, result[0], !isMavenProject);
                                }
                            });
                            identificationJob.schedule();
                            this.lastIdentifiedFile = file.getAbsolutePath();
                            break;
                        }
                    }
                    element = element.getParent();
                }
            }
            catch (JavaModelException e) {
                SourceLookupUIActivator.log(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasSource(File attachementSource, String className) {
        if (className == null) {
            return false;
        }
        if (attachementSource.isDirectory()) {
            return new File(attachementSource, className).exists();
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile jar = new ZipFile(attachementSource);){
                ZipEntry entry = jar.getEntry(className);
                return entry != null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void postIdentification(final IPackageFragmentRoot fragment, File file, final ArtifactKey artifact, final boolean displayDialog) {
        if (artifact != null) {
            IPath sourcePath = JBossSourceContainer.getSourcePath((ArtifactKey)artifact);
            if (sourcePath == null || !sourcePath.toFile().exists()) {
                JobChangeAdapter listener = new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        IPath sourcePath = JBossSourceContainer.getSourcePath((ArtifactKey)artifact);
                        if (sourcePath != null && sourcePath.toFile().exists()) {
                            SourceLookupUtil.attachSource(fragment, sourcePath, displayDialog);
                        }
                    }
                };
                JBossSourceContainer.downloadArtifact((File)file, (ArtifactKey)artifact, (IJobChangeListener[])new IJobChangeListener[]{listener});
            } else {
                SourceLookupUtil.attachSource(fragment, sourcePath, displayDialog);
            }
        }
    }

    private boolean isMavenProject(IJavaProject javaProject) {
        if (javaProject != null && javaProject.getProject() != null) {
            IProject project = javaProject.getProject();
            try {
                return project.hasNature("org.eclipse.m2e.core.maven2Nature");
            }
            catch (CoreException e) {
                SourceLookupUIActivator.log(e);
            }
        }
        return false;
    }
}

