/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.sourcelookup.ui.preferences;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.maven.sourcelookup.SourceLookupActivator;

public class SourceLookupPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button addContainerButton;
    private RadioGroupFieldEditor addSourceAttachmentEditor;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)layout);
        this.addContainerButton = new Button(composite, 32);
        this.addContainerButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addContainerButton.setSelection(SourceLookupActivator.getDefault().isAutoAddSourceContainer());
        this.addContainerButton.setText("Automatically add the JBoss Maven source container to all JBoss AS launch configurations");
        this.createSourceAttachementControls(composite);
        return composite;
    }

    private void createSourceAttachementControls(Composite parent) {
        String name = "autoAddProjectSourceAttachment";
        String label = "Automatically configure the Java Source Attachment";
        String[][] namesAndValues = new String[][]{{"Always", "always"}, {"Never", "never"}, {"Prompt", "prompt"}};
        this.addSourceAttachmentEditor = new RadioGroupFieldEditor(name, label, 3, namesAndValues, parent, true);
        this.addSourceAttachmentEditor.setPreferenceStore(SourceLookupActivator.getDefault().getPreferenceStore());
        this.addSourceAttachmentEditor.setPage((DialogPage)this);
        this.addSourceAttachmentEditor.load();
    }

    protected void performApply() {
        IEclipsePreferences preferences = SourceLookupActivator.getPreferences();
        preferences.putBoolean("autoAddJBossSourceContainer", this.addContainerButton.getSelection());
        this.addSourceAttachmentEditor.store();
        SourceLookupActivator.getDefault().savePreferences();
    }

    protected void performDefaults() {
        IEclipsePreferences preferences = SourceLookupActivator.getPreferences();
        this.addContainerButton.setSelection(false);
        preferences.putBoolean("autoAddJBossSourceContainer", false);
        this.addSourceAttachmentEditor.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }
}

