/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.springboot.configurators;

import java.util.HashSet;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.j2ee.internal.project.facet.UtilityFacetInstallDataModelProvider;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.maven.ui.Activator;

public class SpringBootProjectConfigurator
extends AbstractProjectConfigurator {
    protected static final IProjectFacet jarUtilityFacet = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
    private static final String ACTIVATION_PROPERTY = "m2e.springboot.activation";

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = request.getMavenProject();
        IProject project = request.getProject();
        this.configureInternal(mavenProject, project, monitor);
    }

    private void configureInternal(MavenProject mavenProject, IProject project, IProgressMonitor monitor) throws CoreException {
        if (!this.isSpringBootConfigurable(mavenProject)) {
            return;
        }
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project, (boolean)true, null);
        String packaging = mavenProject.getPackaging();
        if ("jar".equals(packaging) && fproj != null && !fproj.hasProjectFacet(jarUtilityFacet)) {
            this.installJarUtilityFacet(fproj, monitor);
        }
    }

    private boolean isSpringBootConfigurable(MavenProject mavenProject) {
        boolean configureSpringBoot;
        String springBootActivation = mavenProject.getProperties().getProperty(ACTIVATION_PROPERTY);
        if (springBootActivation == null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            configureSpringBoot = store.getBoolean("configureSpringBoot");
        } else {
            configureSpringBoot = Boolean.valueOf(springBootActivation);
        }
        return configureSpringBoot;
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = event.getMavenProject();
        if (event.getFlags() == 1 && facade != null) {
            IProject project = facade.getProject();
            MavenProject mavenProject = facade.getMavenProject(monitor);
            this.configureInternal(mavenProject, project, monitor);
        }
        super.mavenProjectChanged(event, monitor);
    }

    private void installJarUtilityFacet(IFacetedProject fproj, IProgressMonitor monitor) throws CoreException {
        IProjectFacetVersion facetVersion;
        if (!fproj.hasProjectFacet(jarUtilityFacet) && (facetVersion = jarUtilityFacet.getDefaultVersion()) != null) {
            HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
            WTPProjectsUtil.installJavaFacet(actions, (IProject)fproj.getProject(), (IFacetedProject)fproj);
            IDataModel model = (IDataModel)new UtilityFacetInstallDataModelProvider().create();
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, (Object)model));
            fproj.modify(actions, monitor);
        }
    }
}

