/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.ui.internal.project.facet;

import org.apache.maven.model.Model;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.jboss.tools.maven.ui.Activator;
import org.jboss.tools.maven.ui.Messages;

public class MavenFacetInstallPage
extends DataModelWizardPage
implements IFacetWizardPage {
    private static final String SEAM_FACET_ID = "jst.seam";
    private Text groupId;
    private Text artifactId;
    private Text version;
    private Combo packaging;
    private Text description;
    private Text name;
    public static final IProjectFacet SEAM_FACET = ProjectFacetsManager.isProjectFacetDefined((String)"jst.seam") ? ProjectFacetsManager.getProjectFacet((String)"jst.seam") : null;

    public MavenFacetInstallPage() {
        super(DataModelFactory.createDataModel((IDataModelProvider)new AbstractDataModelProvider(){}), "jboss.m2.facet.install.page");
        this.setTitle(Messages.MavenFacetInstallPage_JBoss_M2_capabilities);
        this.setDescription(Messages.MavenFacetInstallPage_Add_M2_capabilities_to_this_Web_Project);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        String projectName = this.getDataModel().getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        IProject project = null;
        if (projectName != null && projectName.trim().length() > 0) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        boolean mavenProjectExists = false;
        if (project != null && project.isOpen()) {
            try {
                boolean hasMavenNature = project.hasNature("org.eclipse.m2e.core.maven2Nature");
                IFile pom = project.getFile("pom.xml");
                if (hasMavenNature && pom.exists()) {
                    this.getDataModel().setBooleanProperty("mavenProjectExists", true);
                    mavenProjectExists = true;
                    MavenPlugin.getDefault();
                    MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
                    Model mavenModel = modelManager.readMavenModel(pom);
                    String groupId = mavenModel.getGroupId();
                    this.model.setStringProperty("groupId", groupId);
                    String artifactId = mavenModel.getArtifactId();
                    this.model.setStringProperty("artifactId", artifactId);
                    String version = mavenModel.getVersion();
                    this.model.setStringProperty("version", version);
                    String packaging = mavenModel.getPackaging();
                    this.model.setStringProperty("packaging", packaging);
                    String name = mavenModel.getName();
                    this.model.setStringProperty("name", name);
                    String description = mavenModel.getDescription();
                    this.model.setStringProperty("description", description);
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        this.groupId = this.createField(composite, Messages.MavenFacetInstallPage_Group_Id, "groupId");
        this.artifactId = this.createField(composite, Messages.MavenFacetInstallPage_Artifact_Id, "artifactId");
        if (!mavenProjectExists) {
            this.artifactId.setText(projectName);
        }
        this.version = this.createField(composite, Messages.MavenFacetInstallPage_Version, "version");
        Label packagingLabel = new Label(composite, 0);
        packagingLabel.setText(Messages.MavenFacetInstallPage_Packaging);
        this.packaging = new Combo(composite, 8);
        gd = new GridData(768);
        this.packaging.setLayoutData((Object)gd);
        String[] items = new String[]{"war", "ear", "ejb", "jar"};
        this.packaging.setItems(items);
        this.synchHelper.synchCombo(this.packaging, "packaging", null);
        try {
            IFacetedProjectWorkingCopy fpwc = (IFacetedProjectWorkingCopy)this.getDataModel().getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            if (!mavenProjectExists) {
                if (fpwc.hasProjectFacet(WebFacetUtils.WEB_FACET)) {
                    this.packaging.select(0);
                } else if (fpwc.hasProjectFacet(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET)) {
                    this.packaging.select(1);
                } else if (fpwc.hasProjectFacet(IJ2EEFacetConstants.EJB_FACET)) {
                    this.packaging.select(2);
                } else {
                    this.packaging.select(3);
                }
            } else {
                String mavenPackaging = this.getDataModel().getStringProperty("packaging");
                this.packaging.setText(mavenPackaging);
            }
            this.name = this.createField(composite, Messages.MavenFacetInstallPage_Name, "name");
            this.name.setText(projectName);
            this.description = this.createField(composite, Messages.MavenFacetInstallPage_Description, "description");
            if (SEAM_FACET != null && !mavenProjectExists && fpwc.hasProjectFacet(SEAM_FACET)) {
                Text seamVersion = this.createField(composite, Messages.MavenFacetInstallPage_Seam_Maven_version, "seamMavenVersion");
                IProjectFacetVersion seamFacetVersion = fpwc.getProjectFacetVersion(SEAM_FACET);
                if ("2.0".equals(seamFacetVersion.getVersionString())) {
                    seamVersion.setText("2.0.2.SP1");
                } else if ("2.1".equals(seamFacetVersion.getVersionString())) {
                    seamVersion.setText("2.1.2.GA");
                } else if ("2.2".equals(seamFacetVersion.getVersionString())) {
                    seamVersion.setText("2.2.2.Final");
                } else if ("2.3".equals(seamFacetVersion.getVersionString())) {
                    seamVersion.setText("2.3.0.Final");
                }
                Button removeWTPContainers = new Button(composite, 32);
                removeWTPContainers.setText(Messages.MavenFacetInstallPage_Remove_WTP_Classpath_containers);
                this.synchHelper.synchCheckbox(removeWTPContainers, "removeWTPClasspathContainers", null);
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
        if (mavenProjectExists) {
            this.artifactId.setEditable(false);
            this.groupId.setEditable(false);
            this.version.setEditable(false);
            this.name.setEditable(false);
            this.description.setEditable(false);
            this.packaging.setEnabled(false);
        }
        this.getDataModel().addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                String projectName;
                String propertyName = event.getPropertyName();
                if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName) && (projectName = MavenFacetInstallPage.this.getDataModel().getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME")) != null) {
                    MavenFacetInstallPage.this.artifactId.setText(projectName);
                }
            }
        });
        return composite;
    }

    private Text createField(Composite composite, String labelText, String property) {
        Label label = new Label(composite, 0);
        label.setText(labelText);
        Text text = new Text(composite, 2052);
        GridData gd = new GridData(768);
        text.setLayoutData((Object)gd);
        this.synchHelper.synchText(text, property, null);
        return text;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"groupId", "artifactId", "version", "packaging"};
    }

    public void setConfig(Object config) {
        this.model.removeListener((IDataModelListener)this);
        this.synchHelper.dispose();
        this.model = (IDataModel)config;
        this.model.addListener((IDataModelListener)this);
        this.synchHelper = this.initializeSynchHelper(this.model);
    }

    public void dispose() {
        this.model.removeListener((IDataModelListener)this);
        super.dispose();
    }

    public void setWizardContext(IWizardContext context) {
    }

    public void transferStateToConfig() {
    }
}

