/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.ui.wizard;

import java.util.Map;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.maven.ui.Activator;
import org.jboss.tools.maven.ui.wizard.ConfigureMavenRepositoriesWizardPage;

public class ConfigureMavenRepositoriesWizard
extends Wizard
implements INewWizard {
    private ConfigureMavenRepositoriesWizardPage page;
    private ArtifactKey artifactKey;
    private String preSelectedProfileId;
    private Map<String, String> preconfiguredRepositoryUrls;

    public ConfigureMavenRepositoriesWizard() {
        this.setWindowTitle("Maven Repositories");
    }

    public ConfigureMavenRepositoriesWizard(ArtifactKey artifactKey) {
        this();
        this.artifactKey = artifactKey;
    }

    public ConfigureMavenRepositoriesWizard(ArtifactKey artifactKey, String profileId) {
        this(artifactKey);
        this.preSelectedProfileId = profileId;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initializeDefaultPageImageDescriptor();
    }

    private void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)"org.jboss.tools.maven.ui", (String)"icons/MavenRepositoryWizBan.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean performFinish() {
        return this.page.finishPage();
    }

    public void addPages() {
        this.page = new ConfigureMavenRepositoriesWizardPage(this.artifactKey, this.preSelectedProfileId);
        this.page.addPreconfiguredRepositories(this.preconfiguredRepositoryUrls);
        this.addPage((IWizardPage)this.page);
    }

    public void addPage(IWizardPage page) {
        IWizardContainer container = this.getContainer();
        if (container instanceof IPageChangeProvider && page instanceof IPageChangedListener) {
            ((IPageChangeProvider)container).addPageChangedListener((IPageChangedListener)page);
        }
        super.addPage(page);
    }

    public void dispose() {
        IWizardContainer container = this.getContainer();
        if (container instanceof IPageChangeProvider) {
            IWizardPage[] iWizardPageArray = this.getPages();
            int n = iWizardPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                if (page instanceof IPageChangedListener) {
                    ((IPageChangeProvider)container).removePageChangedListener((IPageChangedListener)page);
                }
                ++n2;
            }
        }
        super.dispose();
    }

    public void addPreconfiguredRepositories(Map<String, String> repositoryUrls) {
        this.preconfiguredRepositoryUrls = repositoryUrls;
    }
}

