/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.ui.wizard;

import org.apache.maven.settings.Repository;
import org.eclipse.core.runtime.Assert;

public class RepositoryWrapper
implements Comparable<RepositoryWrapper> {
    public static final String SEPARATOR = "/";
    private Repository repository;
    private String profileId;
    private String url;

    public RepositoryWrapper(Repository repository, String profileId) {
        Assert.isNotNull((Object)repository);
        this.repository = repository;
        this.profileId = profileId;
        this.url = repository.getUrl();
        if (this.url != null) {
            this.url = this.url.trim();
            if (!this.url.endsWith(SEPARATOR)) {
                this.url = String.valueOf(this.url) + SEPARATOR;
            }
        }
    }

    public RepositoryWrapper(Repository repository) {
        this(repository, repository == null ? null : repository.getId());
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public String getProfileId() {
        if (this.profileId == null && this.repository != null) {
            this.profileId = this.repository.getId();
        }
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getDisplayName() {
        String name = this.repository.getName() == null ? "<no-name>" : this.repository.getName();
        return String.valueOf(name) + "-" + this.repository.getUrl();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryWrapper other = (RepositoryWrapper)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        String name = this.repository.getName() == null ? "<no-name>" : this.repository.getName();
        return String.valueOf(name) + "-" + this.repository.getUrl();
    }

    @Override
    public int compareTo(RepositoryWrapper o) {
        if (o == null) {
            return 1;
        }
        String s = this.getDisplayName();
        if (s == null) {
            return -1;
        }
        return s.compareTo(o.getDisplayName());
    }

    protected RepositoryWrapper clone() throws CloneNotSupportedException {
        RepositoryWrapper wrapper = this.repository != null ? new RepositoryWrapper(this.repository.clone()) : new RepositoryWrapper(this.repository);
        wrapper.setProfileId(new String(this.profileId));
        return wrapper;
    }
}

