/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter;

import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.IClient;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.MinishiftBinaryUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.AbstractCDKPoller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK32Server;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.OpenShiftNotReadyPollingException;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CDKLaunchUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CommandTimeoutException;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKLaunchEnvironmentUtil;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironment;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironmentLoader;
import org.jboss.tools.openshift.core.LazySSLCertificateCallback;

public class MinishiftPoller
extends AbstractCDKPoller {
    @Override
    protected void launchThread() {
        this.launchThread("CDK Minishift Poller");
    }

    @Override
    protected Map<String, String> createEnvironment(IServer server) {
        return CDKLaunchEnvironmentUtil.createEnvironment(server);
    }

    public int getTimeoutBehavior() {
        return 2;
    }

    private File getWorkingDirectory(IServer s) throws IServerStatePoller.PollingException {
        File f = JBossServerCorePlugin.getServerStateLocation((IServer)s).toFile();
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    @Override
    protected IStatus onePing(IServer server, Map<String, String> env) throws IServerStatePoller.PollingException, IOException, TimeoutException {
        String[] args = new String[]{"status"};
        args = CDK32Server.getArgsWithProfile(server, args);
        String vagrantcmdloc = MinishiftBinaryUtility.getMinishiftLocation(server);
        try {
            String[] lines = CDKLaunchUtility.callMachineReadable(vagrantcmdloc, args, this.getWorkingDirectory(server), env);
            IStatus stat = this.parseOutput(lines);
            if (stat.isOK()) {
                this.checkOpenShiftHealth(server, 4000);
                return stat;
            }
            return stat;
        }
        catch (CommandTimeoutException vte) {
            List<String> inLines = vte.getInLines();
            if (inLines != null) {
                String[] asArr = inLines.toArray(new String[inLines.size()]);
                IStatus stat = this.parseOutput(asArr);
                if (stat.isOK()) {
                    this.checkOpenShiftHealth(server, 4000);
                } else {
                    return stat;
                }
            }
            CDKCoreActivator.pluginLog().logError("Unable to successfully complete a call to vagrant status. ", (Throwable)vte);
            throw vte;
        }
    }

    protected IStatus parseOutput(String[] lines) {
        if (lines.length == 1 && lines[0] != null) {
            if ("Running".equals(lines[0])) {
                return Status.OK_STATUS;
            }
            if ("Stopped".equals(lines[0]) || "Does Not Exist".equals(lines[0])) {
                return CDKCoreActivator.statusFactory().errorStatus("minishift status indicates the CDK is stopped.");
            }
        }
        CDKCoreActivator.statusFactory();
        return StatusFactory.infoStatus((String)"org.jboss.tools.openshift.cdk.server.core", (String)"minishift status indicates the CDK is starting.");
    }

    private boolean checkOpenShiftHealth(IServer server, int timeout) throws OpenShiftNotReadyPollingException {
        ServiceManagerEnvironment adb = ServiceManagerEnvironmentLoader.type(server).getOrLoadServiceManagerEnvironment(server, true, true);
        if (adb == null) {
            return false;
        }
        String url = String.valueOf(adb.getOpenShiftHost()) + ":" + adb.getOpenShiftPort();
        return this.checkOpenShiftHealth(url, timeout);
    }

    protected boolean checkOpenShiftHealth(String url, int timeout) throws OpenShiftNotReadyPollingException {
        LazySSLCertificateCallback sslCallback = new LazySSLCertificateCallback();
        IClient client = new ClientBuilder(url).sslCertificateCallback((ISSLCertificateCallback)sslCallback).withConnectTimeout(timeout, TimeUnit.MILLISECONDS).build();
        OpenShiftException e = null;
        try {
            String v = client.getServerReadyStatus();
            if ("ok".equals(v)) {
                return true;
            }
        }
        catch (OpenShiftException ex) {
            e = ex;
        }
        String msg = NLS.bind((String)"The CDK VM is up and running, but OpenShift is unreachable at url {0}. The VM may not have been registered successfully. Please check your console output for more information", (Object)url);
        CDKCoreActivator.statusFactory();
        throw new OpenShiftNotReadyPollingException(StatusFactory.errorStatus((String)"org.jboss.tools.openshift.cdk.server.core", (String)msg, (Throwable)e, (int)10001));
    }
}

