/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.detection;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;
import org.jboss.tools.openshift.cdk.server.core.internal.detection.AbstractCDKRuntimeDetector;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;

public class CDKRuntimeDetector
extends AbstractCDKRuntimeDetector {
    public static final String CDK_RUNTIME_TYPE = "CDK";
    public static final String DOT_CDK_BOX_VERSION = "cdk.box.version";

    @Override
    protected boolean matches(RuntimeDefinition def, IServer server) {
        String s = server.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        return s != null && new File(s).equals(def.getLocation());
    }

    @Override
    protected String getServerType() {
        return "org.jboss.tools.openshift.cdk.server.type";
    }

    @Override
    protected String[] getRequiredChildren() {
        return new String[]{"Vagrantfile", ".cdk"};
    }

    @Override
    protected String getDefinitionName(File root) {
        return CDKServer.getServerTypeBaseName();
    }

    @Override
    protected String getRuntimeDetectionType() {
        return CDK_RUNTIME_TYPE;
    }

    @Override
    protected String getDefinitionVersion(File root) {
        File cdkFile = new File(root, ".cdk");
        Properties props = this.readProperties(cdkFile);
        String version = props.getProperty(DOT_CDK_BOX_VERSION);
        version = version == null ? "2.0" : version;
        return version;
    }

    @Override
    protected void initializeServer(IServerWorkingCopy wc, RuntimeDefinition runtimeDefinition) throws CoreException {
        String folder = runtimeDefinition.getLocation().getAbsolutePath();
        File cdkFile = new File(folder, ".cdk");
        Properties props = this.readProperties(cdkFile);
        String user = props.getProperty("rhel.subscription.username");
        String password = System.getenv("rhel.subscription.password");
        if (user != null) {
            this.addToCredentialsModel("access.redhat.com", user, password);
        }
        wc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", folder);
        wc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.username", user);
    }
}

