/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironment;
import org.jboss.tools.openshift.common.core.connection.ConnectionType;
import org.jboss.tools.openshift.common.core.connection.ConnectionsFactoryTracker;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistry;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.core.connection.Connection;

public class CDKOpenshiftUtility {
    public IConnection findExistingOpenshiftConnection(IServer server, ServiceManagerEnvironment adb) {
        Collection connections = ConnectionsRegistrySingleton.getInstance().getAll();
        for (IConnection c : connections) {
            if (!this.serverMatchesConnection(server, c, adb)) continue;
            return c;
        }
        return null;
    }

    public IConnection[] findExistingOpenshiftConnections(IServer server, ServiceManagerEnvironment adb) {
        Collection connections = ConnectionsRegistrySingleton.getInstance().getAll();
        ArrayList<IConnection> ret = new ArrayList<IConnection>();
        for (IConnection c : connections) {
            if (!this.serverMatchesConnection(server, c, adb)) continue;
            ret.add(c);
        }
        return ret.toArray(new IConnection[ret.size()]);
    }

    public boolean serverMatchesConnection(IServer server, IConnection c, ServiceManagerEnvironment adb) {
        String host;
        String soughtHost = String.valueOf(adb.openshiftHost) + ":" + adb.openshiftPort;
        return c.getType() == ConnectionType.Kubernetes && (host = c.getHost()).equals(soughtHost);
    }

    public MultiStatus serverConnectionMatchError(IServer server, IConnection c, ServiceManagerEnvironment adb) {
        MultiStatus ms = new MultiStatus("org.jboss.tools.openshift.cdk.server.core", 0, "Server " + server.getName() + " fails to match openshift connection " + c.toString() + ".", null);
        String soughtHost = String.valueOf(adb.openshiftHost) + ":" + adb.openshiftPort;
        if (c.getType() != ConnectionType.Kubernetes) {
            ms.add((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "Connection type is expected to be kubernetes."));
        } else {
            String host = c.getHost();
            if (!host.equals(soughtHost)) {
                ms.add((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "Host is " + host + " but is expected to be " + soughtHost));
            }
        }
        return ms;
    }

    public IConnection createOpenshiftConnection(ServiceManagerEnvironment env) {
        return this.createOpenshiftConnection(env, ConnectionsRegistrySingleton.getInstance());
    }

    public IConnection createOpenshiftConnection(ServiceManagerEnvironment env, ConnectionsRegistry registry) {
        String soughtHost = String.valueOf(env.openshiftHost) + ":" + env.openshiftPort;
        ConnectionsFactoryTracker connectionsFactory = new ConnectionsFactoryTracker();
        connectionsFactory.open();
        IConnectionFactory factory = connectionsFactory.getById("org.jboss.tools.openshift.core.ConnectionFactory");
        IConnection con = factory.create(soughtHost);
        String authScheme = env.getAuthorizationScheme();
        String username = env.getUsername();
        String password = env.getPassword();
        if (authScheme != null && !authScheme.isEmpty()) {
            authScheme = String.valueOf(new String("" + authScheme.charAt(0)).toUpperCase()) + authScheme.substring(1);
        }
        ((Connection)con).setAuthScheme(authScheme);
        ((Connection)con).setUsername(username);
        if (password != null) {
            ((Connection)con).setPassword(password);
        }
        ((Connection)con).setRememberPassword(true);
        String ocLoc = env.get("cdk.oc.location.jbt.prop");
        if (ocLoc != null) {
            ((Connection)con).setExtendedProperty("org.jbosstools.openshift.core.connection.ext.oc.location", (Object)ocLoc);
            ((Connection)con).setExtendedProperty("org.jbosstools.openshift.core.connection.ext.oc.override", (Object)true);
        }
        this.updateOpenshiftConnection(env, con, false);
        if (registry != null) {
            registry.add(con);
        }
        return con;
    }

    public void updateOpenshiftConnection(ServiceManagerEnvironment env, IConnection con) {
        this.updateOpenshiftConnection(env, con, true);
    }

    public void updateOpenshiftConnection(ServiceManagerEnvironment env, IConnection con, boolean fireUpdate) {
        String dockerReg = env.getDockerRegistry();
        ((Connection)con).setExtendedProperty("org.jbosstools.openshift.core.connection.ext.registry.url", (Object)dockerReg);
        if (fireUpdate) {
            ConnectionsRegistrySingleton.getInstance().update(con, con);
        }
    }
}

