/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.VagrantBinaryUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK32Server;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKLaunchEnvironmentUtil;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKServerUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironment;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironmentLoader;

public class VagrantServiceManagerEnvironmentLoader
extends ServiceManagerEnvironmentLoader {
    private static final String DEFAULT_IMAGE_REGISTRY_URL = "https://hub.openshift.rhel-cdk.10.1.2.2.xip.io";

    public VagrantServiceManagerEnvironmentLoader() {
        super(1);
    }

    public ServiceManagerEnvironment loadServiceManagerEnvironment(IServer server) {
        return this.loadServiceManagerEnvironment(server, false);
    }

    @Override
    public ServiceManagerEnvironment loadServiceManagerEnvironment(IServer server, boolean suppressErrors) {
        block4: {
            Map<String, String> adbEnv = this.loadDockerEnv(server);
            if (adbEnv != null) {
                Properties dotcdkProps = CDKServerUtility.getDotCDK(server);
                Map<String, String> merged = this.merge(adbEnv, dotcdkProps);
                try {
                    if (merged != null) {
                        merged.put("jbt.default.DOCKER_REGISTRY", DEFAULT_IMAGE_REGISTRY_URL);
                        return new ServiceManagerEnvironment(merged);
                    }
                }
                catch (URISyntaxException urise) {
                    if (suppressErrors) break block4;
                    String err = "Environment variable DOCKER_HOST is not a valid uri:  " + merged.get("DOCKER_HOST");
                    CDKCoreActivator.pluginLog().logError(err, (Throwable)urise);
                }
            }
        }
        return null;
    }

    protected Map<String, String> loadDockerEnv(IServer server) {
        Map<String, String> env = this.getEnv(server);
        String[] args = new String[]{"service-manager", "env"};
        args = CDK32Server.getArgsWithProfile(server, args);
        String cmdLoc = VagrantBinaryUtility.getVagrantLocation(server);
        File wd = CDKServerUtility.getWorkingDirectory(server);
        try {
            HashMap<String, String> adbEnv = this.callAndParseEnvVar(env, args, cmdLoc, wd);
            return adbEnv;
        }
        catch (IOException ioe) {
            CDKCoreActivator.pluginLog().logError("Unable to successfully complete a call to \"vagrant service-manager env\"", (Throwable)ioe);
            return null;
        }
    }

    protected Map<String, String> getEnv(IServer server) {
        Map<String, String> env = CDKLaunchEnvironmentUtil.createEnvironment(server);
        env.put("VAGRANT_NO_COLOR", "1");
        return env;
    }
}

