/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyTextCommand;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK32Server;
import org.jboss.tools.openshift.cdk.server.core.internal.detection.MinishiftVersionLoader;
import org.jboss.tools.openshift.cdk.server.ui.internal.MinishiftLocationSection;

public class CDK32LocationSection
extends MinishiftLocationSection {
    private Text msProfileText;
    private ModifyListener msProfileListener;

    @Override
    protected void fillUI(FormToolkit toolkit, Composite composite) {
        super.fillUI(toolkit, composite);
        this.createMinishiftProfileWidgets(toolkit, composite);
    }

    @Override
    protected void setDefaultValues() {
        super.setDefaultValues();
        String profile = this.server.getAttribute("minishift.profile", "");
        this.msProfileText.setText(profile);
    }

    protected void createMinishiftProfileWidgets(FormToolkit toolkit, Composite composite) {
        toolkit.createLabel(composite, "Minishift Profile:");
        this.msProfileText = toolkit.createText(composite, "", 2052);
        this.msProfileText.setLayoutData((Object)GridDataFactory.defaultsFor((Control)this.msProfileText).span(4, 1).minSize(150, -1).create());
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.msProfileListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDK32LocationSection.this.execute((IUndoableOperation)new SetMinishiftProfilePropertyCommand(CDK32LocationSection.this.server));
            }
        };
        this.msProfileText.addModifyListener(this.msProfileListener);
        this.msProfileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDK32LocationSection.this.validate();
            }
        });
    }

    @Override
    protected String isVersionCompatible(MinishiftVersionLoader.MinishiftVersions versions) {
        String cdkVers = versions.getCDKVersion();
        if (cdkVers == null) {
            return "Cannot determine CDK version.";
        }
        if (CDK32Server.matchesCDK32(cdkVers)) {
            return null;
        }
        return "CDK version " + cdkVers + " is not compatible with this server adapter.";
    }

    public class SetMinishiftProfilePropertyCommand
    extends ServerWorkingCopyPropertyTextCommand {
        public SetMinishiftProfilePropertyCommand(IServerWorkingCopy server) {
            super(server, "Change Minishift Profile", CDK32LocationSection.this.msProfileText, CDK32LocationSection.this.msProfileText.getText(), "minishift.profile", CDK32LocationSection.this.msProfileListener);
        }
    }
}

