/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.jboss.tools.openshift.cdk.server.core.internal.MinishiftBinaryUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK3Server;
import org.jboss.tools.openshift.cdk.server.core.internal.detection.MinishiftVersionLoader;
import org.jboss.tools.openshift.cdk.server.ui.internal.CDKServerWizardFragment;

public class CDK3ServerWizardFragment
extends CDKServerWizardFragment {
    private Combo hypervisorCombo;
    private String selectedHypervisor;
    private Job longValidation;
    private MinishiftVersionLoader.MinishiftVersions minishiftVersionProps = null;

    @Override
    public Composite createComposite(Composite parent, IWizardHandle handle) {
        String title = "Red Hat Container Development Environment";
        String desc = "A server adapter representing Red Hat Container Development Kit Version 3.";
        String label = "Minishift Binary: ";
        return this.createComposite(parent, handle, title, desc, label);
    }

    @Override
    protected Composite createComposite(Composite parent, IWizardHandle handle, String title, String desc, String homeLabel) {
        Composite main = this.setupComposite(parent, handle, title, desc);
        this.createCredentialWidgets(main);
        this.createHypervisorWidgets(main);
        this.createLocationWidgets(main, homeLabel);
        this.validateAndPack(main);
        return main;
    }

    protected void createHypervisorWidgets(Composite main) {
        int ind;
        Label l = new Label(main, 0);
        l.setText("Hypervisor:");
        GridData comboData = new GridData();
        comboData.grabExcessHorizontalSpace = true;
        comboData.horizontalAlignment = 4;
        comboData.horizontalSpan = 2;
        this.hypervisorCombo = new Combo(main, 2060);
        this.hypervisorCombo.setLayoutData((Object)comboData);
        this.hypervisorCombo.setItems(CDK3Server.getHypervisors());
        this.hypervisorCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int ind = CDK3ServerWizardFragment.this.hypervisorCombo.getSelectionIndex();
                if (ind != -1) {
                    CDK3ServerWizardFragment.this.selectedHypervisor = CDK3ServerWizardFragment.this.hypervisorCombo.getItem(ind);
                }
                CDK3ServerWizardFragment.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (this.hypervisorCombo.getItems().length > 0) {
            this.hypervisorCombo.select(0);
        }
        if ((ind = this.hypervisorCombo.getSelectionIndex()) != -1) {
            this.selectedHypervisor = this.hypervisorCombo.getItem(ind);
        }
    }

    @Override
    protected String findError() {
        if (this.credentials.getDomain() == null || this.credentials.getUser() == null) {
            return "The Container Development Environment Server Adapter requires Red Hat Access credentials.";
        }
        if (this.selectedHypervisor == null) {
            return "You must choose a hypervisor.";
        }
        String retString = this.validateHomeDirectory();
        if (retString != null) {
            return retString;
        }
        return this.validateMinishiftVersion();
    }

    protected String validateMinishiftVersion() {
        String ret = null;
        if (this.minishiftVersionProps == null) {
            ret = "Unknown error when checking minishift version: " + this.homeDir;
        } else if (!this.minishiftVersionProps.isValid()) {
            ret = this.minishiftVersionProps.getError();
            if (ret == null) {
                ret = "Unknown error while checking minishift version";
            }
        } else {
            String versionCompatError = this.isVersionCompatible(this.minishiftVersionProps);
            if (versionCompatError != null) {
                ret = versionCompatError;
            }
        }
        this.toggleHomeDecorator(ret);
        return ret;
    }

    @Override
    protected String validateHomeDirectory() {
        String retString = null;
        if (this.homeDir == null || !new File(this.homeDir).exists()) {
            retString = "The selected file does not exist.";
        } else if (!new File(this.homeDir).canExecute()) {
            retString = "The selected file is not executable.";
        }
        this.toggleHomeDecorator(retString);
        return retString;
    }

    protected String isVersionCompatible(MinishiftVersionLoader.MinishiftVersions versions) {
        String cdkVers = versions.getCDKVersion();
        if (cdkVers == null) {
            return "Cannot determine CDK version.";
        }
        if (CDK3Server.matchesCDK3(cdkVers)) {
            return null;
        }
        return "CDK version " + cdkVers + " is not compatible with this server adapter.";
    }

    @Override
    protected void browseHomeDirClicked() {
        this.browseHomeDirClicked(false);
    }

    @Override
    protected SelectionListener createBrowseListener() {
        return new CDKServerWizardFragment.BrowseListener(this){

            @Override
            public void widgetSelected(SelectionEvent e) {
                CDK3ServerWizardFragment.this.minishiftVersionProps = null;
                super.widgetSelected(e);
                CDK3ServerWizardFragment.this.kickValidationJob();
            }
        };
    }

    @Override
    protected ModifyListener createHomeModifyListener() {
        return new CDKServerWizardFragment.HomeModifyListener(this){

            @Override
            public void modifyText(ModifyEvent e) {
                CDK3ServerWizardFragment.this.minishiftVersionProps = null;
                super.modifyText(e);
                CDK3ServerWizardFragment.this.kickValidationJob();
            }
        };
    }

    private synchronized void kickValidationJob() {
        File f;
        if (this.longValidation != null) {
            this.longValidation.cancel();
        }
        if (!(f = new File(this.homeDir)).exists() || !f.canExecute()) {
            this.validate();
            return;
        }
        this.handle.setMessage("Checking minishift version...", 1);
        this.setComplete(false);
        this.handle.update();
        this.longValidation = new Job("Validate minishift location"){

            protected IStatus run(IProgressMonitor monitor) {
                CDK3ServerWizardFragment.this.minishiftVersionProps = MinishiftVersionLoader.getVersionProperties(CDK3ServerWizardFragment.this.homeDir);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CDK3ServerWizardFragment.this.validate();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.longValidation.setSystem(true);
        this.longValidation.schedule(750L);
    }

    @Override
    protected void fillTextField() {
        if (this.homeDir != null) {
            this.homeText.setText(this.homeDir);
        } else {
            this.homeDir = MinishiftBinaryUtility.getMinishiftLocation();
            if (this.homeDir != null) {
                this.homeText.setText(this.homeDir);
            }
        }
    }

    @Override
    public void performFinish(IProgressMonitor monitor) throws CoreException {
        this.exit();
        IServer s = this.getServerFromTaskModel();
        if (s instanceof IServerWorkingCopy) {
            IServerWorkingCopy swc = (IServerWorkingCopy)s;
            swc.setAttribute("minishift.file.location", this.homeDir);
            swc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.username", this.selectedUser);
            swc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.hypervisor", this.selectedHypervisor);
        }
    }
}

