/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyComboCommand;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyTextCommand;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK3Server;
import org.jboss.tools.openshift.cdk.server.core.internal.detection.MinishiftVersionLoader;
import org.jboss.tools.openshift.cdk.server.ui.internal.AbstractLocationSection;

public class MinishiftLocationSection
extends AbstractLocationSection {
    private static String SECTION_TITLE = "CDK Details";
    private static String LABEL_STRING = "Minishift Binary: ";
    private static String COMMAND_NAME = "Modify Minishift Location";
    private static String LOC_ATTR = "minishift.file.location";
    private Combo hypervisorCombo;
    private Job longValidation;
    private MinishiftVersionLoader.MinishiftVersions minishiftVersionProps = null;
    Text msHomeText;
    Button msHomeBrowse;
    ControlDecoration msHomeDecor;
    SelectionListener msHomeSelListener;
    ModifyListener msHomeModListener;

    public MinishiftLocationSection() {
        super(SECTION_TITLE, LABEL_STRING, COMMAND_NAME, LOC_ATTR);
    }

    @Override
    protected void fillUI(FormToolkit toolkit, Composite composite) {
        this.createHypervisorWidgets(toolkit, composite);
        this.createLocationWidgets(toolkit, composite);
        this.createMinishiftHomeWidgets(toolkit, composite);
    }

    protected void createHypervisorWidgets(FormToolkit toolkit, Composite composite) {
        toolkit.createLabel(composite, "Hypervisor:");
        this.hypervisorCombo = new Combo(composite, 8);
        this.hypervisorCombo.setLayoutData((Object)GridDataFactory.defaultsFor((Control)this.hypervisorCombo).span(4, 1).create());
        this.hypervisorCombo.setItems(CDK3Server.getHypervisors());
    }

    protected void createMinishiftHomeWidgets(FormToolkit toolkit, Composite composite) {
        toolkit.createLabel(composite, "Minishift Home:");
        this.msHomeText = toolkit.createText(composite, "", 2052);
        this.msHomeBrowse = toolkit.createButton(composite, "Browse...", 8);
        this.msHomeText.setLayoutData((Object)GridDataFactory.defaultsFor((Control)this.msHomeText).span(3, 1).minSize(150, -1).create());
        this.msHomeDecor = new ControlDecoration((Control)this.msHomeText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        Image img = fieldDecoration.getImage();
        this.msHomeDecor.setImage(img);
        this.msHomeDecor.hide();
    }

    @Override
    protected void setDefaultValues() {
        super.setDefaultValues();
        String hyp = this.server.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.hypervisor", CDK3Server.getHypervisors()[0]);
        int ind = Arrays.asList(CDK3Server.getHypervisors()).indexOf(hyp);
        if (ind != -1) {
            this.hypervisorCombo.select(ind);
        }
        String defMSHome = new Path(System.getProperty("user.home")).append(".minishift").toOSString();
        String msHome = this.server.getAttribute("minishift.home.location", defMSHome);
        this.msHomeText.setText(msHome);
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        SelectionAdapter sl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MinishiftLocationSection.this.execute((IUndoableOperation)new SetHypervisorPropertyCommand(MinishiftLocationSection.this.server, (SelectionListener)this));
            }
        };
        this.hypervisorCombo.addSelectionListener((SelectionListener)sl);
        this.msHomeSelListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MinishiftLocationSection.this.browseClicked(MinishiftLocationSection.this.msHomeText, false);
                MinishiftLocationSection.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.msHomeBrowse.addSelectionListener(this.msHomeSelListener);
        this.msHomeModListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MinishiftLocationSection.this.execute((IUndoableOperation)new SetMinishiftHomePropertyCommand(MinishiftLocationSection.this.server));
            }
        };
        this.msHomeText.addModifyListener(this.msHomeModListener);
        this.msHomeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MinishiftLocationSection.this.validate();
            }
        });
    }

    @Override
    protected void locationBrowseClicked() {
        this.browseClicked(this.getLocationText(), true);
    }

    @Override
    protected void validate() {
        this.kickValidationJob();
    }

    protected void validate2() {
        String s = this.getErrorString();
        if (s == null) {
            this.txtDecorator.hide();
        } else {
            this.txtDecorator.setDescriptionText(s);
            this.txtDecorator.show();
        }
    }

    private synchronized void kickValidationJob() {
        Text t;
        if (this.longValidation != null) {
            this.longValidation.cancel();
        }
        if ((t = this.getLocationText()) == null || t.isDisposed()) {
            return;
        }
        File f = new File(t.getText());
        if (!f.exists() || !f.canExecute()) {
            this.validate2();
            return;
        }
        final String homeDir = t.getText();
        this.longValidation = new Job("Validate minishift location"){

            protected IStatus run(IProgressMonitor monitor) {
                MinishiftLocationSection.this.minishiftVersionProps = MinishiftVersionLoader.getVersionProperties(homeDir);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MinishiftLocationSection.this.validate2();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.longValidation.setSystem(true);
        this.longValidation.schedule(750L);
    }

    protected String getErrorString() {
        Text t = this.getLocationText();
        if (t != null && !t.isDisposed()) {
            String v = t.getText();
            File f = new File(v);
            if (!f.exists()) {
                return "File " + v + " does not exist.";
            }
            if (!f.canExecute()) {
                return "File " + v + " is not executable.";
            }
            if (this.minishiftVersionProps == null) {
                return "Unknown error when checking minishift version: " + v;
            }
            if (!this.minishiftVersionProps.isValid()) {
                String err = this.minishiftVersionProps.getError();
                if (err == null) {
                    err = "Unknown error while checking minishift version";
                }
                return err;
            }
            String versionCompatError = this.isVersionCompatible(this.minishiftVersionProps);
            if (versionCompatError != null) {
                return versionCompatError;
            }
        }
        return null;
    }

    protected String isVersionCompatible(MinishiftVersionLoader.MinishiftVersions versions) {
        String cdkVers = versions.getCDKVersion();
        if (cdkVers == null) {
            return "Cannot determine CDK version.";
        }
        if (CDK3Server.matchesCDK3(cdkVers)) {
            return null;
        }
        return "CDK version " + cdkVers + " is not compatible with this server adapter.";
    }

    public IStatus[] getSaveStatus() {
        String err = this.getErrorString();
        if (err != null) {
            return new Status[]{new Status(4, "org.jboss.tools.openshift.cdk.server.core", err)};
        }
        return new IStatus[]{Status.OK_STATUS};
    }

    public class SetHypervisorPropertyCommand
    extends ServerWorkingCopyPropertyComboCommand {
        public SetHypervisorPropertyCommand(IServerWorkingCopy server, SelectionListener sl) {
            super(server, "Change hypervisor", MinishiftLocationSection.this.hypervisorCombo, MinishiftLocationSection.this.hypervisorCombo.getItem(MinishiftLocationSection.this.hypervisorCombo.getSelectionIndex()), "org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.hypervisor", sl);
        }
    }

    public class SetMinishiftHomePropertyCommand
    extends ServerWorkingCopyPropertyTextCommand {
        public SetMinishiftHomePropertyCommand(IServerWorkingCopy server) {
            super(server, "Change Minishift Home", MinishiftLocationSection.this.msHomeText, MinishiftLocationSection.this.msHomeText.getText(), "minishift.home.location", MinishiftLocationSection.this.msHomeModListener);
        }
    }
}

