/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.fragment.ModifyModulesWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.NewServerWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.TasksWizardFragment;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.ui.internal.dialogs.ChooseServerDialog;

public class LaunchCDKServerHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IServer s = this.findCDKServer();
        if (s != null) {
            try {
                s.start("run", (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                CDKCoreActivator.getDefault().getLog().log(ce.getStatus());
            }
        }
        return null;
    }

    private void trimNotStopped(ArrayList<IServer> servers) {
        Iterator<IServer> i = servers.iterator();
        while (i.hasNext()) {
            IServer next = i.next();
            if (next.getServerState() == 4) continue;
            i.remove();
        }
    }

    private IServer findCDKServer() {
        ArrayList<IServer> allCDK = this.findCDKServers();
        if (allCDK.size() == 0) {
            return this.showCreateNewServerDialog();
        }
        this.trimNotStopped(allCDK);
        if (allCDK.size() != 0) {
            if (allCDK.size() > 1) {
                return this.showSelectServerDialog(allCDK);
            }
            return allCDK.get(0);
        }
        this.showAllRunningError();
        return null;
    }

    private IServer showSelectServerDialog(ArrayList<IServer> valid) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ChooseServerDialog dialog = new ChooseServerDialog(shell, valid);
        int ret = dialog.open();
        if (ret == 0) {
            return dialog.getServer();
        }
        return null;
    }

    private void showAllRunningError() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String msg = "All available CDK servers are already running";
        MessageDialog.openError((Shell)shell, (String)msg, (String)msg);
    }

    private IServer showCreateNewServerDialog() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IServer created = LaunchCDKServerHandler.showNewServerWizard(shell, "org.jboss.tools.openshift.cdk.server.type");
        return created;
    }

    private ArrayList<IServer> findCDKServers() {
        ArrayList<IServer> cdk = new ArrayList<IServer>();
        IServer[] all = ServerCore.getServers();
        int i = 0;
        while (i < all.length) {
            if (all[i].getServerType().getId().equals("org.jboss.tools.openshift.cdk.server.type")) {
                cdk.add(all[i]);
            }
            ++i;
        }
        return cdk;
    }

    public static IServer showNewServerWizard(Shell shell, final String serverTypeId) {
        WizardFragment fragment = new WizardFragment(){

            protected void createChildFragments(List<WizardFragment> list) {
                list.add((WizardFragment)new NewServerWizardFragment(null, serverTypeId));
                list.add(WizardTaskUtil.TempSaveRuntimeFragment);
                list.add(WizardTaskUtil.TempSaveServerFragment);
                list.add((WizardFragment)new ModifyModulesWizardFragment());
                list.add((WizardFragment)new TasksWizardFragment());
                list.add(WizardTaskUtil.SaveRuntimeFragment);
                list.add(WizardTaskUtil.SaveServerFragment);
                list.add(WizardTaskUtil.SaveHostnameFragment);
            }
        };
        TaskWizard wizard = new TaskWizard(Messages.wizNewServerWizardTitle, fragment);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        int ret = dialog.open();
        if (ret == 0) {
            IServer server = (IServer)wizard.getTaskModel().getObject("server");
            return server;
        }
        return null;
    }
}

