/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal.detection;

import java.io.File;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.runtime.core.model.IRuntimeDetectionResolution;
import org.jboss.tools.runtime.core.model.IRuntimeDetectionResolutionProvider;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimeDetectionProblem;

public class MissingMinishiftResolutionProvider
implements IRuntimeDetectionResolutionProvider {
    public static final int MISSING_MINISHIFT_PROBLEM_ID = 2008;

    public IRuntimeDetectionResolution[] getResolutions(RuntimeDetectionProblem problem, RuntimeDefinition def) {
        if (problem.getCode() == 2008) {
            return new IRuntimeDetectionResolution[]{new MissingMinishiftResolution()};
        }
        return null;
    }

    public static class MissingMinishiftResolution
    implements IRuntimeDetectionResolution {
        public String getLabel() {
            return "Set minishift binary location.";
        }

        public void run(RuntimeDetectionProblem problem, RuntimeDefinition definition) {
            File found = MissingMinishiftResolution.getFile(null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            if (found != null) {
                definition.setProperty("OVERRIDE_MINISHIFT_LOCATION", (Object)found.getAbsolutePath());
            }
        }

        protected static File getFile(File startingDirectory, Shell shell) {
            String dir;
            FileDialog fileDialog = new FileDialog(shell, 4096);
            if (startingDirectory != null) {
                fileDialog.setFilterPath(startingDirectory.getPath());
            }
            if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
                return new File(dir);
            }
            return null;
        }
    }
}

