/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.tm.internal.terminal.control.impl.ITerminalControlForText;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.tm.terminal.view.ui.interfaces.ILauncherDelegate;
import org.eclipse.tm.terminal.view.ui.launcher.LauncherDelegateManager;
import org.eclipse.tm.terminal.view.ui.manager.ConsoleManager;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.cdk.server.ui.internal.util.ViewUtils;

public class TerminalUtility {
    public static void openConsole(Map<String, Object> props, ITerminalService.Done d) {
        ViewUtils.openTerminalView();
        ITerminalService terminal = TerminalServiceFactory.getService();
        if (terminal != null) {
            terminal.openConsole(props, d);
        }
    }

    public static Map<String, Object> getPropertiesForServer(IServer s) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        String workingDir = s.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        props.put("process.working_dir", workingDir);
        props.put("tm.terminal.connector.id", "org.eclipse.tm.terminal.connector.local.LocalConnector");
        props.put("ip.host", "localhost");
        props.put("timeout", 0);
        props.put("ssh.keep_alive", 300);
        props.put("encoding", null);
        props.put("delegateId", "org.eclipse.tm.terminal.connector.local.launcher.local");
        props.put("title", s.getName());
        return props;
    }

    public static ITerminalControlForText findTerminalControl(Map<String, Object> props) {
        Object data22;
        String id = (String)props.get("id");
        id = id != null ? id : "org.eclipse.tm.terminal.view.ui.TerminalsView";
        String secondaryId = (String)props.get("secondaryId");
        String title = (String)props.get("title");
        Object data = props.get("data");
        ITerminalConnector connector = TerminalUtility.createTerminalConnector(props);
        CTabItem item = ConsoleManager.getInstance().findConsole(id, secondaryId, title, connector, data);
        if (item != null && (data22 = item.getData()) instanceof ITerminalControlForText) {
            return (ITerminalControlForText)data22;
        }
        return null;
    }

    private static ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
        ILauncherDelegate delegate;
        Assert.isNotNull(properties);
        ITerminalConnector connector = null;
        String delegateId = (String)properties.get("delegateId");
        if (delegateId != null && (delegate = LauncherDelegateManager.getInstance().getLauncherDelegate(delegateId, false)) != null) {
            connector = delegate.createTerminalConnector(properties);
        }
        return connector;
    }
}

