/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.databinding;

import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class NumericValidator
implements IValidator {
    private String type;
    private Function<String, Number> validator;
    private boolean errorOnEmpty = false;

    public NumericValidator(String type, Function<String, Number> validator, boolean errorOnEmpty) {
        this.type = type;
        this.validator = validator;
        this.errorOnEmpty = errorOnEmpty;
    }

    public NumericValidator(String type, Function<String, Number> validator) {
        this(type, validator, false);
    }

    public IStatus validate(Object value) {
        if (!(value instanceof String)) {
            return ValidationStatus.error((String)"Invalid format");
        }
        String str = (String)value;
        IStatus status = ValidationStatus.ok();
        if (StringUtils.isEmpty((String)str)) {
            if (this.errorOnEmpty) {
                status = ValidationStatus.error((String)"Please provide a value");
            }
        } else {
            try {
                this.validator.apply(str);
            }
            catch (NumberFormatException numberFormatException) {
                status = ValidationStatus.error((String)("Must be an " + this.type));
            }
        }
        return status;
    }
}

