/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.openshift.common.core.connection.IConnection;

public abstract class BaseExplorerContentProvider
implements ITreeContentProvider {
    private static final String MSG_LOADING_RESOURCES = "Loading OpenShift resources...";
    private TreeViewer viewer;
    private Map<Object, LoadingStub> loadedElements = new ConcurrentHashMap<Object, LoadingStub>();
    private Map<Object, LoadingStub> loadingElements = new ConcurrentHashMap<Object, LoadingStub>();

    protected abstract Object[] getExplorerElements(Object var1);

    protected abstract Object[] getChildrenFor(Object var1);

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
    }

    protected void handleConnectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
        this.refreshViewer(connection);
    }

    protected void handleConnectionRemoved(IConnection connection) {
        this.refreshViewer(null);
    }

    public Object[] getElements(Object parentElement) {
        this.loadedElements.clear();
        this.loadingElements.clear();
        return this.getExplorerElements(parentElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (this.loadedElements.containsKey(parentElement)) {
            return this.loadedElements.remove(parentElement).getChildren();
        }
        return this.loadChildren(parentElement);
    }

    protected final void addException(Object element, Exception e) {
        if (this.loadingElements.containsKey(element)) {
            this.loadingElements.get(element).add(e);
        }
    }

    protected final Object[] loadChildren(Object parentElement) {
        if (!this.loadedElements.containsKey(parentElement)) {
            if (!this.loadingElements.containsKey(parentElement)) {
                return new Object[]{this.launchLoadingJob(parentElement)};
            }
            return new Object[]{this.loadingElements.get(parentElement)};
        }
        return this.getChildrenFor(parentElement);
    }

    private LoadingStub launchLoadingJob(final Object element) {
        final LoadingStub stub = new LoadingStub();
        this.loadingElements.put(element, stub);
        Job job = new Job(MSG_LOADING_RESOURCES){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(BaseExplorerContentProvider.MSG_LOADING_RESOURCES, -1);
                    monitor.worked(1);
                    stub.addChildren(BaseExplorerContentProvider.this.getChildrenFor(element));
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    BaseExplorerContentProvider.this.addException(element, e);
                    Status status = new Status(4, "org.jboss.tools.openshift.ui", "There was an error retrieving children in the OpenShift explorer", (Throwable)e);
                    return status;
                }
                finally {
                    BaseExplorerContentProvider.this.loadedElements.put(element, stub);
                    BaseExplorerContentProvider.this.loadingElements.remove(element);
                    monitor.done();
                    BaseExplorerContentProvider.this.refreshViewer(element);
                }
            }
        };
        job.setPriority(30);
        job.schedule();
        return stub;
    }

    protected void refreshViewer(final Object object) {
        Control control = this.viewer.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!BaseExplorerContentProvider.this.viewer.getControl().isDisposed()) {
                        if (object != null) {
                            BaseExplorerContentProvider.this.viewer.refresh(object);
                        } else {
                            BaseExplorerContentProvider.this.viewer.refresh();
                        }
                    }
                }
            });
        }
    }

    public Object getParent(Object element) {
        return null;
    }

    public static class LoadingStub {
        private List<Object> children = new ArrayList<Object>();

        public void add(Throwable e) {
            this.children.add(e);
        }

        public Object[] getChildren() {
            return this.children.toArray();
        }

        public void addChildren(Object[] children) {
            this.children.addAll(Arrays.asList(children));
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }
    }

    public static class NotConnectedUserStub {
    }
}

