/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.utils;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.openshift.internal.common.ui.utils.DialogChildVisibilityAdapter;

public abstract class DialogAdvancedPart {
    protected Button advancedButton;
    protected DialogChildVisibilityAdapter advancedSectionVisibilityAdapter;

    public final void createAdvancedGroup(Composite parent, int numColumns) {
        this.advancedButton = new Button(parent, 0);
        this.advancedButton.setText(this.getAdvancedButtonLabel(false));
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(numColumns, 1).applyTo((Control)this.advancedButton);
        Composite advancedComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(numColumns, 1).applyTo((Control)advancedComposite);
        this.adjustAdvancedCompositeLayout(GridLayoutFactory.fillDefaults()).applyTo(advancedComposite);
        this.advancedSectionVisibilityAdapter = new DialogChildVisibilityAdapter(advancedComposite, false);
        this.advancedButton.addSelectionListener(this.onAdvancedClicked());
        this.createAdvancedContent(advancedComposite);
    }

    protected GridLayoutFactory adjustAdvancedCompositeLayout(GridLayoutFactory gridLayoutFactory) {
        return gridLayoutFactory;
    }

    private SelectionListener onAdvancedClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogAdvancedPart.this.showAdvancedSection(!DialogAdvancedPart.this.advancedSectionVisibilityAdapter.isVisible());
            }
        };
    }

    public void showAdvancedSection(boolean visible) {
        this.advancedSectionVisibilityAdapter.setVisible(visible);
        this.advancedButton.setText(this.getAdvancedButtonLabel(visible));
    }

    protected String getAdvancedButtonLabel(boolean visible) {
        if (visible) {
            return " << Advanced ";
        }
        return " Advanced >> ";
    }

    protected abstract void createAdvancedContent(Composite var1);
}

