/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class DialogChildVisibilityAdapter {
    private boolean visible;
    private final Composite composite;
    private final GridData gridData;
    private final Shell shell;
    private int invisibleChildShellHeight;
    private boolean resizing;

    public DialogChildVisibilityAdapter(Composite child, boolean visible) {
        Assert.isTrue((child != null && !child.isDisposed() ? 1 : 0) != 0);
        this.composite = child;
        Object layoutData = child.getLayoutData();
        Assert.isTrue((boolean)(layoutData instanceof GridData), (String)"only supports GridLayout");
        this.gridData = (GridData)layoutData;
        this.gridData.exclude = !visible;
        Assert.isTrue((child.getShell() != null && !child.getShell().isDisposed() ? 1 : 0) != 0);
        this.shell = child.getShell();
        this.shell.addControlListener(this.onShellResized(this.shell));
        this.invisibleChildShellHeight = this.computeChildHeight(visible, child, this.shell);
        this.visible = visible;
        child.setVisible(visible);
    }

    private ControlListener onShellResized(final Shell shell) {
        ControlAdapter listener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!DialogChildVisibilityAdapter.this.resizing) {
                    DialogChildVisibilityAdapter.this.invisibleChildShellHeight = shell.getSize().y;
                }
            }
        };
        shell.addDisposeListener(new DisposeListener((ControlListener)listener){
            private final /* synthetic */ ControlListener val$listener;
            {
                this.val$listener = controlListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                shell.removeControlListener(this.val$listener);
            }
        });
        return listener;
    }

    private int computeChildHeight(boolean visible, Composite child, Shell shell) {
        Point size = shell.getSize();
        if (visible) {
            Point childSize = child.computeSize(child.getSize().x, -1);
            size.y -= childSize.y;
        }
        return size.y;
    }

    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.toggle();
    }

    public boolean toggle() {
        this.resizing = true;
        this.visible = !this.visible;
        this.composite.setVisible(this.visible);
        this.gridData.exclude = !this.visible;
        int newShellHeight = this.computeShellHeight(this.shell.getSize());
        this.shell.setSize(this.shell.getSize().x, newShellHeight);
        this.shell.layout(true, true);
        this.resizing = false;
        return this.visible;
    }

    protected int computeShellHeight(Point shellSize) {
        if (this.visible) {
            return this.shell.computeSize((int)shellSize.x, (int)-1, (boolean)true).y;
        }
        return new Point((int)shellSize.x, (int)this.invisibleChildShellHeight).y;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

