/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.utils;

import java.util.Collection;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIActivator;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;

public class OpenShiftUIUtils {
    public static final String OPENSHIFT_EXPLORER_VIEW_ID = "org.jboss.tools.openshift.express.ui.explorer.expressConsoleView";
    public static final String DOCKER_EXPLORER_VIEW_ID = "org.eclipse.linuxtools.docker.ui.dockerExplorerView";

    private OpenShiftUIUtils() {
    }

    public static void showOpenShiftExplorer() {
        OpenShiftUIUtils.showViewAsync(OPENSHIFT_EXPLORER_VIEW_ID);
    }

    public static void hideOpenShiftExplorer() {
        OpenShiftUIUtils.hideViewAsync(OPENSHIFT_EXPLORER_VIEW_ID);
    }

    public static boolean isOpenShiftExplorerVisible() {
        return OpenShiftUIUtils.isViewVisibleSync(OPENSHIFT_EXPLORER_VIEW_ID);
    }

    public static void showViewAsync(String viewId) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(() -> OpenShiftUIUtils.showView(viewId));
        } else {
            OpenShiftUIUtils.showView(viewId);
        }
    }

    public static void showView(String viewId) {
        try {
            IWorkbenchPage page = OpenShiftUIUtils.getActivePage();
            if (page != null) {
                page.showView(viewId);
            }
        }
        catch (PartInitException e) {
            OpenShiftCommonUIActivator.getDefault().getLogger().logError("Failed to show the view " + viewId, (Throwable)e);
        }
    }

    public static boolean isViewVisibleSync(String viewId) {
        boolean[] visible = new boolean[1];
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(() -> {
                blArray[0] = OpenShiftUIUtils.isViewVisible(viewId);
            });
        } else {
            visible[0] = OpenShiftUIUtils.isViewVisible(viewId);
        }
        return visible[0];
    }

    public static boolean isViewVisible(String viewId) {
        IWorkbenchPage page = OpenShiftUIUtils.getActivePage();
        if (page != null) {
            IViewPart view = page.findView(viewId);
            return view != null && page.isPartVisible((IWorkbenchPart)view);
        }
        return false;
    }

    public static void hideViewAsync(String viewId) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(() -> OpenShiftUIUtils.hideView(viewId));
        } else {
            OpenShiftUIUtils.hideView(viewId);
        }
    }

    public static void hideView(String viewId) {
        IViewPart view;
        IWorkbenchPage page = OpenShiftUIUtils.getActivePage();
        if (page != null && (view = page.findView(viewId)) != null) {
            page.hideView(view);
        }
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow aww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (aww != null) {
            return aww.getActivePage();
        }
        return null;
    }

    public static <T extends IConnection> T getExplorerDefaultConnection(Class<T> klass) {
        Collection available = ConnectionsRegistrySingleton.getInstance().getAll(klass);
        if (available.size() == 1) {
            return (T)((IConnection)available.iterator().next());
        }
        return OpenShiftUIUtils.getConnectionForExplorerSelection(klass);
    }

    public static IViewPart getOpenShiftExplorer() {
        IWorkbenchPage activePage = OpenShiftUIUtils.getActivePage();
        if (activePage != null) {
            return activePage.findView(OPENSHIFT_EXPLORER_VIEW_ID);
        }
        return null;
    }

    public static ISelection getOpenShiftExplorerSelection() {
        IViewPart part = OpenShiftUIUtils.getOpenShiftExplorer();
        if (part == null) {
            return null;
        }
        return part.getSite().getSelectionProvider().getSelection();
    }

    public static boolean hasOpenShiftExplorerSelection() {
        ISelection selection = OpenShiftUIUtils.getOpenShiftExplorerSelection();
        return selection != null && !selection.isEmpty();
    }

    public static IViewPart getDockerExplorer() {
        IWorkbenchPage activePage = OpenShiftUIUtils.getActivePage();
        if (activePage != null) {
            return activePage.findView(DOCKER_EXPLORER_VIEW_ID);
        }
        return null;
    }

    public static ISelection getDockerExplorerSelection() {
        IViewPart part = OpenShiftUIUtils.getDockerExplorer();
        if (part == null) {
            return null;
        }
        return part.getSite().getSelectionProvider().getSelection();
    }

    public static boolean hasDockerExplorerSelection() {
        ISelection selection = OpenShiftUIUtils.getDockerExplorerSelection();
        return selection != null && !selection.isEmpty();
    }

    public static <T extends IConnection> T getConnectionForExplorerSelection(Class<T> klass) {
        ISelection selection = OpenShiftUIUtils.getOpenShiftExplorerSelection();
        if (selection != null && !selection.isEmpty()) {
            IConnection result = (IConnection)UIUtils.getFirstElement(selection, klass);
            IViewPart part = OpenShiftUIUtils.getOpenShiftExplorer();
            if (result == null && selection instanceof IStructuredSelection && part instanceof CommonNavigator) {
                Object selected = ((IStructuredSelection)selection).getFirstElement();
                IContentProvider provider = ((CommonNavigator)part).getCommonViewer().getContentProvider();
                if (provider instanceof ITreeContentProvider) {
                    ITreeContentProvider tree = (ITreeContentProvider)provider;
                    while (selected != null && result == null) {
                        result = (IConnection)UIUtils.adapt(selected, klass);
                        selected = tree.getParent(selected);
                    }
                }
            }
            return (T)result;
        }
        return null;
    }

    public static PropertySheet getPropertySheet() {
        IWorkbenchPage activePage = OpenShiftUIUtils.getActivePage();
        if (activePage != null) {
            return (PropertySheet)activePage.findView("org.eclipse.ui.views.PropertySheet");
        }
        return null;
    }

    public static void refreshPropertySheetPage(PropertySheet propertySheet) {
        if (propertySheet == null) {
            return;
        }
        IPage page = propertySheet.getCurrentPage();
        if (page instanceof TabbedPropertySheetPage) {
            TabbedPropertySheetPage p = (TabbedPropertySheetPage)page;
            if (p == null || p.getControl() == null || p.getControl().isDisposed()) {
                return;
            }
            p.refresh();
        } else if (page instanceof PropertySheetPage) {
            PropertySheetPage p = (PropertySheetPage)page;
            if (p == null || p.getControl() == null || p.getControl().isDisposed()) {
                return;
            }
            p.refresh();
        }
    }
}

