/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.utils;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SmartTooltip {
    private static final String dataKey = "jboss-auto-tooltip";
    protected Shell shell;
    protected Control control;
    protected String tooltip;
    protected ModifyListener modifyListener;
    protected ControlListener controlListener;

    public static SmartTooltip get(Control control) {
        Object data = control.getData(dataKey);
        return data instanceof SmartTooltip ? (SmartTooltip)data : null;
    }

    public SmartTooltip(Control control) {
        this(control, control.getToolTipText());
    }

    public SmartTooltip(Control control, String tooltip) {
        this.control = control;
        this.tooltip = tooltip;
        this.enable();
        control.setData(dataKey, (Object)this);
    }

    protected void enable() {
        if (this.control.isDisposed() || this.controlListener != null) {
            return;
        }
        this.shell = this.control.getShell();
        this.controlListener = new CL();
        this.shell.addControlListener(this.controlListener);
        this.control.addControlListener(this.controlListener);
        this.control.getParent().addControlListener(this.controlListener);
        if (this.control instanceof Text) {
            this.modifyListener = new ML();
            ((Text)this.control).addModifyListener(this.modifyListener);
        } else if (this.control instanceof StyledText) {
            this.modifyListener = new ML();
            ((StyledText)this.control).addModifyListener(this.modifyListener);
        } else if (this.control instanceof Combo) {
            this.modifyListener = new ML();
            ((Combo)this.control).addModifyListener(this.modifyListener);
        }
        this.update();
    }

    protected void disable() {
        if (this.control.isDisposed()) {
            this.controlListener = null;
            this.modifyListener = null;
            return;
        }
        if (this.controlListener != null) {
            this.shell.removeControlListener(this.controlListener);
            this.control.getParent().removeControlListener(this.controlListener);
            this.control.removeControlListener(this.controlListener);
            this.controlListener = null;
        }
        if (this.modifyListener != null) {
            if (this.control instanceof Text) {
                ((Text)this.control).removeModifyListener(this.modifyListener);
            } else if (this.control instanceof StyledText) {
                ((StyledText)this.control).removeModifyListener(this.modifyListener);
            } else if (this.control instanceof Combo) {
                ((Combo)this.control).removeModifyListener(this.modifyListener);
            }
            this.modifyListener = null;
        }
        this.control.setToolTipText(this.tooltip);
    }

    public void setEnabled(boolean value) {
        if (value != this.isEnabled()) {
            if (value) {
                this.enable();
            } else {
                this.disable();
            }
        }
    }

    public boolean isEnabled() {
        return this.controlListener != null && !this.control.isDisposed();
    }

    public void setToolTip(String tooltip) {
        this.tooltip = tooltip;
        if (!this.control.isDisposed()) {
            if (this.isEnabled()) {
                this.update();
            } else {
                this.control.setToolTipText(tooltip);
            }
        }
    }

    public void update() {
        if (!this.isEnabled()) {
            return;
        }
        int a = this.control.computeSize((int)-1, (int)-1, (boolean)true).x;
        int x = this.control.getBounds().x;
        Composite parent = this.control.getParent();
        while (parent != null) {
            Rectangle b = parent.getBounds();
            if (b.width < x + a) {
                this.control.setToolTipText(String.valueOf(this.getText()) + (this.tooltip == null ? "" : "\n" + this.tooltip));
                return;
            }
            if (parent instanceof Shell) break;
            x += b.x;
            parent = parent.getParent();
        }
        this.control.setToolTipText(this.tooltip);
    }

    protected String getText() {
        return this.control instanceof Text ? ((Text)this.control).getText() : (this.control instanceof StyledText ? ((StyledText)this.control).getText() : (this.control instanceof Combo ? ((Combo)this.control).getText() : (this.control instanceof Label ? ((Label)this.control).getText() : (this.control instanceof Button ? ((Button)this.control).getText() : (this.control instanceof Link ? ((Link)this.control).getText() : "")))));
    }

    class CL
    implements ControlListener {
        CL() {
        }

        public void controlResized(ControlEvent e) {
            SmartTooltip.this.update();
        }

        public void controlMoved(ControlEvent e) {
        }
    }

    class ML
    implements ModifyListener {
        ML() {
        }

        public void modifyText(ModifyEvent e) {
            SmartTooltip.this.update();
        }
    }
}

