/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.wizard;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;

public abstract class AbstractOpenShiftWizardPage
extends WizardPage {
    private DataBindingContext dbc;

    protected AbstractOpenShiftWizardPage(String title, String description, String pageName, IWizard wizard) {
        super(pageName);
        this.setWizard(wizard);
        this.setTitle(title);
        this.setDescription(description);
        this.setImageDescriptor(OpenShiftCommonImages.OPENSHIFT_LOGO_WHITE_MEDIUM);
    }

    public void createControl(Composite parent) {
        this.dbc = new DataBindingContext();
        this.setupWizardPageSupport(this.dbc);
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(container);
        Composite child = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)child);
        this.setControl((Control)container);
        this.initPageChangeListeners();
        this.doCreateControls(child, this.dbc);
        parent.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DataBindingUtils.dispose(AbstractOpenShiftWizardPage.this.dbc);
                AbstractOpenShiftWizardPage.this.dbc = null;
            }
        });
    }

    protected void updateSize() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = AbstractOpenShiftWizardPage.this.getControl().getShell();
                int y = shell.computeSize((int)-1, (int)-1, (boolean)true).y;
                int h = Display.getDefault().getBounds().height;
                if (y > h) {
                    y = h;
                }
                if (y > shell.getSize().y) {
                    shell.setSize(shell.getSize().x, y);
                }
            }
        });
    }

    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)15, (WizardPage)this, (DataBindingContext)dbc);
    }

    protected void initPageChangeListeners() {
        IWizardContainer container = this.getContainer();
        if (container instanceof WizardDialog) {
            ((WizardDialog)container).addPageChangedListener(this.onPageChanged());
            ((WizardDialog)container).addPageChangingListener(this.onPageChanging());
        }
    }

    private IPageChangingListener onPageChanging() {
        return new IPageChangingListener(){

            public void handlePageChanging(PageChangingEvent event) {
                if (this.isChangingToThisPage(event)) {
                    if (event.getCurrentPage() == null || this.equals((IWizardPage)event.getCurrentPage(), AbstractOpenShiftWizardPage.this.getPreviousPage())) {
                        AbstractOpenShiftWizardPage.this.onPageWillGetActivated(Direction.FORWARDS, event, AbstractOpenShiftWizardPage.this.dbc);
                    } else {
                        AbstractOpenShiftWizardPage.this.onPageWillGetActivated(Direction.BACKWARDS, event, AbstractOpenShiftWizardPage.this.dbc);
                    }
                } else if (this.isChangingFromThisPage(event)) {
                    if (event.getTargetPage() != null && this.equals((IWizardPage)event.getTargetPage(), AbstractOpenShiftWizardPage.this.getPreviousPage())) {
                        AbstractOpenShiftWizardPage.this.onPageWillGetDeactivated(Direction.BACKWARDS, event, AbstractOpenShiftWizardPage.this.dbc);
                    } else if (this.equals((IWizardPage)event.getTargetPage(), AbstractOpenShiftWizardPage.this.getNextPage())) {
                        AbstractOpenShiftWizardPage.this.onPageWillGetDeactivated(Direction.FORWARDS, event, AbstractOpenShiftWizardPage.this.dbc);
                    }
                }
            }

            private boolean isChangingToThisPage(PageChangingEvent event) {
                return this.equals((IWizardPage)event.getTargetPage(), (Object)AbstractOpenShiftWizardPage.this);
            }

            private boolean isChangingFromThisPage(PageChangingEvent event) {
                return this.equals((IWizardPage)event.getCurrentPage(), (Object)AbstractOpenShiftWizardPage.this);
            }

            private boolean equals(Object thisPage, Object thatPage) {
                if (!(thisPage instanceof IWizardPage)) {
                    return thatPage == null;
                }
                if (!(thatPage instanceof IWizardPage)) {
                    return false;
                }
                return thisPage == thatPage || ((IWizardPage)thisPage).getControl() == ((IWizardPage)thatPage).getControl();
            }
        };
    }

    private IPageChangedListener onPageChanged() {
        return new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (event.getSelectedPage() == AbstractOpenShiftWizardPage.this) {
                    AbstractOpenShiftWizardPage.this.onPageActivated(AbstractOpenShiftWizardPage.this.dbc);
                } else {
                    AbstractOpenShiftWizardPage.this.onPageDeactivated(AbstractOpenShiftWizardPage.this.dbc);
                }
            }
        };
    }

    protected DataBindingContext getDatabindingContext() {
        return this.dbc;
    }

    protected void onPageActivated(DataBindingContext dbc) {
    }

    protected void onPageDeactivated(DataBindingContext dbc) {
    }

    protected void onPageWillGetActivated(Direction direction, PageChangingEvent event, DataBindingContext dbc) {
    }

    protected void onPageWillGetDeactivated(Direction progress, PageChangingEvent event, DataBindingContext dbc) {
    }

    protected abstract void doCreateControls(Composite var1, DataBindingContext var2);

    protected DataBindingContext getDataBindingContext() {
        return this.dbc;
    }

    public static enum Direction {
        FORWARDS{

            @Override
            public IWizardPage getFollowingPage(IWizardPage page) {
                return page.getNextPage();
            }
        }
        ,
        BACKWARDS{

            @Override
            public IWizardPage getFollowingPage(IWizardPage page) {
                return page.getPreviousPage();
            }
        };


        public abstract IWizardPage getFollowingPage(IWizardPage var1);
    }
}

