/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.js.launcher;

import com.openshift.restclient.model.IResource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.chromium.debug.core.model.BreakpointSynchronizer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.LaunchParams;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.js.listeners.NodeDebugTerminateListener;
import org.jboss.tools.openshift.internal.js.storage.SessionStorage;
import org.jboss.tools.openshift.internal.js.util.NodeDebuggerUtil;

public final class NodeDebugLauncher {
    public static void launch(final IServer server, int port) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.wst.jsdt.chromium.debug.ui.LaunchType$StandaloneV8");
        IProject project = OpenShiftServerUtils.getDeployProject((IServerAttributes)server);
        String projectName = project.getName();
        final ILaunchConfigurationWorkingCopy v8debugLaunch = type.newInstance((IContainer)project, projectName);
        v8debugLaunch.setAttribute("debug_host", "localhost");
        v8debugLaunch.setAttribute("debug_port", port);
        v8debugLaunch.setAttribute("add_network_console", true);
        v8debugLaunch.setAttribute("breakpoint_startup_sync_direction", BreakpointSynchronizer.Direction.MERGE.name());
        v8debugLaunch.setAttribute("source_lookup_mode", LaunchParams.LookupMode.EXACT_MATCH.name());
        v8debugLaunch.setAttribute("attr_app_project", OpenShiftServerUtils.getDeployProject((IServerAttributes)server).getName());
        v8debugLaunch.setAttribute("attr_app_project_relative_path", project.getFile("package.json").getProjectRelativePath().toOSString());
        v8debugLaunch.setAttribute("attr_remote_home dir", NodeDebugLauncher.getPodPath(server, (IProgressMonitor)new NullProgressMonitor()));
        v8debugLaunch.setAttribute(LaunchParams.PredefinedSourceWrapperIds.CONFIG_PROPERTY, NodeDebuggerUtil.encode(NodeDebuggerUtil.PREDEFIENED_WRAPPERS));
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)new NodeDebugTerminateListener((ILaunchConfiguration)v8debugLaunch, server));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DebugUITools.launch((ILaunchConfiguration)v8debugLaunch, (String)"debug");
                SessionStorage.get().put(server, (ILaunchConfiguration)v8debugLaunch);
            }
        });
    }

    public static void terminate(IServer server) throws DebugException {
        ILaunchConfiguration v8debugLaunch = SessionStorage.get().get(server);
        if (v8debugLaunch != null) {
            ILaunch[] runningLaunches;
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunch[] iLaunchArray = runningLaunches = manager.getLaunches();
            int n = runningLaunches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (v8debugLaunch.equals(launch.getLaunchConfiguration())) {
                    launch.terminate();
                }
                ++n2;
            }
        }
    }

    private static String getPodPath(IServer server, IProgressMonitor monitor) throws CoreException {
        IResource resource = OpenShiftServerUtils.getResource((IServerAttributes)server, (IProgressMonitor)monitor);
        return OpenShiftServerUtils.loadPodPath((IResource)resource, (IServer)server);
    }
}

