/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.jboss.tools.project.examples.dialog.MarkerContentProvider;
import org.jboss.tools.project.examples.dialog.MarkerLabelProvider;
import org.jboss.tools.project.examples.dialog.xpl.QuickFixWizard;
import org.jboss.tools.project.examples.internal.Messages;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;

public class MarkerDialog
extends TitleAreaDialog {
    private static final String QUICK_FIX = Messages.MarkerDialog_Quick_Fix;
    private static final IMarkerResolution[] EMPTY_ARRAY = new IMarkerResolution[0];
    private List<ProjectExampleWorkingCopy> projects;
    private Image _dlgTitleImage;
    private Button quickFixButton;
    private Button finishButton;
    private TableViewer tableViewer;
    private IResourceChangeListener resourceChangeListener;

    public MarkerDialog(Shell parentShell, List<ProjectExampleWorkingCopy> projects) {
        super(parentShell);
        this.projects = projects;
        this.setShellStyle(0xC70 | MarkerDialog.getDefaultOrientation());
        this._dlgTitleImage = IDEInternalWorkbenchImages.getImageDescriptor((String)"IMG_DLGBAN_QUICKFIX_DLG").createImage();
        this.setTitleImage(this._dlgTitleImage);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new GridLayout());
        this.setTitle(QUICK_FIX);
        this.setMessage(Messages.MarkerDialog_Select_a_marker_and_click_the_Quick_Fix_button);
        this.getShell().setText(QUICK_FIX);
        MarkerDialog.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        Label markersLabel = new Label(contents, 0);
        markersLabel.setText(Messages.MarkerDialog_Markers);
        this.tableViewer = new TableViewer(contents, 2820);
        Table table = this.tableViewer.getTable();
        gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{Messages.MarkerDialog_Description, Messages.MarkerDialog_Resource, Messages.MarkerDialog_Type};
        int[] columnWidths = new int[]{200, 150, 150};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tc = new TableColumn(table, 16384);
            tc.setText(columnNames[i]);
            tc.setWidth(columnWidths[i]);
            ++i;
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MarkerLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new MarkerContentProvider(this.projects));
        this.tableViewer.setInput(this.projects);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection source = event.getSelection();
                if (source instanceof IStructuredSelection) {
                    IMarkerResolution[] resolutions = MarkerDialog.this.getMarkerResolutions(source);
                    MarkerDialog.this.quickFixButton.setEnabled(resolutions.length > 0);
                }
            }
        });
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (MarkerDialog.this.tableViewer != null && !MarkerDialog.this.tableViewer.getTable().isDisposed()) {
                            MarkerDialog.this.refreshTableViewer();
                        }
                    }
                });
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        return area;
    }

    public boolean close() {
        if (this._dlgTitleImage != null) {
            this._dlgTitleImage.dispose();
        }
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
            this.resourceChangeListener = null;
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.quickFixButton = this.getButton(0);
        this.quickFixButton.setText(Messages.MarkerDialog_Quick_Fix);
        this.finishButton = this.getButton(1);
        this.finishButton.setText(Messages.MarkerDialog_Finish);
        this.quickFixButton.setEnabled(false);
    }

    protected void cancelPressed() {
        this.setReturnCode(0);
        this.close();
    }

    protected void okPressed() {
        IStructuredSelection selection;
        Object object;
        ISelection source = this.tableViewer.getSelection();
        if (source instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)source).getFirstElement()) instanceof IMarker) {
            IMarker selected = (IMarker)object;
            try {
                try {
                    this.quickFixButton.setSelection(false);
                    this.openQuickFixWizard(selected);
                }
                catch (Exception e) {
                    ProjectExamplesActivator.log(e);
                    this.refreshTableViewer();
                }
            }
            finally {
                this.refreshTableViewer();
            }
        }
    }

    private void refreshTableViewer() {
        this.tableViewer.setInput(this.projects);
        ISelection source = this.tableViewer.getSelection();
        if (source instanceof IStructuredSelection) {
            IMarkerResolution[] resolutions = this.getMarkerResolutions(source);
            this.quickFixButton.setEnabled(resolutions.length > 0);
        } else {
            this.quickFixButton.setSelection(false);
        }
    }

    private void openQuickFixWizard(final IMarker selected) throws ExecutionException {
        final LinkedHashMap resolutions = new LinkedHashMap();
        IRunnableWithProgress resolutionsRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(MarkerMessages.resolveMarkerAction_computationManyAction, 100);
                IMarker[] allMarkers = ProjectExamplesActivator.getMarkers(MarkerDialog.this.projects).toArray(new IMarker[0]);
                monitor.worked(20);
                IMarkerResolution[] found = IDE.getMarkerHelpRegistry().getResolutions(selected);
                int progressCount = 80;
                if (found.length > 1) {
                    progressCount /= found.length;
                }
                int i = 0;
                while (i < found.length) {
                    IMarkerResolution markerResolution = found[i];
                    if (markerResolution instanceof WorkbenchMarkerResolution) {
                        IMarker[] other = ((WorkbenchMarkerResolution)markerResolution).findOtherMarkers(allMarkers);
                        ArrayList<IMarker> markers = new ArrayList<IMarker>(other.length + 1);
                        markers.add(selected);
                        int j = 0;
                        while (j < other.length) {
                            markers.add(other[j]);
                            ++j;
                        }
                        resolutions.put(markerResolution, markers);
                    } else {
                        ArrayList<IMarker> markers = new ArrayList<IMarker>();
                        markers.add(selected);
                        resolutions.put(markerResolution, markers);
                    }
                    monitor.worked(progressCount);
                    ++i;
                }
                monitor.done();
            }
        };
        ProgressMonitorDialog context = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, resolutionsRunnable, null);
        }
        catch (InvocationTargetException exception) {
            throw new ExecutionException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        catch (InterruptedException exception) {
            throw new ExecutionException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        String markerDescription = selected.getAttribute("message", "");
        if (resolutions.isEmpty()) {
            Status newStatus = new Status(1, "org.eclipse.ui.ide", NLS.bind((String)MarkerMessages.MarkerResolutionDialog_NoResolutionsFound, (Object[])new Object[]{markerDescription}));
            StatusAdapter adapter = new StatusAdapter((IStatus)newStatus);
            adapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)MarkerMessages.MarkerResolutionDialog_CannotFixTitle);
            StatusManager.getManager().handle(adapter, 2);
        } else {
            String description = NLS.bind((String)MarkerMessages.MarkerResolutionDialog_Description, (Object)markerDescription);
            QuickFixWizard wizard = new QuickFixWizard(description, resolutions);
            wizard.setWindowTitle(MarkerMessages.resolveMarkerAction_dialogTitle);
            QuickFixWizardDialog dialog = new QuickFixWizardDialog(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    private IMarkerResolution[] getMarkerResolutions(ISelection source) {
        IStructuredSelection selection = (IStructuredSelection)source;
        IMarker marker = (IMarker)selection.getFirstElement();
        if (marker == null) {
            return EMPTY_ARRAY;
        }
        IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
        return resolutions;
    }

    private class QuickFixWizardDialog
    extends WizardDialog {
        public QuickFixWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
            this.setShellStyle(0xC70 | QuickFixWizardDialog.getDefaultOrientation());
        }
    }
}

