/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.fixes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.tools.as.runtimes.integration.util.RuntimeMatcher;
import org.jboss.tools.project.examples.fixes.IDownloadRuntimeProvider;
import org.jboss.tools.project.examples.model.AbstractProjectFix;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.RequirementModel;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.DownloadRuntime;

public abstract class AbstractRuntimeFix
extends AbstractProjectFix
implements IDownloadRuntimeProvider {
    protected static final String ANY = "any";
    private static final Pattern RUNTIMES_PATTERN = Pattern.compile("[A-Za-z0-9._-]*(\\{[-A-Za-z0-9._:,\\(\\[\\]\\)]+\\})?");

    public AbstractRuntimeFix(ProjectExample project, RequirementModel requirement) {
        super(project, requirement);
    }

    public static List<String> parseRuntimeKeys(String allRuntimeKeys) {
        if (allRuntimeKeys == null || allRuntimeKeys.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> runtimeKeys = new ArrayList<String>();
        Matcher m = RUNTIMES_PATTERN.matcher(allRuntimeKeys);
        while (m.find()) {
            String group = m.group(0);
            if (group.isEmpty()) continue;
            runtimeKeys.add(group);
        }
        return runtimeKeys;
    }

    public static IRuntime[] getRuntimesFromPattern(String allRuntimeIds) {
        List<String> runtimeIds = AbstractRuntimeFix.parseRuntimeKeys(allRuntimeIds);
        if (runtimeIds.isEmpty()) {
            return new IRuntime[0];
        }
        RuntimeMatcher runtimeMatcher = new RuntimeMatcher();
        ArrayList<IRuntime> runtimes = new ArrayList<IRuntime>(runtimeIds.size());
        for (String key : runtimeIds) {
            IRuntime[] iRuntimeArray = runtimeMatcher.findExistingRuntimes(key);
            int n = iRuntimeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime r = iRuntimeArray[n2];
                runtimes.add(r);
                ++n2;
            }
        }
        IRuntime[] aRuntimes = new IRuntime[runtimes.size()];
        return runtimes.toArray(aRuntimes);
    }

    public static DownloadRuntime[] getDownloadRuntimesFromPattern(String allDownloadRuntimeIds, IProgressMonitor monitor) {
        List<String> runtimeIds = AbstractRuntimeFix.parseRuntimeKeys(allDownloadRuntimeIds);
        if (runtimeIds.isEmpty()) {
            return new DownloadRuntime[0];
        }
        RuntimeMatcher runtimeMatcher = new RuntimeMatcher();
        ArrayList<DownloadRuntime> runtimes = new ArrayList<DownloadRuntime>(runtimeIds.size());
        for (String key : runtimeIds) {
            DownloadRuntime[] downloadRuntimeArray = runtimeMatcher.findDownloadRuntimes(key, monitor);
            int n = downloadRuntimeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadRuntime dr = downloadRuntimeArray[n2];
                runtimes.add(dr);
                ++n2;
            }
        }
        DownloadRuntime[] aRuntimes = new DownloadRuntime[runtimes.size()];
        return runtimes.toArray(aRuntimes);
    }

    @Override
    public Collection<DownloadRuntime> getDownloadRuntimes(IProgressMonitor monitor) {
        DownloadRuntime[] downloadableRuntimes;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String downloadId = this.requirement.getProperties().get("downloadId");
        DownloadRuntime preferredDownload = null;
        if (downloadId != null) {
            preferredDownload = (DownloadRuntime)RuntimeCoreActivator.getDefault().getDownloadRuntimes(monitor).get(downloadId);
        }
        String allDownloadRuntimeIds = this.requirement.getProperties().get("allowed-types");
        ArrayList<DownloadRuntime> runtimes = new ArrayList<DownloadRuntime>();
        if (allDownloadRuntimeIds != null && !ANY.equals(allDownloadRuntimeIds) && (downloadableRuntimes = AbstractRuntimeFix.getDownloadRuntimesFromPattern(allDownloadRuntimeIds, monitor)) != null && downloadableRuntimes.length > 0) {
            runtimes.addAll(Arrays.asList(downloadableRuntimes));
        }
        if (preferredDownload != null) {
            int i = runtimes.indexOf(preferredDownload);
            if (i < -1) {
                runtimes.add(preferredDownload);
            } else if (i > 0) {
                runtimes.add(0, (DownloadRuntime)runtimes.remove(i));
            }
        }
        return runtimes;
    }
}

