/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.project.examples.IProjectExampleManager;
import org.jboss.tools.project.examples.IProjectExampleProvider;
import org.jboss.tools.project.examples.fixes.ProjectFixManager;
import org.jboss.tools.project.examples.internal.ProjectExampleJsonProvider;
import org.jboss.tools.project.examples.internal.ProjectExampleXmlProvider;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleCategory;
import org.jboss.tools.project.examples.model.ProjectExampleUtil;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;

public class ProjectExampleManager
implements IProjectExampleManager {
    private ProjectFixManager projectFixManager;
    private List<IProjectExampleProvider> exampleProviders;

    public ProjectExampleManager(ProjectFixManager projectFixManager) {
        this.projectFixManager = projectFixManager;
        this.exampleProviders = new ArrayList<IProjectExampleProvider>();
        this.exampleProviders.add(new ProjectExampleJsonProvider());
        this.exampleProviders.add(new ProjectExampleXmlProvider());
    }

    @Override
    public ProjectExampleWorkingCopy createWorkingCopy(ProjectExample example) {
        ProjectExampleWorkingCopy workingCopy = new ProjectExampleWorkingCopy(example);
        this.projectFixManager.loadFixes(workingCopy);
        return workingCopy;
    }

    @Override
    public Collection<ProjectExample> getExamples(IProgressMonitor monitor) throws CoreException {
        ArrayList<ProjectExample> examples = new ArrayList<ProjectExample>();
        for (IProjectExampleProvider provider : this.exampleProviders) {
            if (monitor.isCanceled()) break;
            examples.addAll(provider.getExamples(monitor));
        }
        return examples;
    }

    @Override
    public Collection<ProjectExampleCategory> getCategorizedExamples(IProgressMonitor monitor) throws CoreException {
        Map<String, ProjectExampleCategory> categories = ProjectExampleUtil.fetchCategories(monitor);
        for (ProjectExample example : this.getExamples(monitor)) {
            if (monitor.isCanceled()) break;
            ProjectExampleUtil.addToCategory(example, categories);
        }
        Comparator<ProjectExample> comparator = new Comparator<ProjectExample>(){

            @Override
            public int compare(ProjectExample p1, ProjectExample p2) {
                return p1.getName().compareToIgnoreCase(p2.getName());
            }
        };
        for (ProjectExampleCategory category : categories.values()) {
            if (monitor.isCanceled()) break;
            Collections.sort(category.getProjects(), comparator);
        }
        return categories.values();
    }
}

