/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.model;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class ProjectImportUtil {
    private static final String PROJECT_DESCRIPTOR = ".project";

    public Collection<IProject> importProjects(IPath baseDir, Collection<String> projectNames, IProgressMonitor monitor) throws CoreException {
        if (projectNames == null || projectNames.isEmpty()) {
            return Collections.emptyList();
        }
        File directory = baseDir.makeAbsolute().toFile();
        HashSet<String> projectsToLookFor = new HashSet<String>(projectNames);
        HashMap<String, IPath> projectPaths = new HashMap<String, IPath>();
        this.collectProjects(projectPaths, projectsToLookFor, directory, monitor);
        List<IProject> projects = this.importProjects(projectPaths, monitor);
        return projects;
    }

    private List<IProject> importProjects(Map<String, IPath> projectPaths, IProgressMonitor monitor) throws CoreException {
        ArrayList<IProject> projects = new ArrayList<IProject>(projectPaths.size());
        for (Map.Entry<String, IPath> e : projectPaths.entrySet()) {
            if (monitor.isCanceled()) break;
            IProject p = this.createProject(e.getKey(), e.getValue(), monitor);
            if (p == null) continue;
            projects.add(p);
        }
        return projects;
    }

    private void collectProjects(Map<String, IPath> projectPaths, Set<String> projectsToLookFor, File directory, IProgressMonitor monitor) {
        if (!projectsToLookFor.isEmpty() && directory.isDirectory()) {
            File[] dirs;
            boolean fileExists;
            File projectFile = new File(directory, PROJECT_DESCRIPTOR);
            boolean bl = fileExists = projectFile.exists() && projectFile.isFile() && projectFile.canRead();
            if (projectsToLookFor.contains(directory.getName()) && fileExists) {
                projectsToLookFor.remove(directory.getName());
                projectPaths.put(directory.getName(), (IPath)new Path(directory.getAbsolutePath()));
                return;
            }
            File[] fileArray = dirs = directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File dir) {
                    return dir.isDirectory();
                }
            });
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File d = fileArray[n2];
                if (monitor.isCanceled()) {
                    return;
                }
                projectFile = new File(d, PROJECT_DESCRIPTOR);
                if (projectsToLookFor.contains(d.getName()) && projectFile.exists() && projectFile.isFile() && projectFile.canRead()) {
                    projectsToLookFor.remove(d.getName());
                    projectPaths.put(d.getName(), (IPath)new Path(d.getAbsolutePath()));
                } else {
                    this.collectProjects(projectPaths, projectsToLookFor, d, monitor);
                }
                ++n2;
            }
        }
    }

    private IProject createProject(String projectName, IPath location, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            return null;
        }
        if (!Platform.getLocation().equals((Object)location)) {
            IProjectDescription desc = project.getWorkspace().newProjectDescription(projectName);
            desc.setLocation(location);
            project.create(desc, monitor);
        } else {
            project.create(monitor);
        }
        project.open(0, monitor);
        return project;
    }
}

