/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.model;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.tools.project.examples.internal.model.XmlUnMarshallers;

@XmlRootElement(name="fix")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RequirementModel {
    public static final String ALLOWED_VERSIONS = "allowed-versions";
    public static final String ECLIPSE_PROJECTS = "eclipse-projects";
    public static final String ALLOWED_TYPES = "allowed-types";
    public static final String ID = "id";
    public static final String VERSION = "VERSION";
    public static final String DESCRIPTION = "description";
    public static final String DOWNLOAD_ID = "downloadId";
    public static final String CONNECTOR_ID = "connectorIds";
    @XmlAttribute
    private String type;
    @XmlAttribute
    private boolean required = false;
    @XmlElement(name="property")
    private List<XmlUnMarshallers.XmlProperty> xmlProperties;
    @XmlTransient
    private Map<String, String> properties;

    private void setXmlProperties(List<XmlUnMarshallers.XmlProperty> xmlProperties) {
        this.xmlProperties = xmlProperties;
    }

    private List<XmlUnMarshallers.XmlProperty> getXmlProperties() {
        return this.xmlProperties;
    }

    public RequirementModel() {
    }

    public RequirementModel(String type) {
        this();
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, String>();
            if (this.xmlProperties != null) {
                for (XmlUnMarshallers.XmlProperty property : this.xmlProperties) {
                    this.properties.put(property.key, property.body);
                }
            }
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties == null ? null : new LinkedHashMap<String, String>(properties);
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }
}

