/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.project.examples.internal.Messages;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.project.examples.wizard.ContributedPage;
import org.jboss.tools.project.examples.wizard.IProjectExamplesWizardPage;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesLocationPage;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesMainPage;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesRequirementsPage;
import org.jboss.tools.project.examples.wizard.WizardContext;

public class NewProjectExamplesWizard2
extends Wizard
implements INewWizard {
    private NewProjectExamplesMainPage mainPage;
    private NewProjectExamplesRequirementsPage requirementsPage;
    private NewProjectExamplesLocationPage locationPage;
    private IStructuredSelection fSelection;
    List<IProjectExamplesWizardPage> contributedPages = new LinkedList<IProjectExamplesWizardPage>();
    private ProjectExampleWorkingCopy projectExample;
    private WizardContext wizardContext = new WizardContext();
    private boolean helpAvailable;

    public NewProjectExamplesWizard2() {
        this.saveHelpAvailable();
        this.setWindowTitle(Messages.NewProjectExamplesWizard_New_Project_Example);
        this.setNeedsProgressMonitor(true);
    }

    public NewProjectExamplesWizard2(ProjectExample projectExample) {
        this.saveHelpAvailable();
        this.initializeProjectExample(projectExample);
    }

    private void saveHelpAvailable() {
        this.helpAvailable = TrayDialog.isDialogHelpAvailable();
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    protected void initializeProjectExample(ProjectExample projectExample) {
        if (projectExample != null) {
            this.projectExample = ProjectExamplesActivator.getDefault().getProjectExampleManager().createWorkingCopy(projectExample);
        }
        this.setWindowTitle(Messages.NewProjectExamplesWizard_New_Project_Example);
        this.setNeedsProgressMonitor(true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        ArrayList<ProjectExampleWorkingCopy> selectedProjects = new ArrayList<ProjectExampleWorkingCopy>();
        IWorkingSet[] workingSets = new IWorkingSet[]{};
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        String showCheatsheets = ProjectExamplesActivator.getDefault().getShowCheatsheets();
        try {
            ProjectExamplesActivator.getDefault().getPreferenceStore().putValue("showCheatsheets", "never");
            if (this.mainPage != null) {
                if (this.mainPage.getSelection() == null || this.mainPage.getSelection().size() <= 0) {
                    return false;
                }
                IStructuredSelection selection = this.mainPage.getSelection();
                for (Object object : selection) {
                    if (!(object instanceof ProjectExample)) continue;
                    ProjectExample project = (ProjectExample)object;
                    ProjectExampleWorkingCopy copy = ProjectExamplesActivator.getDefault().getProjectExampleManager().createWorkingCopy(project);
                    selectedProjects.add(copy);
                }
            } else {
                if (this.projectExample == null) {
                    return false;
                }
                selectedProjects.add(this.projectExample);
            }
            if (selectedProjects.size() > 0) {
                this.projectExample = (ProjectExampleWorkingCopy)selectedProjects.get(0);
            }
            if (this.projectExample != null) {
                if (!"mavenArchetype".equals(this.projectExample.getImportType())) {
                    workingSets = this.locationPage.getWorkingSets();
                }
                String type = this.projectExample.getImportType();
                for (IProjectExamplesWizardPage contributedPage : this.contributedPages) {
                    if (type == null || !type.equals(contributedPage.getProjectExampleType())) continue;
                    if (!contributedPage.finishPage()) {
                        return false;
                    }
                    Map<String, Object> pMap = contributedPage.getPropertiesMap();
                    if (pMap == null) continue;
                    propertiesMap.putAll(pMap);
                }
            }
            propertiesMap.put("showCheatsheets", showCheatsheets);
            ProjectExamplesActivator.importProjectExamples(selectedProjects, workingSets, propertiesMap);
        }
        catch (Exception e) {
            ProjectExamplesActivator.getDefault().getPreferenceStore().putValue("showCheatsheets", showCheatsheets);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initializeDefaultPageImageDescriptor();
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = ProjectExamplesActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.project.examples", (String)"icons/new_wiz.gif");
        this.setDefaultPageImageDescriptor(desc);
    }

    public void addPages() {
        this.createContributedPages();
        if (this.projectExample == null) {
            this.mainPage = new NewProjectExamplesMainPage();
            this.addPage((IWizardPage)this.mainPage);
        }
        for (IProjectExamplesWizardPage page : this.getContributedPages("requirement")) {
            if (this.projectExample != null && !this.projectExample.getImportType().equals(page.getProjectExampleType())) continue;
            this.addPage(page);
        }
        this.locationPage = new NewProjectExamplesLocationPage();
        this.addPage((IWizardPage)this.locationPage);
        if (this.getSelection() != null) {
            this.locationPage.init(this.getSelection(), this.getActivePart());
        }
        for (IProjectExamplesWizardPage page : this.getContributedPages("extra")) {
            if (this.projectExample != null && !this.projectExample.getImportType().equals(page.getProjectExampleType())) continue;
            this.addPage(page);
        }
    }

    protected void createContributedPages() {
        Map<String, List<ContributedPage>> extensionPages = ProjectExamplesActivator.getDefault().getContributedPages();
        for (List<ContributedPage> contributions : extensionPages.values()) {
            for (ContributedPage page : contributions) {
                try {
                    IProjectExamplesWizardPage contributedPage = (IProjectExamplesWizardPage)page.getConfigurationElement().createExecutableExtension("class");
                    this.contributedPages.add(contributedPage);
                }
                catch (CoreException e) {
                    ProjectExamplesActivator.log(e);
                }
            }
        }
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    private IStructuredSelection getSelection() {
        if (this.fSelection == null) {
            if (this.getActivePart() == null || this.getActivePart().getSite() == null || this.getActivePart().getSite().getSelectionProvider() == null) {
                return new StructuredSelection();
            }
            ISelection sel = this.getActivePart().getSite().getSelectionProvider().getSelection();
            if (sel instanceof IStructuredSelection) {
                this.fSelection = (IStructuredSelection)sel;
            }
        }
        return this.fSelection;
    }

    public ProjectExample getSelectedProjectExample() {
        if (this.projectExample != null) {
            return this.projectExample;
        }
        return this.mainPage == null ? null : this.mainPage.getSelectedProject();
    }

    public List<IProjectExamplesWizardPage> getContributedPages() {
        return this.contributedPages;
    }

    public List<IProjectExamplesWizardPage> getContributedPages(String pageType) {
        if (this.contributedPages == null || this.contributedPages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IProjectExamplesWizardPage> filteredPages = new ArrayList<IProjectExamplesWizardPage>();
        for (IProjectExamplesWizardPage p : this.contributedPages) {
            if (!pageType.equals(p.getPageType())) continue;
            filteredPages.add(p);
        }
        return filteredPages;
    }

    public IWizardPage getLocationsPage() {
        return this.locationPage;
    }

    public IWizardPage getRequirementsPage() {
        return this.requirementsPage;
    }

    public boolean canFinish() {
        IWizardPage[] pages;
        ProjectExample example = this.getSelectedProjectExample();
        if (example == null) {
            return false;
        }
        IWizardPage[] iWizardPageArray = pages = this.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            String type;
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof IProjectExamplesWizardPage ? (type = ((IProjectExamplesWizardPage)page).getProjectExampleType()) != null && type.equals(example.getImportType()) && !page.isPageComplete() : !page.isPageComplete()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public ProjectExampleWorkingCopy getProjectExample() {
        return this.projectExample;
    }

    public void addPage(IWizardPage page) {
        if (page instanceof IProjectExamplesWizardPage) {
            IProjectExamplesWizardPage ewp = (IProjectExamplesWizardPage)page;
            ewp.setWizardContext(this.wizardContext);
            this.wizardContext.addListener(ewp);
            if (this.projectExample != null && ewp.getProjectExampleType().equals(this.projectExample.getImportType())) {
                ewp.setProjectExample(this.projectExample);
            }
        }
        super.addPage(page);
    }

    public void dispose() {
        TrayDialog.setDialogHelpAvailable((boolean)this.helpAvailable);
        super.dispose();
    }
}

