/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.startup;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.core.util.RuntimeInitializerUtil;
import org.jboss.tools.runtime.core.util.RuntimeModelUtil;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.internal.Messages;
import org.jboss.tools.runtime.ui.internal.dialogs.SearchRuntimePathDialog;
import org.jboss.tools.runtime.ui.internal.startup.JBossRuntimeStartup;

public class RuntimeScanner
implements IStartup {
    private static RuntimeScanner instance = null;
    private Job initializationJob = null;

    public static RuntimeScanner getDefault() {
        return instance;
    }

    public RuntimeScanner() {
        instance = this;
    }

    public void earlyStartup() {
        if (Boolean.getBoolean("skip.runtime.scanner")) {
            return;
        }
        boolean firstStart = this.isFirstStart();
        Job runtimeJob = this.getOrCreateInitializationJob(firstStart);
        runtimeJob.schedule(1000L);
        this.setFirstStartFalse();
    }

    public Job getInitializationJob() {
        return this.initializationJob;
    }

    public Job getOrCreateInitializationJob(boolean firstStart) {
        if (this.initializationJob == null) {
            this.initializationJob = this.createJob(firstStart);
        }
        return this.initializationJob;
    }

    private Job createJob(final boolean firstStart) {
        Job runtimeJob = new Job(Messages.RuntimeScanner_Searching_runtimes){

            protected IStatus run(IProgressMonitor monitor) {
                if (firstStart) {
                    JBossRuntimeStartup.initializeRuntimes(monitor);
                }
                boolean openDialog = RuntimeScanner.this.wouldOpenSearchRuntimePathDialog(firstStart, monitor);
                if (monitor.isCanceled()) {
                    RuntimeUIActivator.getDefault().getModel().setRuntimePaths(null);
                    return Status.CANCEL_STATUS;
                }
                if (openDialog) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
                            HashSet<RuntimePath> runtimePaths = new HashSet<RuntimePath>();
                            RuntimePath[] runtimePathArray = RuntimeUIActivator.getDefault().getModel().getRuntimePaths();
                            int n = runtimePathArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                RuntimePath runtimePath = runtimePathArray[n2];
                                if (runtimePath.isScanOnEveryStartup() || firstStart) {
                                    runtimePaths.add(runtimePath);
                                }
                                ++n2;
                            }
                            RuntimePath[] asArr = runtimePaths.toArray(new RuntimePath[runtimePaths.size()]);
                            if (runtimePaths.size() > 0) {
                                SearchRuntimePathDialog.launchSearchRuntimePathDialog(shell, asArr, false, 7);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        runtimeJob.setUser(false);
        runtimeJob.setSystem(false);
        runtimeJob.setPriority(30);
        return runtimeJob;
    }

    private boolean isFirstStart() {
        boolean firstStartWorkspace = RuntimeUIActivator.getDefault().getPreferenceStore().getBoolean("firstStart");
        IEclipsePreferences configurationNode = ConfigurationScope.INSTANCE.getNode("org.jboss.tools.runtime.ui");
        boolean firstStartConfiguration = configurationNode.getBoolean("firstStart", true);
        boolean firstStart = firstStartWorkspace || firstStartConfiguration;
        return firstStart;
    }

    private void setFirstStartFalse() {
        IEclipsePreferences configurationNode = ConfigurationScope.INSTANCE.getNode("org.jboss.tools.runtime.ui");
        configurationNode.putBoolean("firstStart", false);
        RuntimeUIActivator.getDefault().getPreferenceStore().setValue("firstStart", false);
    }

    private boolean wouldOpenSearchRuntimePathDialog(boolean firstStart, IProgressMonitor monitor) {
        RuntimePath[] runtimePaths = RuntimeUIActivator.getDefault().getModel().getRuntimePaths();
        boolean ret = false;
        RuntimePath[] runtimePathArray = runtimePaths;
        int n = runtimePaths.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimePath runtimePath = runtimePathArray[n2];
            if (firstStart || runtimePath.isScanOnEveryStartup()) {
                RuntimeDefinition[] runtimeDefinitions;
                if (monitor.isCanceled()) {
                    return false;
                }
                if (runtimePath.isModified()) {
                    RuntimeInitializerUtil.createRuntimeDefinitions((RuntimePath)runtimePath, (IProgressMonitor)monitor);
                }
                monitor.setTaskName(String.valueOf(Messages.RuntimeScanner_JBoss_Runtime_Detector_checking) + runtimePath.getPath());
                RuntimeDefinition[] runtimeDefinitionArray = runtimeDefinitions = runtimePath.getRuntimeDefinitions();
                int n3 = runtimeDefinitions.length;
                int n4 = 0;
                while (n4 < n3) {
                    RuntimeDefinition runtimeDefinition = runtimeDefinitionArray[n4];
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    if (runtimeDefinition.isEnabled()) {
                        monitor.setTaskName(String.valueOf(Messages.RuntimeScanner_JBoss_Runtime_Detector_checking) + runtimeDefinition.getLocation());
                        if (!RuntimeModelUtil.verifyRuntimeDefinitionCreated((RuntimeDefinition)runtimeDefinition)) {
                            ret = true;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        RuntimeModelUtil.updateTimestamps((RuntimePath[])runtimePaths);
        RuntimeUIActivator.getDefault().saveRuntimePreferences();
        return ret;
    }
}

