/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.resref.core;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.vpe.resref.core.AbsoluteFolderReferenceComposite;
import org.jboss.tools.vpe.resref.core.CssReferencesComposite;
import org.jboss.tools.vpe.resref.core.ElVariablesComposite;
import org.jboss.tools.vpe.resref.core.Messages;
import org.jboss.tools.vpe.resref.core.RelativeFolderReferenceComposite;
import org.jboss.tools.vpe.resref.core.TaglibReferencesComposite;

public class VpeResourcesDialog
extends TitleAreaDialog {
    Object fileLocation = null;
    CssReferencesComposite css = null;
    ElVariablesComposite el = null;
    TaglibReferencesComposite tld = null;
    AbsoluteFolderReferenceComposite absFolder = null;
    RelativeFolderReferenceComposite relFolder = null;
    CommandBar commandBar = new CommandBar();
    private final int DIALOG_WIDTH = 400;
    private final int DIALOG_HEIGHT = 300;

    public VpeResourcesDialog(Shell parentShell, Object fileLocation, ResourceReference defaultAbsReference, ResourceReference defaultRelReference) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.fileLocation = fileLocation;
        this.absFolder = new AbsoluteFolderReferenceComposite();
        this.relFolder = new RelativeFolderReferenceComposite();
        this.css = new CssReferencesComposite();
        this.el = new ElVariablesComposite();
        this.tld = new TaglibReferencesComposite();
        this.css.setObject(fileLocation);
        this.el.setObject(fileLocation);
        this.tld.setObject(fileLocation);
        this.absFolder.setObject(fileLocation, defaultAbsReference);
        this.relFolder.setObject(fileLocation, defaultRelReference);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.VRD_DEFAULT_WINDOW_TITLE);
        this.setTitle(Messages.VRD_DEFAULT_TITLE);
        this.setTitleImage(ModelUIImages.getImage((String)ModelUIImages.WIZARD_DEFAULT));
        this.setMessage(Messages.VRD_PAGE_DESIGN_OPTIONS_ABOUT);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label dialogAreaSeparator = new Label(composite, 258);
        dialogAreaSeparator.setLayoutData((Object)new GridData(4, 0, true, false));
        Control pageArea = this.createTabFolder(composite);
        GridData gd = new GridData(4, 4, true, true);
        pageArea.setLayoutData((Object)gd);
        dialogAreaSeparator = new Label(composite, 258);
        dialogAreaSeparator.setLayoutData((Object)new GridData(4, 0, true, false));
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        gd.heightHint = 300;
        composite.setLayoutData((Object)gd);
        return composite;
    }

    public Control createTabFolder(Composite parent) {
        final TabFolder tabFolder = new TabFolder(parent, 4);
        TabItem foldersTab = new TabItem(tabFolder, 0);
        TabItem cssTab = new TabItem(tabFolder, 0);
        TabItem tldTab = new TabItem(tabFolder, 0);
        TabItem elTab = new TabItem(tabFolder, 0);
        Composite foldersControl = new Composite((Composite)tabFolder, 0);
        foldersControl.setLayout((Layout)new GridLayout(1, false));
        this.absFolder.createControl(foldersControl);
        this.relFolder.createControl(foldersControl);
        Control cssControl = this.css.createControl((Composite)tabFolder);
        Control tldControl = this.tld.createControl((Composite)tabFolder);
        Control elControl = this.el.createControl((Composite)tabFolder);
        foldersTab.setText(Messages.VRD_ACTUAL_RUN_TIME_FOLDERS);
        foldersTab.setToolTipText(Messages.VRD_ACTUAL_RUN_TIME_FOLDERS);
        foldersTab.setControl((Control)foldersControl);
        cssTab.setText(Messages.VRD_INCLUDED_CSS_FILES);
        cssTab.setToolTipText(Messages.VRD_INCLUDED_CSS_FILES);
        cssTab.setControl(cssControl);
        tldTab.setText(Messages.VRD_INCLUDED_TAG_LIBS);
        tldTab.setToolTipText(Messages.VRD_INCLUDED_TAG_LIBS);
        tldTab.setControl(tldControl);
        elTab.setText(Messages.VRD_SUBSTITUTED_EL_EXPRESSIONS);
        elTab.setToolTipText(Messages.VRD_SUBSTITUTED_EL_EXPRESSIONS);
        elTab.setControl(elControl);
        tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String selectedTabText = tabFolder.getSelection()[0].getText();
                if (Messages.VRD_ACTUAL_RUN_TIME_FOLDERS.equals(selectedTabText)) {
                    VpeResourcesDialog.this.setMessage(Messages.VRD_ACTUAL_RUN_TIME_FOLDERS_ABOUT);
                } else if (Messages.VRD_INCLUDED_CSS_FILES.equals(selectedTabText)) {
                    VpeResourcesDialog.this.setMessage(Messages.VRD_INCLUDED_CSS_FILES_ABOUT);
                } else if (Messages.VRD_INCLUDED_TAG_LIBS.equals(selectedTabText)) {
                    VpeResourcesDialog.this.setMessage(Messages.VRD_INCLUDED_TAG_LIBS_ABOUT);
                } else if (Messages.VRD_SUBSTITUTED_EL_EXPRESSIONS.equals(selectedTabText)) {
                    VpeResourcesDialog.this.setMessage(Messages.VRD_SUBSTITUTED_EL_EXPRESSIONS_ABOUT);
                }
            }
        });
        return tabFolder;
    }

    protected void okPressed() {
        super.okPressed();
        this.absFolder.commit();
        this.relFolder.commit();
        this.el.commit();
        this.css.commit();
        this.tld.commit();
    }
}

