/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.xulrunner.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.jboss.tools.vpe.xulrunner.BrowserPlugin;
import org.jboss.tools.vpe.xulrunner.XulRunnerException;
import org.jboss.tools.vpe.xulrunner.browser.XulRunnerBrowser;
import org.jboss.tools.vpe.xulrunner.editor.Flasher;
import org.jboss.tools.vpe.xulrunner.editor.FlasherData;
import org.jboss.tools.vpe.xulrunner.editor.IVpeResizeListener;
import org.jboss.tools.vpe.xulrunner.editor.IVpeSelectionListener;
import org.jboss.tools.vpe.xulrunner.editor.IXulRunnerVpeResizer;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerVpeResizer;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIBaseWindow;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;

public class XulRunnerEditor
extends XulRunnerBrowser {
    private VisualPaintListener paintListener;
    private IVpeResizeListener resizeListener;
    private List<IVpeSelectionListener> selectionListeners = new ArrayList<IVpeSelectionListener>();
    private IXulRunnerVpeResizer xulRunnerVpeResizer;
    private static String visibleSelectedElementColor = "#0000ff";
    private static String hiddenSelectedElementColor = "#ff0000";
    public static String VPE_INVISIBLE_ELEMENT = "vpeInvisibleElement";
    public static final String TRANS_FLAVOR_kHTMLMime = "text/html";
    public static final String TRANS_FLAVOR_kURLDataMime = "text/x-moz-url-data";
    public static final String TRANS_FLAVOR_kFileMime = "application/x-moz-file";
    public static final String TRANS_FLAVOR_kURLMime = "text/x-moz-url";
    public static final String TRANS_FLAVOR_kUnicodeMime = "text/unicode";
    public static final String TRANS_FLAVOR_kNativeHTMLMime = "application/x-moz-nativehtml";
    private Flasher flasher;
    private static final Pattern PATTERN = Pattern.compile(".*\\s*(display)\\s*:\\s*(none)\\s*;.*", 34);
    public static final String STYLE_ATTR = "style";
    private List<nsIDOMNode> selectedNodes;
    private int lastResizerConstrains;
    private Listener eventListenet = new Listener(){

        public void handleEvent(Event event) {
            Display.getCurrent().asyncExec((Runnable)new Thread(){

                @Override
                public void run() {
                    if (XulRunnerEditor.this.getBrowser() != null && !XulRunnerEditor.this.getBrowser().isDisposed()) {
                        XulRunnerEditor.this.showResizer();
                        XulRunnerEditor.this.redrawSelectionRectangle();
                    }
                }
            });
        }
    };

    public XulRunnerEditor(Composite parent) throws XulRunnerException {
        super(parent);
        this.getBrowser().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (XulRunnerEditor.this.paintListener != null) {
                    XulRunnerEditor.this.getBrowser().getParent().removePaintListener((PaintListener)XulRunnerEditor.this.paintListener);
                    XulRunnerEditor.this.paintListener = null;
                }
                XulRunnerEditor.this.getWebBrowser().removeWebBrowserListener((nsISupports)XulRunnerEditor.this, "{44b78386-1dd2-11b2-9ad2-e4eee2ca1916}");
                XulRunnerEditor.this.removeProgressListener(XulRunnerEditor.this);
                if (XulRunnerEditor.this.resizeListener != null) {
                    XulRunnerEditor.this.getIXulRunnerVpeResizer().removeResizeListener(XulRunnerEditor.this.resizeListener);
                }
                XulRunnerEditor.this.xulRunnerVpeResizer.dispose();
                XulRunnerEditor.this.xulRunnerVpeResizer = null;
                XulRunnerEditor.this.resizeListener = null;
                if (XulRunnerEditor.this.eventListenet != null) {
                    XulRunnerEditor.this.removeListener(9, XulRunnerEditor.this.eventListenet);
                    XulRunnerEditor.this.removeListener(22, XulRunnerEditor.this.eventListenet);
                    XulRunnerEditor.this.removeListener(15, XulRunnerEditor.this.eventListenet);
                    XulRunnerEditor.this.removeListener(13, XulRunnerEditor.this.eventListenet);
                    XulRunnerEditor.this.removeListener(11, XulRunnerEditor.this.eventListenet);
                    XulRunnerEditor.this.eventListenet = null;
                }
                XulRunnerEditor.this.getBrowser().removeDisposeListener((DisposeListener)this);
                XulRunnerEditor.this.onDispose();
            }
        });
        this.paintListener = new VisualPaintListener();
        this.getBrowser().getParent().addPaintListener((PaintListener)this.paintListener);
        this.addListener(11, this.eventListenet);
        this.addListener(22, this.eventListenet);
        this.addListener(15, this.eventListenet);
        this.addListener(13, this.eventListenet);
        this.addListener(9, this.eventListenet);
        this.resizeListener = new IVpeResizeListener(){

            @Override
            public void onEndResizing(int usedResizeMarkerHandle, int top, int left, int width, int height, nsIDOMElement resizedDomElement) {
                XulRunnerEditor.this.endResizing(usedResizeMarkerHandle, top, left, width, height, resizedDomElement);
            }

            public nsISupports queryInterface(String uuid) {
                return null;
            }
        };
    }

    public void onElementResize(nsIDOMElement element, int handle, int top, int left, int width, int height) {
    }

    public void removeResizeListener() {
        if (this.resizeListener != null) {
            this.getIXulRunnerVpeResizer().removeResizeListener(this.resizeListener);
        }
    }

    public void addResizeListener() {
        if (this.getIXulRunnerVpeResizer() != null) {
            this.getIXulRunnerVpeResizer().init(this.getDOMDocument());
            this.getIXulRunnerVpeResizer().addResizeListener(this.resizeListener);
        }
    }

    public void addSelectionListener(IVpeSelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(IVpeSelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    private void fireSelectionListeners() {
        for (IVpeSelectionListener listener : this.selectionListeners) {
            listener.selectionChanged();
        }
    }

    @Override
    public void onLoadWindow() {
        this.addResizeListener();
    }

    public nsIDOMDocument getDOMDocument() {
        nsIDOMWindow domWindow = this.getWebBrowser().getContentDOMWindow();
        return domWindow.getDocument();
    }

    public List<nsIDOMNode> getSelectedNodes() {
        if (this.selectedNodes == null) {
            this.selectedNodes = Collections.emptyList();
        }
        return this.selectedNodes;
    }

    public void setSelectionRectangle(List<nsIDOMNode> nodes, int resizerConstrains) {
        this.getFlasher();
        this.selectedNodes = nodes;
        nsIDOMElement element = this.getSelectedElement();
        if (element != null) {
            this.repaint();
            this.scrollToElement(element);
        }
        this.redrawSelectionRectangle();
        if (this.xulRunnerVpeResizer != null) {
            if (element != null && resizerConstrains != 0) {
                this.xulRunnerVpeResizer.show(element, resizerConstrains);
            } else {
                this.xulRunnerVpeResizer.hide();
            }
        }
        this.lastResizerConstrains = resizerConstrains;
        this.fireSelectionListeners();
    }

    private void repaint() {
        try {
            XPCOM.queryInterface((nsISupports)this.getWebBrowser(), nsIBaseWindow.class).repaint(true);
        }
        catch (XPCOMException ex) {
            BrowserPlugin.getDefault().logInfo("repaint failed", ex);
        }
    }

    private Flasher getFlasher() {
        if (this.flasher == null) {
            this.flasher = new Flasher();
        }
        return this.flasher;
    }

    private IXulRunnerVpeResizer getIXulRunnerVpeResizer() {
        if (this.xulRunnerVpeResizer == null) {
            this.xulRunnerVpeResizer = new XulRunnerVpeResizer();
        }
        return this.xulRunnerVpeResizer;
    }

    private boolean isVisible(nsIDOMNode node) {
        nsIDOMElement domElement;
        try {
            domElement = XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class);
        }
        catch (XPCOMException exception) {
            return false;
        }
        String inlineStyle = domElement.getAttribute(STYLE_ATTR);
        return inlineStyle == null ? true : !PATTERN.matcher(inlineStyle).matches();
    }

    /*
     * Unable to fully structure code
     */
    private nsIDOMElement findVisibleParentElement(nsIDOMElement element) {
        try {
            parentElement = XPCOM.queryInterface((nsISupports)element.getParentNode(), nsIDOMElement.class);
            if (true) ** GOTO lbl10
        }
        catch (XPCOMException ex) {
            return null;
        }
        do {
            if (this.isVisible((nsIDOMNode)parentElement)) {
                return parentElement;
            }
            parentElement = XPCOM.queryInterface((nsISupports)parentElement.getParentNode(), nsIDOMElement.class);
lbl10:
            // 2 sources

        } while (parentElement != null && !this.isVisible((nsIDOMNode)parentElement));
        return parentElement;
    }

    private void endResizing(int usedHandle, int newTop, int newLeft, int newWidth, int newHeight, nsIDOMElement aResizedObject) {
        this.onElementResize(aResizedObject, usedHandle, newTop, newLeft, newWidth, newHeight);
    }

    public void showResizer() {
        nsIDOMElement selectedElement = this.getSelectedElement();
        if (this.xulRunnerVpeResizer != null && selectedElement != null && this.lastResizerConstrains != 0) {
            this.xulRunnerVpeResizer.show(selectedElement, this.lastResizerConstrains);
        }
    }

    public void hideResizer() {
        if (this.xulRunnerVpeResizer != null) {
            this.xulRunnerVpeResizer.hide();
        }
    }

    public void redrawSelectionRectangle() {
        ArrayList<FlasherData> flasherDatas = new ArrayList<FlasherData>();
        for (nsIDOMNode domNode : this.getSelectedNodes()) {
            flasherDatas.add(this.prepareFlasherData(domNode));
        }
        this.drawElementOutline(flasherDatas);
    }

    private FlasherData prepareFlasherData(nsIDOMNode domNode) {
        nsIDOMElement domElement = XulRunnerEditor.getElementForNode(domNode);
        String selectionBorderColor = this.getVisibleSelectedElementColor();
        if (domElement != null) {
            if (this.isVisible((nsIDOMNode)domElement)) {
                selectionBorderColor = domElement.getAttribute(VPE_INVISIBLE_ELEMENT) == null || !domElement.getAttribute(VPE_INVISIBLE_ELEMENT).equals(Boolean.TRUE.toString()) ? this.getVisibleSelectedElementColor() : this.getHiddenSelectedElementColor();
            } else {
                selectionBorderColor = this.getHiddenSelectedElementColor();
                domElement = this.findVisibleParentElement(domElement);
            }
        }
        return new FlasherData(selectionBorderColor, domElement);
    }

    private void scrollToElement(nsIDOMElement element) {
        this.getFlasher().scrollElementIntoView(element);
    }

    private static nsIDOMElement getElementForNode(nsIDOMNode node) {
        if (node != null) {
            if (node.getNodeType() == 1) {
                return XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class);
            }
            if (node.getNodeType() == 3 && node.getParentNode() != null) {
                return XPCOM.queryInterface((nsISupports)node.getParentNode(), nsIDOMElement.class);
            }
        }
        return null;
    }

    private void drawElementOutline(List<FlasherData> flasherData) {
        this.getFlasher().drawElementOutline(flasherData);
    }

    @Override
    protected void onDispose() {
        this.selectedNodes = new ArrayList<nsIDOMNode>();
        if (this.flasher != null) {
            this.flasher.dispose();
            this.flasher = null;
        }
        super.onDispose();
    }

    public nsIDOMElement getSelectedElement() {
        nsIDOMElement resizeElement = null;
        if (!this.getSelectedNodes().isEmpty()) {
            resizeElement = XulRunnerEditor.getElementForNode(this.getSelectedNodes().get(0));
        }
        return resizeElement;
    }

    public Event createSWTKeyEvent(nsIDOMKeyEvent keyEvent) {
        Event keyboardEvent = new Event();
        keyboardEvent.widget = this.getBrowser();
        keyboardEvent.stateMask = (keyEvent.getAltKey() ? 65536 : 0) | (keyEvent.getCtrlKey() ? 262144 : 0) | (keyEvent.getShiftKey() ? 131072 : 0) | (keyEvent.getMetaKey() ? SWT.MOD1 : 0);
        keyboardEvent.x = 0;
        keyboardEvent.y = 0;
        keyboardEvent.type = 1;
        keyboardEvent.keyCode = keyEvent.getKeyCode() == 0L ? (int)keyEvent.getCharCode() : (int)keyEvent.getKeyCode();
        return keyboardEvent;
    }

    public String getVisibleSelectedElementColor() {
        return visibleSelectedElementColor;
    }

    public void setVisibleSelectedElementColor(String visibleSelectedElementColor) {
        XulRunnerEditor.visibleSelectedElementColor = visibleSelectedElementColor;
    }

    public String getHiddenSelectedElementColor() {
        return hiddenSelectedElementColor;
    }

    public void setHiddenSelectedElementColor(String hiddenSelectedElementColor) {
        XulRunnerEditor.hiddenSelectedElementColor = hiddenSelectedElementColor;
    }

    private class VisualPaintListener
    implements PaintListener {
        private VisualPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            XulRunnerEditor.this.redrawSelectionRectangle();
        }
    }
}

