/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.mozilla;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.i18n.ExternalizeStringsDialog;
import org.jboss.tools.jst.web.ui.internal.editor.i18n.ExternalizeStringsUtils;
import org.jboss.tools.jst.web.ui.internal.editor.i18n.ExternalizeStringsWizard;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeController;
import org.jboss.tools.vpe.editor.mozilla.MozillaEventAdapter;
import org.jboss.tools.vpe.editor.mozilla.XulRunnerEditor2;
import org.jboss.tools.vpe.editor.mozilla.listener.EditorLoadWindowListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaResizeListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaTooltipListener;
import org.jboss.tools.vpe.editor.preferences.VpeEditorPreferencesPage;
import org.jboss.tools.vpe.editor.preferences.VpeResourcesDialogFactory;
import org.jboss.tools.vpe.editor.toolbar.IVpeToolBarManager;
import org.jboss.tools.vpe.editor.toolbar.VpeDropDownMenu;
import org.jboss.tools.vpe.editor.toolbar.VpeToolBarManager;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.toolbar.format.TextFormattingToolBar;
import org.jboss.tools.vpe.editor.util.DocTypeUtil;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.preview.core.exceptions.XulRunnerErrorWrapper;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMNamedNodeMap;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIEditingSession;
import org.mozilla.interfaces.nsIEditor;
import org.mozilla.interfaces.nsIHTMLAbsPosEditor;
import org.mozilla.interfaces.nsIHTMLInlineTableEditor;
import org.mozilla.interfaces.nsIHTMLObjectResizer;
import org.mozilla.interfaces.nsISupports;

public class MozillaEditor
extends EditorPart
implements IReusableEditor {
    protected static final File INIT_FILE = new File(VpePlugin.getDefault().getResourcePath("ve"), "init.html");
    public static final String CONTENT_AREA_ID = "__content__area__";
    public static final String ICON_PREFERENCE = "icons/preference.gif";
    public static final String ICON_PREFERENCE_DISABLED = "icons/preference_disabled.gif";
    public static final String ICON_REFRESH = "icons/refresh.gif";
    public static final String ICON_REFRESH_DISABLED = "icons/refresh_disabled.gif";
    public static final String ICON_PAGE_DESIGN_OPTIONS = "icons/point_to_css.gif";
    public static final String ICON_PAGE_DESIGN_OPTIONS_DISABLED = "icons/point_to_css_disabled.gif";
    public static final String ICON_ORIENTATION_SOURCE_LEFT = "icons/source_left.gif";
    public static final String ICON_ORIENTATION_SOURCE_TOP = "icons/source_top.gif";
    public static final String ICON_ORIENTATION_VISUAL_LEFT = "icons/visual_left.gif";
    public static final String ICON_ORIENTATION_VISUAI_TOP = "icons/visual_top.gif";
    public static final String ICON_ORIENTATION_SOURCE_LEFT_DISABLED = "icons/source_left_disabled.gif";
    public static final String ICON_SHOW_BORDER_FOR_UNKNOWN_TAGS = "icons/border.gif";
    public static final String ICON_NON_VISUAL_TAGS = "icons/non-visusal-tags.gif";
    public static final String ICON_SELECTION_BAR = "icons/selbar.gif";
    public static final String ICON_TEXT_FORMATTING = "icons/text-formatting.gif";
    public static final String ICON_BUNDLE_AS_EL = "icons/bundle-as-el.gif";
    public static final String ICON_SCROLL_LOCK = "icons/scroll_lock.gif";
    public static final String ICON_EXTERNALIZE_STRINGS = "icons/externalize.png";
    private XulRunnerEditor xulRunnerEditor;
    private nsIDOMElement contentArea;
    private nsIDOMNode headNode;
    private MozillaEventAdapter mozillaEventAdapter = this.createMozillaEventAdapter();
    private EditorLoadWindowListener editorLoadWindowListener;
    private IVpeToolBarManager vpeToolBarManager;
    private FormatControllerManager formatControllerManager = new FormatControllerManager();
    private VpeController controller;
    private boolean isRefreshPage = false;
    private String doctype;
    private static Map<String, String> layoutIcons = new HashMap<String, String>();
    private static Map<String, String> layoutNames;
    private static List<String> layoutValues;
    private int currentOrientationIndex = 1;
    private Action openVPEPreferencesAction;
    private Action visualRefreshAction;
    private Action showResouceDialogAction;
    private Action rotateEditorsAction;
    private Action showBorderAction;
    private Action showNonVisualTagsAction;
    private Action showSelectionBarAction;
    private Action showTextFormattingAction;
    private Action showBundleAsELAction;
    private Action scrollLockAction;
    private Action externalizeStringsAction;
    private nsIEditor editor;
    private VpeDropDownMenu dropDownMenu = null;
    private ToolBar verBar = null;
    private MozillaResizeListener resizeListener;
    private MozillaTooltipListener tooltipListener;
    private IPropertyChangeListener selectionBarCloseListener;
    protected XulRunnerErrorWrapper errorWrapper = new XulRunnerErrorWrapper();

    static {
        layoutIcons.put("3", ICON_ORIENTATION_SOURCE_LEFT);
        layoutIcons.put("1", ICON_ORIENTATION_SOURCE_TOP);
        layoutIcons.put("4", ICON_ORIENTATION_VISUAL_LEFT);
        layoutIcons.put("2", ICON_ORIENTATION_VISUAI_TOP);
        layoutNames = new HashMap<String, String>();
        layoutNames.put("3", VpeUIMessages.SPLITTING_HORIZ_LEFT_SOURCE_TOOLTIP);
        layoutNames.put("1", VpeUIMessages.SPLITTING_VERT_TOP_SOURCE_TOOLTIP);
        layoutNames.put("4", VpeUIMessages.SPLITTING_HORIZ_LEFT_VISUAL_TOOLTIP);
        layoutNames.put("2", VpeUIMessages.SPLITTING_VERT_TOP_VISUAL_TOOLTIP);
        layoutValues = new ArrayList<String>();
        layoutValues.add("3");
        layoutValues.add("1");
        layoutValues.add("4");
        layoutValues.add("2");
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
    }

    public void setInput(IEditorInput input) {
        boolean isVisualRefreshRequired = this.getEditorInput() != null && this.getEditorInput() != input && this.controller != null;
        super.setInput(input);
        if (isVisualRefreshRequired) {
            this.controller.visualRefresh();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setController(VpeController controller) {
        this.controller = controller;
        this.formatControllerManager.setVpeController(controller);
        controller.setToolbarFormatControllerManager(this.formatControllerManager);
    }

    public ToolBar createVisualToolbar(Composite parent) {
        ILocationProvider provider;
        IPath path;
        final ToolBarManager toolBarManager = new ToolBarManager(0x800200);
        this.verBar = toolBarManager.createControl(parent);
        this.openVPEPreferencesAction = new Action(VpeUIMessages.PREFERENCES, 1){

            public void run() {
                VpeEditorPreferencesPage.openPreferenceDialog();
            }
        };
        this.openVPEPreferencesAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_PREFERENCE));
        this.openVPEPreferencesAction.setToolTipText(VpeUIMessages.PREFERENCES);
        toolBarManager.add((IAction)this.openVPEPreferencesAction);
        this.visualRefreshAction = new Action(VpeUIMessages.REFRESH, 1){

            public void run() {
                if (MozillaEditor.this.controller != null) {
                    MozillaEditor.this.controller.visualRefresh();
                }
            }
        };
        this.visualRefreshAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_REFRESH));
        this.visualRefreshAction.setToolTipText(VpeUIMessages.REFRESH);
        toolBarManager.add((IAction)this.visualRefreshAction);
        IEditorInput input = this.getEditorInput();
        IFile file = null;
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        } else if (input instanceof ILocationProvider && (path = (provider = (ILocationProvider)input).getPath((Object)input)) != null) {
            file = FileUtil.getFile(input, path.lastSegment());
        }
        boolean fileExistsInWorkspace = file != null && file.exists();
        this.showResouceDialogAction = new Action(VpeUIMessages.PAGE_DESIGN_OPTIONS, 1){

            public void run() {
                VpeResourcesDialogFactory.openVpeResourcesDialog((IEditorPart)MozillaEditor.this);
            }
        };
        this.showResouceDialogAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)(fileExistsInWorkspace ? ICON_PAGE_DESIGN_OPTIONS : ICON_PAGE_DESIGN_OPTIONS_DISABLED)));
        if (!fileExistsInWorkspace) {
            this.showResouceDialogAction.setEnabled(false);
        }
        this.showResouceDialogAction.setToolTipText(VpeUIMessages.PAGE_DESIGN_OPTIONS);
        toolBarManager.add((IAction)this.showResouceDialogAction);
        String newOrientation = WebUiPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting");
        this.currentOrientationIndex = layoutValues.indexOf(newOrientation);
        this.rotateEditorsAction = new Action(VpeUIMessages.VISUAL_SOURCE_EDITORS_SPLITTING, 1){

            public void run() {
                MozillaEditor mozillaEditor = MozillaEditor.this;
                mozillaEditor.currentOrientationIndex = mozillaEditor.currentOrientationIndex + 1;
                if (MozillaEditor.this.currentOrientationIndex >= layoutValues.size()) {
                    MozillaEditor mozillaEditor2 = MozillaEditor.this;
                    mozillaEditor2.currentOrientationIndex = mozillaEditor2.currentOrientationIndex % layoutValues.size();
                }
                String newOrientation = (String)layoutValues.get(MozillaEditor.this.currentOrientationIndex);
                this.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)((String)layoutIcons.get(newOrientation))));
                this.setToolTipText((String)layoutNames.get(newOrientation));
                MozillaEditor.this.getController().getPageContext().getEditPart().fillContainer(true, newOrientation);
                WebUiPlugin.getDefault().getPreferenceStore().setValue("Visual/Source Editors Splitting", newOrientation);
            }
        };
        this.rotateEditorsAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)layoutIcons.get(newOrientation)));
        this.rotateEditorsAction.setToolTipText(layoutNames.get(newOrientation));
        toolBarManager.add((IAction)this.rotateEditorsAction);
        this.showBorderAction = new Action(VpeUIMessages.SHOW_BORDER_FOR_UNKNOWN_TAGS, 2){

            public void run() {
                MozillaEditor.this.getController().getVisualBuilder().setShowBorderForUnknownTags(this.isChecked());
                MozillaEditor.this.controller.visualRefresh();
                WebUiPlugin.getDefault().getPreferenceStore().setValue("Show Border for Unknown Tags", this.isChecked());
            }
        };
        this.showBorderAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_SHOW_BORDER_FOR_UNKNOWN_TAGS));
        this.showBorderAction.setToolTipText(VpeUIMessages.SHOW_BORDER_FOR_UNKNOWN_TAGS);
        toolBarManager.add((IAction)this.showBorderAction);
        this.showNonVisualTagsAction = new Action(VpeUIMessages.SHOW_NON_VISUAL_TAGS, 2){

            public void run() {
                MozillaEditor.this.controller.getVisualBuilder().setShowInvisibleTags(this.isChecked());
                MozillaEditor.this.controller.visualRefresh();
                WebUiPlugin.getDefault().getPreferenceStore().setValue("Show non-visual tags", this.isChecked());
            }
        };
        this.showNonVisualTagsAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_NON_VISUAL_TAGS));
        this.showNonVisualTagsAction.setToolTipText(VpeUIMessages.SHOW_NON_VISUAL_TAGS);
        toolBarManager.add((IAction)this.showNonVisualTagsAction);
        this.showTextFormattingAction = new Action(VpeUIMessages.SHOW_TEXT_FORMATTING, 2){

            public void run() {
                MozillaEditor.this.vpeToolBarManager.setToolbarVisibility(this.isChecked());
                WebUiPlugin.getDefault().getPreferenceStore().setValue("Show Text Formatting bar", this.isChecked());
            }
        };
        this.showTextFormattingAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_TEXT_FORMATTING));
        this.showTextFormattingAction.setToolTipText(VpeUIMessages.SHOW_TEXT_FORMATTING);
        toolBarManager.add((IAction)this.showTextFormattingAction);
        this.showBundleAsELAction = new Action(VpeUIMessages.SHOW_BUNDLES_AS_EL, 2){

            public void run() {
                MozillaEditor.this.controller.getPageContext().getBundle().updateShowBundleUsageAsEL(this.isChecked());
                MozillaEditor.this.controller.visualRefresh();
                WebUiPlugin.getDefault().getPreferenceStore().setValue("Show Resource Bundles Usage as EL Expressions", this.isChecked());
            }
        };
        this.showBundleAsELAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_BUNDLE_AS_EL));
        this.showBundleAsELAction.setToolTipText(VpeUIMessages.SHOW_BUNDLES_AS_EL);
        toolBarManager.add((IAction)this.showBundleAsELAction);
        this.scrollLockAction = new Action(VpeUIMessages.SYNCHRONIZE_SCROLLING_BETWEEN_SOURCE_VISUAL_PANES, 2){

            public void run() {
                WebUiPlugin.getDefault().getPreferenceStore().setValue("Synchronize scrolling between source and visual panes", this.isChecked());
            }
        };
        this.scrollLockAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_SCROLL_LOCK));
        this.scrollLockAction.setToolTipText(VpeUIMessages.SYNCHRONIZE_SCROLLING_BETWEEN_SOURCE_VISUAL_PANES);
        toolBarManager.add((IAction)this.scrollLockAction);
        this.externalizeStringsAction = new Action(JstUIMessages.EXTERNALIZE_STRINGS, 1){

            public void run() {
                ExternalizeStringsDialog dlg = new ExternalizeStringsDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)new ExternalizeStringsWizard((ITextEditor)MozillaEditor.this.controller.getSourceEditor(), MozillaEditor.this.controller.getPageContext().getBundle()));
                dlg.open();
            }
        };
        this.externalizeStringsAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_EXTERNALIZE_STRINGS));
        this.externalizeStringsAction.setToolTipText(JstUIMessages.EXTERNALIZE_STRINGS_POPUP_MENU_TITLE);
        toolBarManager.add((IAction)this.externalizeStringsAction);
        this.showSelectionBarAction = new Action(VpeUIMessages.SHOW_SELECTION_BAR, 2){

            public void run() {
                MozillaEditor.this.controller.getPageContext().getEditPart().updateSelectionBar(this.isChecked());
                WebUiPlugin.getDefault().getPreferenceStore().setValue("Show Selection Tag Bar", this.isChecked());
            }
        };
        this.selectionBarCloseListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("Show Selection Tag Bar".equalsIgnoreCase(event.getProperty())) {
                    boolean newValue = event.getNewValue() instanceof String ? Boolean.parseBoolean((String)event.getNewValue()) : (Boolean)event.getNewValue();
                    if (MozillaEditor.this.showSelectionBarAction.isChecked() != newValue) {
                        MozillaEditor.this.showSelectionBarAction.setChecked(newValue);
                    }
                }
            }
        };
        WebUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.selectionBarCloseListener);
        this.showSelectionBarAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)ICON_SELECTION_BAR));
        this.showSelectionBarAction.setToolTipText(VpeUIMessages.SHOW_SELECTION_BAR);
        toolBarManager.add((IAction)this.showSelectionBarAction);
        this.updateToolbarItemsAccordingToPreferences();
        toolBarManager.update(true);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolBarManager.dispose();
                toolBarManager.removeAll();
                MozillaEditor.this.openVPEPreferencesAction = null;
                MozillaEditor.this.visualRefreshAction = null;
                MozillaEditor.this.showResouceDialogAction = null;
                MozillaEditor.this.rotateEditorsAction = null;
                MozillaEditor.this.showBorderAction = null;
                MozillaEditor.this.showSelectionBarAction = null;
                MozillaEditor.this.showNonVisualTagsAction = null;
                MozillaEditor.this.showTextFormattingAction = null;
                MozillaEditor.this.showBundleAsELAction = null;
                MozillaEditor.this.externalizeStringsAction = null;
            }
        });
        return this.verBar;
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 2;
        layout.marginBottom = 0;
        parent.setLayout((Layout)layout);
        Composite cmpEdTl = new Composite(parent, 0);
        GridLayout layoutEdTl = new GridLayout(1, false);
        layoutEdTl.verticalSpacing = 0;
        layoutEdTl.marginHeight = 0;
        layoutEdTl.marginBottom = 3;
        layoutEdTl.marginWidth = 0;
        cmpEdTl.setLayout((Layout)layoutEdTl);
        cmpEdTl.setLayoutData((Object)new GridData(1808));
        if (this.verBar != null) {
            this.vpeToolBarManager = new VpeToolBarManager();
            if (this.vpeToolBarManager != null) {
                this.vpeToolBarManager.createToolBarComposite(cmpEdTl);
                this.vpeToolBarManager.addToolBar(new TextFormattingToolBar(this.formatControllerManager));
            }
        }
        Composite cmpEd = new Composite(cmpEdTl, 8);
        GridLayout layoutEd = new GridLayout(1, false);
        layoutEd.marginBottom = 0;
        layoutEd.marginHeight = 1;
        layoutEd.marginWidth = 0;
        layoutEd.marginRight = 0;
        layoutEd.marginLeft = 1;
        layoutEd.verticalSpacing = 0;
        layoutEd.horizontalSpacing = 0;
        cmpEd.setLayout((Layout)layoutEd);
        cmpEd.setLayoutData((Object)new GridData(1808));
        Color buttonDarker = parent.getDisplay().getSystemColor(18);
        cmpEd.setBackground(buttonDarker);
        try {
            this.xulRunnerEditor = new XulRunnerEditor2(cmpEd, this);
            this.xulRunnerEditor.getBrowser().addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                }

                public void completed(ProgressEvent event) {
                    if (MozillaEditor.this.getXulRunnerEditor().getWebBrowser() != null) {
                        MozillaEditor.this.onLoadWindow();
                        MozillaEditor.this.xulRunnerEditor.getBrowser().removeProgressListener((ProgressListener)this);
                    }
                }
            });
            this.setInitialContent();
            this.xulRunnerEditor.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        catch (Throwable t) {
            if (this.verBar != null) {
                this.verBar.setEnabled(false);
            }
            this.errorWrapper.showError(cmpEd, t);
        }
    }

    protected void setInitialContent() {
        String html = DocTypeUtil.prepareInitFile(INIT_FILE, this.getEditorInput());
        File tmp = null;
        Writer out = null;
        try {
            try {
                tmp = File.createTempFile("temp", ".html");
                tmp.deleteOnExit();
                out = new FileWriter(tmp);
                out.write(html);
            }
            catch (IOException e) {
                VpePlugin.getPluginLog().logError((Throwable)e);
                try {
                    try {
                        if (out != null) {
                            out.close();
                            if (tmp != null) {
                                this.xulRunnerEditor.setURL("file://" + tmp.getCanonicalPath());
                            }
                        }
                    }
                    catch (IOException e2) {
                        VpePlugin.getPluginLog().logError((Throwable)e2);
                        if (tmp != null) {
                            tmp.delete();
                        }
                    }
                }
                finally {
                    if (tmp != null) {
                        tmp.delete();
                    }
                }
            }
        }
        finally {
            block29: {
                try {
                    try {
                        if (out != null) {
                            out.close();
                            if (tmp != null) {
                                this.xulRunnerEditor.setURL("file://" + tmp.getCanonicalPath());
                            }
                        }
                    }
                    catch (IOException e) {
                        VpePlugin.getPluginLog().logError((Throwable)e);
                        if (tmp != null) {
                            tmp.delete();
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (tmp != null) {
                        tmp.delete();
                    }
                    throw throwable;
                }
                if (tmp != null) {
                    tmp.delete();
                }
            }
        }
    }

    public void setFocus() {
        if (this.xulRunnerEditor != null) {
            this.xulRunnerEditor.setFocus();
        }
    }

    public void dispose() {
        if (this.selectionBarCloseListener != null) {
            WebUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.selectionBarCloseListener);
        }
        if (this.vpeToolBarManager != null) {
            this.vpeToolBarManager.dispose();
            this.vpeToolBarManager = null;
        }
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
        if (this.getController() != null) {
            this.controller.dispose();
            this.controller = null;
        }
        if (this.xulRunnerEditor != null) {
            this.xulRunnerEditor.dispose();
            this.xulRunnerEditor = null;
        }
        this.formatControllerManager.setVpeController(null);
        this.formatControllerManager = null;
        this.headNode = null;
        this.contentArea = null;
        super.dispose();
    }

    public void setEditorLoadWindowListener(EditorLoadWindowListener listener) {
        this.editorLoadWindowListener = listener;
    }

    public nsIDOMDocument getDomDocument() {
        return this.xulRunnerEditor.getDOMDocument();
    }

    public nsIDOMElement getContentArea() {
        return this.contentArea;
    }

    protected void setContentArea(nsIDOMElement element) {
        this.contentArea = element;
    }

    public nsIDOMNode getHeadNode() {
        return this.headNode;
    }

    public Menu getMenu() {
        return this.xulRunnerEditor.getBrowser().getMenu();
    }

    public Control getControl() {
        return this.xulRunnerEditor.getBrowser();
    }

    protected nsIDOMElement findContentArea() {
        nsIDOMElement area = null;
        nsIDOMNodeList nodeList = this.xulRunnerEditor.getDOMDocument().getElementsByTagName("body");
        long length = nodeList.getLength();
        long i = 0L;
        while (i < length) {
            nsIDOMNode node = nodeList.item(i);
            if (this.isContentArea(node)) {
                if (node.getNodeType() != 1) {
                    throw new RuntimeException("The content area node should by element node.");
                }
                area = (nsIDOMElement)XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class);
                break;
            }
            ++i;
        }
        if (area == null) {
            area = this.xulRunnerEditor.getDOMDocument().createElement("body");
            this.xulRunnerEditor.getDOMDocument().getDocumentElement().appendChild((nsIDOMNode)area);
        }
        nsIDOMElement root = this.xulRunnerEditor.getDOMDocument().getDocumentElement();
        this.headNode = this.findHeadNode((nsIDOMNode)root);
        return area;
    }

    private nsIDOMNode findHeadNode(nsIDOMNode root) {
        nsIDOMNode headNode = this.findChildNode(root, "head");
        return headNode;
    }

    private nsIDOMNode findChildNode(nsIDOMNode parent, String name) {
        nsIDOMNodeList list = parent.getChildNodes();
        int i = 0;
        while ((long)i < list.getLength()) {
            nsIDOMNode node = list.item((long)i);
            if (node.getNodeName().equalsIgnoreCase(name)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private boolean isContentArea(nsIDOMNode node) {
        nsIDOMNamedNodeMap map;
        boolean ret = false;
        if ("body".equalsIgnoreCase(node.getNodeName()) && (map = node.getAttributes()) != null) {
            long length = map.getLength();
            int i = 0;
            while ((long)i < length) {
                nsIDOMNode attr = map.item((long)i);
                boolean bl = ret = attr.getNodeType() == 2 && "id".equalsIgnoreCase(attr.getNodeName()) && CONTENT_AREA_ID.equalsIgnoreCase(attr.getNodeValue());
                if (ret) break;
                ++i;
            }
        }
        return ret;
    }

    private void onLoadWindow() {
        this.contentArea = this.findContentArea();
        this.attachMozillaEventAdapter();
        if (this.editorLoadWindowListener != null) {
            this.editorLoadWindowListener.load();
        }
    }

    protected MozillaEventAdapter createMozillaEventAdapter() {
        return new MozillaEventAdapter();
    }

    protected void attachMozillaEventAdapter() {
        if (this.contentArea != null) {
            nsIDOMWindow window = this.xulRunnerEditor.getWebBrowser().getContentDOMWindow();
            this.mozillaEventAdapter.attach(window, (nsIDOMEventTarget)XPCOM.queryInterface((nsISupports)this.contentArea, nsIDOMEventTarget.class));
        }
    }

    void detachMozillaEventAdapter() {
        this.mozillaEventAdapter.detach();
    }

    public void setSelectionRectangle(List<nsIDOMNode> nodes, int resizerConstrains) {
        this.xulRunnerEditor.setSelectionRectangle(nodes, resizerConstrains);
    }

    public void showResizer() {
        this.xulRunnerEditor.showResizer();
    }

    public void hideResizer() {
        this.xulRunnerEditor.hideResizer();
    }

    public XulRunnerEditor getXulRunnerEditor() {
        return this.xulRunnerEditor;
    }

    protected void setXulRunnerEditor(XulRunnerEditor xulRunnerEditor) {
        this.xulRunnerEditor = xulRunnerEditor;
    }

    public VpeController getController() {
        return this.controller;
    }

    public MozillaEventAdapter getMozillaEventAdapter() {
        return this.mozillaEventAdapter;
    }

    public void onReloadWindow() {
        this.detachMozillaEventAdapter();
        this.xulRunnerEditor.removeResizeListener();
        this.contentArea = this.findContentArea();
        this.attachMozillaEventAdapter();
        this.xulRunnerEditor.addResizeListener();
        this.controller.reinit();
    }

    public void reload() {
        this.doctype = DocTypeUtil.getDoctype(this.getEditorInput());
        this.setRefreshPage(true);
        this.setInitialContent();
    }

    public void initDesingMode() {
        this.tearDownEditor();
        this.getEditor();
    }

    public String getDoctype() {
        return this.doctype;
    }

    public boolean isRefreshPage() {
        return this.isRefreshPage;
    }

    public void setRefreshPage(boolean isRefreshPage) {
        this.isRefreshPage = isRefreshPage;
    }

    public void reinitDesignMode() {
        this.tearDownEditor();
        this.getEditor();
    }

    public void tearDownEditor() {
        if (this.editor != null) {
            nsIEditingSession iEditingSession = (nsIEditingSession)this.getXulRunnerEditor().getComponentManager().createInstanceByContractID("@mozilla.org/editor/editingsession;1", null, "{274cd32e-3675-47e1-9d8a-fc6504ded9ce}");
            nsIDOMWindow window = this.getXulRunnerEditor().getWebBrowser().getContentDOMWindow();
            iEditingSession.detachFromWindow(window);
            iEditingSession.tearDownEditorOnWindow(window);
            this.editor = null;
        }
    }

    public nsIEditor getEditor() {
        if (this.editor == null) {
            nsIEditingSession iEditingSession = (nsIEditingSession)this.getXulRunnerEditor().getComponentManager().createInstanceByContractID("@mozilla.org/editor/editingsession;1", null, "{274cd32e-3675-47e1-9d8a-fc6504ded9ce}");
            iEditingSession.makeWindowEditable(this.getXulRunnerEditor().getWebBrowser().getContentDOMWindow(), "html", true, true, true);
            iEditingSession.setupEditorOnWindow(this.getXulRunnerEditor().getWebBrowser().getContentDOMWindow());
            this.editor = iEditingSession.getEditorForWindow(this.getXulRunnerEditor().getWebBrowser().getContentDOMWindow());
            this.editor.setFlags(8L);
            nsIHTMLObjectResizer htmlObjectResizer = (nsIHTMLObjectResizer)XPCOM.queryInterface((nsISupports)this.editor, nsIHTMLObjectResizer.class);
            htmlObjectResizer.hideResizers();
            htmlObjectResizer.setObjectResizingEnabled(false);
            nsIHTMLAbsPosEditor htmlAbsPosEditor = (nsIHTMLAbsPosEditor)XPCOM.queryInterface((nsISupports)this.editor, nsIHTMLAbsPosEditor.class);
            htmlAbsPosEditor.setAbsolutePositioningEnabled(false);
            nsIHTMLInlineTableEditor inlineTableEditor = (nsIHTMLInlineTableEditor)XPCOM.queryInterface((nsISupports)this.editor, nsIHTMLInlineTableEditor.class);
            inlineTableEditor.setInlineTableEditingEnabled(false);
        }
        return this.editor;
    }

    public VpeDropDownMenu getDropDownMenu() {
        return this.dropDownMenu;
    }

    public void updateExternalizeStringsToolbarIconState(ISelection selection) {
        if (ExternalizeStringsUtils.isExternalizeStringsCommandEnabled((ISelection)selection)) {
            this.externalizeStringsAction.setEnabled(true);
        } else {
            this.externalizeStringsAction.setEnabled(false);
        }
    }

    public void updateToolbarItemsAccordingToPreferences() {
        String prefsOrientation = WebUiPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting");
        int prefsOrientationIndex = layoutValues.indexOf(prefsOrientation);
        boolean prefsShowBorderForUnknownTags = WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show Border for Unknown Tags");
        boolean prefsShowNonVisualTags = WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show non-visual tags");
        boolean prefsShowTextFormatting = WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show Text Formatting bar");
        boolean prefsShowSelectionBar = WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show Selection Tag Bar");
        boolean prefsShowBundlesAsEL = WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show Resource Bundles Usage as EL Expressions");
        boolean scrollLockEditors = WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Synchronize scrolling between source and visual panes");
        if (this.showBorderAction != null) {
            this.showBorderAction.setChecked(prefsShowBorderForUnknownTags);
        }
        if (this.showNonVisualTagsAction != null) {
            this.showNonVisualTagsAction.setChecked(prefsShowNonVisualTags);
        }
        if (this.showSelectionBarAction != null) {
            this.showSelectionBarAction.setChecked(prefsShowSelectionBar);
        }
        if (this.showTextFormattingAction != null) {
            this.showTextFormattingAction.setChecked(prefsShowTextFormatting);
            if (this.vpeToolBarManager != null) {
                this.vpeToolBarManager.setToolbarVisibility(prefsShowTextFormatting);
            }
        }
        if (this.showBundleAsELAction != null) {
            this.showBundleAsELAction.setChecked(prefsShowBundlesAsEL);
        }
        if (this.scrollLockAction != null) {
            this.scrollLockAction.setChecked(scrollLockEditors);
        }
        if (this.rotateEditorsAction != null) {
            this.currentOrientationIndex = prefsOrientationIndex;
            this.rotateEditorsAction.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)layoutIcons.get(prefsOrientation)));
            this.rotateEditorsAction.setToolTipText(layoutNames.get(prefsOrientation));
        }
    }

    public void setResizeListener(MozillaResizeListener resizeListener) {
        this.resizeListener = resizeListener;
    }

    public void setTooltipListener(MozillaTooltipListener tooltipListener) {
        this.tooltipListener = tooltipListener;
    }

    public MozillaResizeListener getResizeListener() {
        return this.resizeListener;
    }

    public MozillaTooltipListener getTooltipListener() {
        return this.tooltipListener;
    }

    public IVpeToolBarManager getVpeToolBarManager() {
        return this.vpeToolBarManager;
    }
}

