/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.scrolling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.scrolling.IScrollCoordinator;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.jboss.tools.vpe.xulrunner.util.XulRunnerVpeUtils;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIDOMWindowInternal;
import org.mozilla.interfaces.nsIDOMWindowUtils;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Node;

public class ScrollCoordinator
implements IScrollCoordinator {
    StructuredTextEditor sourceEditor = null;
    MozillaEditor visualEditor = null;
    VpeDomMapping domMapping = null;
    private List<Integer> resultPositions = new ArrayList<Integer>();
    private List<Integer> removeList = new ArrayList<Integer>();
    private List<Point> visualPoints = new ArrayList<Point>();

    public ScrollCoordinator(StructuredTextEditor sourceEditor, MozillaEditor visualEditor, VpeDomMapping domMapping) {
        this.sourceEditor = sourceEditor;
        this.visualEditor = visualEditor;
        this.domMapping = domMapping;
    }

    @Override
    public int computeVisualPositionFromSource() {
        StructuredTextViewer textViewer;
        int posY = -1;
        if (this.sourceEditor != null && (textViewer = this.sourceEditor.getTextViewer()) != null) {
            int topLine = textViewer.getTopIndex();
            int i = 0;
            while (i < 9) {
                nsIDOMElement visualElement;
                Node sourceNode = SourceDomUtil.getSourceNodeByEditorPosition((ITextViewer)textViewer, topLine + i, 1);
                if (sourceNode != null && (visualElement = this.domMapping.getNearVisualElement(sourceNode)) != null) {
                    Point r = XulRunnerVpeUtils.getVisualNodeOffset((nsIDOMNode)visualElement);
                    this.resultPositions.add(r.y);
                }
                ++i;
            }
            posY = this.findBetterPosition(this.resultPositions);
        }
        return posY;
    }

    @Override
    public int computeSourcePositionFromVisual() {
        int line = -1;
        if (this.sourceEditor != null && this.visualEditor != null && this.visualEditor.getXulRunnerEditor() != null) {
            nsIDOMWindow domWindow = this.visualEditor.getXulRunnerEditor().getWebBrowser().getContentDOMWindow();
            nsIInterfaceRequestor iInterfaceRequestor = (nsIInterfaceRequestor)domWindow.queryInterface("{033a1470-8b2a-11d3-af88-00a024ffc08c}");
            nsIDOMWindowInternal windowInternal = (nsIDOMWindowInternal)XPCOM.queryInterface((nsISupports)domWindow, nsIDOMWindowInternal.class);
            nsIDOMWindowUtils windowUtils = (nsIDOMWindowUtils)iInterfaceRequestor.getInterface("{6a60fde5-a00a-4732-bbea-2787c174c04f}");
            int xLines = 6;
            int yLines = 5;
            int i = 1;
            while (i < xLines) {
                int j = 1;
                while (j < yLines) {
                    this.visualPoints.add(new Point(windowInternal.getInnerWidth() * i / xLines, windowInternal.getInnerHeight() * j / yLines));
                    ++j;
                }
                ++i;
            }
            for (Point p : this.visualPoints) {
                ElementImpl sourceElement;
                nsIDOMElement elementFromPoint = windowUtils.elementFromPoint(p.x, p.y, true, false);
                if (elementFromPoint == null || (sourceElement = this.domMapping.getNearSourceElementImpl((nsIDOMNode)elementFromPoint)) == null) continue;
                this.resultPositions.add(this.sourceEditor.getTextViewer().getTextWidget().getLineAtOffset(sourceElement.getStartEndOffset()));
            }
            line = this.findBetterPosition(this.resultPositions);
        }
        return line;
    }

    private int findBetterPosition(List<Integer> list) {
        int pos = this.getBetterPositionFromList(list);
        this.visualPoints.clear();
        this.resultPositions.clear();
        this.removeList.clear();
        return pos;
    }

    private int getBetterPositionFromList(List<Integer> list) {
        int pos = -1;
        if (list.size() > 1) {
            Collections.sort(list);
            this.removeList.add(list.get(0));
            this.removeList.add(list.get(list.size() - 1));
            list.removeAll(this.removeList);
            if (list.size() == 1) {
                pos = list.get(0);
            } else if (list.size() > 1) {
                int sum = 0;
                for (Integer position : list) {
                    sum += position.intValue();
                }
                pos = sum / list.size();
            } else {
                pos = this.removeList.get(1);
            }
        }
        return pos;
    }
}

