/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format.handler;

import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.JSPPaletteInsertHelper;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.template.textformating.FormatData;
import org.jboss.tools.vpe.editor.template.textformating.TextFormatingData;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.toolbar.format.IFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.handler.IAddNodeHandler;
import org.jboss.tools.vpe.editor.toolbar.format.handler.IFormatHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class FormatHandler
implements IFormatHandler {
    protected FormatControllerManager manager;
    protected FormatData formatData;
    protected IFormatController controller;

    public FormatHandler() {
    }

    public FormatHandler(FormatControllerManager manager) {
        this();
        this.manager = manager;
    }

    void setManager(FormatControllerManager manager) {
        this.manager = manager;
    }

    @Override
    public void run(FormatData formatData) {
        this.formatData = formatData;
        this.run();
    }

    protected abstract void run();

    @Override
    public void setFormatController(IFormatController controller) {
        this.controller = controller;
    }

    protected void insertNewElementAroundNode(String elementName, Node node, StructuredTextViewer viewer, boolean format) {
        IDocument document = viewer.getDocument();
        IndexedRegion region = (IndexedRegion)node;
        int startOffcet = region.getStartOffset();
        int length = region.getEndOffset() - startOffcet;
        String nodeSource = this.getNodeSource(node);
        if (!(node instanceof Element)) {
            String trimValue;
            String value;
            TextSelection sel = (TextSelection)viewer.getSelectionProvider().getSelection();
            if (sel.getLength() > 0) {
                value = node.getNodeValue();
                trimValue = value.trim();
                if (trimValue.equals(sel.getText())) {
                    startOffcet += value.indexOf(trimValue);
                    length = trimValue.length();
                } else {
                    startOffcet = sel.getOffset();
                    length = sel.getLength();
                }
            } else {
                value = node.getNodeValue();
                trimValue = value.trim();
                startOffcet += value.indexOf(trimValue);
                length = trimValue.length();
            }
            nodeSource = nodeSource.trim();
        }
        Properties p = new Properties();
        p.setProperty("tag name", elementName);
        p.setProperty("start text", "<" + elementName + ">");
        p.setProperty("end text", "</" + elementName + ">");
        if (format) {
            p.setProperty("automatically reformat tag body", "yes");
        }
        p.setProperty("library uri", "http://www.w3.org/TR/REC-html40");
        p.setProperty("default prefix", "");
        TextSelection sel = new TextSelection(startOffcet, length);
        ISelectionProvider selProvider = viewer.getSelectionProvider();
        selProvider.setSelection((ISelection)sel);
        p.put("selectionProvider", selProvider);
        JSPPaletteInsertHelper.getInstance().insertIntoEditor((ISourceViewer)viewer, p);
        String documentText = document.get();
        int newStartOffset = documentText.substring(startOffcet).indexOf(nodeSource);
        if (newStartOffset > -1) {
            newStartOffset = startOffcet + newStartOffset;
            viewer.setSelectedRange(newStartOffset, 0);
            viewer.revealRange(newStartOffset, 0);
        }
    }

    protected String getNodeBody(Node node) {
        StringBuilder buffer = new StringBuilder();
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            if (child instanceof ElementImpl) {
                ElementImpl element = (ElementImpl)child;
                buffer.append(element.getSource());
            } else {
                buffer.append(child.getNodeValue());
            }
            ++i;
        }
        return buffer.toString();
    }

    protected String getNodeSource(Node node) {
        if (node instanceof ElementImpl) {
            return ((ElementImpl)node).getSource();
        }
        return node.getNodeValue();
    }

    protected String stripElement(ElementImpl element, Node selectedNode, StructuredTextViewer viewer) {
        IDocument document = viewer.getDocument();
        String body = this.getNodeBody((Node)element);
        int length = element.getEndOffset() - element.getStartOffset();
        String selectedSource = this.getNodeSource(selectedNode);
        int newStartOffset = element.getStartOffset();
        if (element != selectedNode) {
            newStartOffset += body.indexOf(selectedSource);
        }
        if (body.startsWith("\r\n") || body.startsWith("\n")) {
            body = body.trim();
        }
        try {
            document.replace(element.getStartOffset(), length, body);
        }
        catch (BadLocationException e) {
            VpePlugin.getPluginLog().logError("Can't format text", (Throwable)e);
        }
        viewer.setSelectedRange(newStartOffset, 0);
        viewer.revealRange(newStartOffset, 0);
        return body;
    }

    protected String replaseElementName(ElementImpl element, String newName, StructuredTextViewer viewer, Node selectedNode) {
        String endtagName;
        IDocument document = viewer.getDocument();
        StringBuilder resultNode = new StringBuilder("<").append(newName);
        int endOffcet = element.getEndOffset() - element.getStartOffset();
        int startEndOffcet = element.getStartEndOffset() - element.getStartOffset();
        int endStartOffcet = element.getEndStartOffset() - element.getStartOffset();
        int length = endOffcet;
        String source = element.getSource();
        String name = element.getNodeName();
        int indexOfStartAttributes = name.length() + 1;
        resultNode.append(source.substring(indexOfStartAttributes, endStartOffcet));
        if (endOffcet != startEndOffcet && (endtagName = element.getEndTagName()) != null) {
            resultNode.append("</").append(newName);
            resultNode.append(source.substring(endStartOffcet + 2 + endtagName.length()));
        }
        String newElement = resultNode.toString();
        int newStartOffset = element.getStartOffset();
        if (element != selectedNode) {
            newStartOffset += newElement.indexOf(this.getNodeSource(selectedNode));
        }
        try {
            document.replace(element.getStartOffset(), length, newElement);
        }
        catch (BadLocationException e) {
            VpePlugin.getPluginLog().logError("Can't format text", (Throwable)e);
        }
        viewer.setSelectedRange(newStartOffset, 0);
        viewer.revealRange(newStartOffset, 0);
        return newElement;
    }

    @Override
    public boolean formatIsAllowable() {
        TextFormatingData data = this.manager.getFormatTemplateForSelectedNode();
        if (data != null) {
            Node parentNode;
            int i;
            Node node = this.manager.getCurrentSelectedNodeInfo().getNode();
            TextFormatingData formatingData = this.manager.getFormatTemplateForTag(node);
            if (formatingData != null) {
                FormatData[] formatDatas = formatingData.getFormatDatas(this.controller.getType());
                FormatData formatData = null;
                i = 0;
                while (i < formatDatas.length) {
                    if (this.getClass().getName().equals(formatDatas[i].getHandler())) {
                        formatData = formatDatas[i];
                        break;
                    }
                    ++i;
                }
                if (formatData != null) {
                    if (formatData.isAddingParentAllow()) {
                        return true;
                    }
                    if (formatData.isAddingParentDeny()) {
                        return false;
                    }
                }
            }
            if ((parentNode = this.getParentNodeWhichDenyAddChild(node)) != null) {
                FormatData[] formatDatas = this.manager.getFormatTemplateForTag(parentNode).getFormatDatas(this.controller.getType());
                i = 0;
                while (i < formatDatas.length) {
                    IAddNodeHandler handler;
                    FormatData formatData = formatDatas[i];
                    if (formatData.isAddingChildrenByItself() && (handler = this.manager.getHandlerFactory().createAddNodeHandler(formatData)) != null) {
                        return true;
                    }
                    ++i;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected Node getParentNodeWhichDenyAddChild(Node childNode) {
        Node parentNode = childNode.getParentNode();
        if (parentNode == null) {
            return null;
        }
        TextFormatingData data = this.manager.getFormatTemplateForTag(parentNode);
        boolean returnParent = false;
        if (data != null) {
            FormatData[] formatDatas = data.getFormatDatas(this.controller.getType());
            int i = 0;
            while (i < formatDatas.length) {
                FormatData formatData = formatDatas[i];
                if (formatData.isAddingChildrenAllow() || formatData.isAddingParentAllow()) {
                    return null;
                }
                if (formatData.isAddingChildrenByItself() || formatData.isAddingChildrenDeny() || formatData.isAddingParentByItself() || formatData.isAddingParentDeny()) {
                    returnParent = true;
                }
                ++i;
            }
        }
        if (returnParent) {
            return parentNode;
        }
        return this.getParentNodeWhichDenyAddChild(parentNode);
    }
}

