/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import org.jboss.tools.vpe.editor.util.TextUtil;
import org.w3c.dom.Node;

public class FlatIterator {
    public static Node previous(Node forNode) {
        if (forNode == null || forNode.getNodeType() == 9) {
            return null;
        }
        Node parent = forNode;
        while (parent != null) {
            if (parent.getNodeType() == 9) {
                return null;
            }
            Node sibling = FlatIterator.getPreviousSibling(parent);
            if (sibling != null) {
                Node deepestChild = FlatIterator.findDeepestLastChild(sibling);
                return deepestChild != null ? deepestChild : sibling;
            }
            parent = forNode.getParentNode();
            if (FlatIterator.valid(parent)) break;
        }
        return parent;
    }

    public static Node next(Node forNode) {
        if (forNode == null) {
            return null;
        }
        Node child = FlatIterator.getFirstChild(forNode);
        if (child != null) {
            return child;
        }
        Node parent = forNode;
        while (parent != null) {
            Node sibling = FlatIterator.getNextSibling(parent);
            if (sibling != null) {
                return sibling;
            }
            if (parent.getNodeType() == 9) break;
            parent = parent.getParentNode();
        }
        return null;
    }

    public static Node findDeepestLastChild(Node node) {
        Node child = null;
        Node deeper = FlatIterator.getLastChild(node);
        while (deeper != null) {
            child = deeper;
            deeper = FlatIterator.getLastChild(child);
        }
        return child;
    }

    private static Node getPreviousSibling(Node forNode) {
        if (forNode == null) {
            return null;
        }
        Node sibling = null;
        sibling = forNode.getPreviousSibling();
        while (sibling != null && !FlatIterator.valid(sibling)) {
            sibling = sibling.getPreviousSibling();
        }
        return sibling;
    }

    private static Node getNextSibling(Node forNode) {
        if (forNode == null) {
            return null;
        }
        Node sibling = null;
        sibling = forNode.getNextSibling();
        while (sibling != null && !FlatIterator.valid(sibling)) {
            sibling = sibling.getNextSibling();
        }
        return sibling;
    }

    private static Node getFirstChild(Node forNode) {
        if (forNode == null) {
            return null;
        }
        Node child = null;
        child = forNode.getFirstChild();
        while (child != null && !FlatIterator.valid(child)) {
            child = child.getNextSibling();
        }
        return child;
    }

    private static Node getLastChild(Node forNode) {
        if (forNode == null || !forNode.hasChildNodes()) {
            return null;
        }
        Node lastChild = forNode.getLastChild();
        if (!FlatIterator.valid(lastChild)) {
            lastChild = FlatIterator.getPreviousSibling(lastChild);
        }
        return lastChild;
    }

    private boolean isEmptyElement(Node node) {
        if (!node.hasChildNodes()) {
            return true;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3 && !TextUtil.isWhitespaceText(child.getNodeValue())) {
                return false;
            }
            if (child.getNodeType() == 1 && !this.isEmptyElement(child)) {
                return false;
            }
            child = child.getNextSibling();
        }
        return true;
    }

    private static boolean valid(Node testNode) {
        if (testNode == null) {
            return false;
        }
        if (testNode.getNodeType() == 3) {
            return !TextUtil.isWhitespaceText(testNode.getNodeValue());
        }
        return testNode.getNodeType() == 1;
    }
}

