/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.util.XmlUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JstlCoreUrlUtil {
    private static final String JSTL_CORE_TAGLIB = "http://java.sun.com/jsp/jstl/core";
    private static final String JSTL_CORE_URL_PRE_CHECK_STRING = ":url";

    public static boolean isContainigJstlCoreUrlInAttributes(VpePageContext pageContext, Node sourceNode) {
        NamedNodeMap attributes = sourceNode.getAttributes();
        if (attributes != null) {
            int attributesLength = attributes.getLength();
            int i = 0;
            while (i < attributesLength) {
                Pattern jstlCoreUrlPattern;
                Node attribute = attributes.item(i);
                String value = attribute.getNodeValue();
                if (value != null && value.contains(JSTL_CORE_URL_PRE_CHECK_STRING) && (jstlCoreUrlPattern = JstlCoreUrlUtil.createJstlCoreUrlPattern(pageContext, sourceNode)) != null && jstlCoreUrlPattern.matcher(value).find()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String processJstlCoreUrlIfNeeded(VpePageContext pageContext, Node contextNode, String value) {
        Pattern jstlCoreUrlPattern;
        if (contextNode != null && value.contains(JSTL_CORE_URL_PRE_CHECK_STRING) && (jstlCoreUrlPattern = JstlCoreUrlUtil.createJstlCoreUrlPattern(pageContext, contextNode)) != null) {
            return jstlCoreUrlPattern.matcher(value).replaceAll("$2");
        }
        return value;
    }

    private static Pattern createJstlCoreUrlPattern(VpePageContext pageContext, Node contextNode) {
        String jstlCorePrefix;
        if (contextNode == null) {
            return null;
        }
        Pattern jstlCoreUrlPattern = null;
        List<TaglibData> taglibs = XmlUtil.getTaglibsForNode(contextNode, pageContext);
        TaglibData jstlCoreTaglib = XmlUtil.getTaglibForURI(JSTL_CORE_TAGLIB, taglibs);
        if (jstlCoreTaglib != null && (jstlCorePrefix = jstlCoreTaglib.getPrefix()) != null) {
            try {
                jstlCoreUrlPattern = Pattern.compile("<" + jstlCorePrefix + ":url\\s[^>]*?value\\s*?=\\s*?([\"'])(.*?)(\\1).*?(/>|</" + jstlCorePrefix + ":url\\s*>)");
            }
            catch (PatternSyntaxException e) {
                VpePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return jstlCoreUrlPattern;
    }
}

