/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.EditorValidationContext;
import org.jboss.tools.common.validation.IJavaElementValidator;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IStringValidator;
import org.jboss.tools.common.validation.ITypedReporter;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.IValidationContextManager;
import org.jboss.tools.common.validation.PreferenceInfoManager;
import org.jboss.tools.common.validation.TempMarkerManager;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.ws.jaxrs.core.JBossJaxrsCorePlugin;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.JavaElementsSearcher;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsProvider;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResource;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelLocator;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IJaxrsElementValidator;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsHttpMethodValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsJavaApplicationValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsMetamodelValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsNameBindingValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsParamConverterProviderValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsParameterAggregatorFieldValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsParameterAggregatorPropertyValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsParameterAggregatorValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsProviderValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourceFieldValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourceMethodValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourcePropertyValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourceValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsWebxmlApplicationValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.ValidatingProjectTreeLocator;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public class JaxrsMetamodelValidator
extends TempMarkerManager
implements org.jboss.tools.common.validation.IValidator,
IJavaElementValidator,
IStringValidator,
IMarkerManager {
    private static final String PREFERENCE_PAGE_ID = "org.jboss.tools.ws.jaxrs.ui.preferencePages.JaxrsValidatorPreferencePage";
    private static final String PROPERTY_PAGE_ID = "org.jboss.tools.ws.jaxrs.ui.propertyPages.JaxrsValidatorPreferencePage";
    public static final String ID = "org.jboss.tools.ws.jaxrs.JaxrsMetamodelValidator";
    private static final String BUNDLE_NAME = String.valueOf(JaxrsMetamodelValidator.class.getPackage().getName()) + ".messages";
    public static final String JAXRS_PROBLEM_TYPE = "problemType";
    private static final int NO_QUICKFIX = -1;

    public JaxrsMetamodelValidator() {
        super.setProblemType("org.jboss.tools.ws.jaxrs.metamodelMarker");
    }

    public boolean isEnabled(IProject project) {
        return JaxrsPreferences.isValidationEnabled(project);
    }

    public boolean shouldValidate(IProject project) {
        try {
            return project.isAccessible() && project.hasNature("org.jboss.tools.ws.jaxrs.nature") && this.isEnabled(project);
        }
        catch (CoreException e) {
            Logger.error("Failed to check if JAX-RS validation is required for project '" + project.getName() + "'", e);
            Logger.debug("*** Skipping JAX-RS validation for project {}", project.getName());
            return false;
        }
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        block10: {
            long startTime = System.currentTimeMillis();
            this.init(project, validationHelper, context, (IValidator)manager, reporter, false);
            IResource dotProject = project.findMember(".project");
            IResource facetSettings = project.findMember(new Path(".settings").append("org.eclipse.wst.common.project.facet.core.xml"));
            if (changedFiles.size() == 1 && (changedFiles.contains(dotProject) || changedFiles.contains(facetSettings))) {
                this.validateAll(project, validationHelper, context, manager, reporter);
            } else if (!changedFiles.isEmpty()) {
                try {
                    try {
                        Logger.debug("*** Validating project {} after files {} changed... ***", project.getName(), changedFiles.toString());
                        this.displaySubtask(JaxrsValidationMessages.VALIDATING_RESOURCE, new String[]{project.getName()});
                        JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IProject)project);
                        if (metamodel != null) {
                            List<IResource> allResources = this.completeValidationSet(metamodel, changedFiles.toArray(new IFile[changedFiles.size()]));
                            ArrayList elementsToValidate = new ArrayList();
                            boolean includeMetamodel = allResources.contains(project);
                            for (IResource changedResource : allResources) {
                                elementsToValidate.addAll(metamodel.findElements(changedResource));
                            }
                            this.validate(elementsToValidate, metamodel, includeMetamodel);
                        }
                    }
                    catch (CoreException e) {
                        Logger.error("Failed to validate changed files " + changedFiles + " in project " + project, e);
                        long endTime = System.currentTimeMillis();
                        Logger.debug("Validation of {} files done in {} ms.", changedFiles.size(), endTime - startTime);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    long endTime = System.currentTimeMillis();
                    Logger.debug("Validation of {} files done in {} ms.", changedFiles.size(), endTime - startTime);
                    throw throwable;
                }
                long endTime = System.currentTimeMillis();
                Logger.debug("Validation of {} files done in {} ms.", changedFiles.size(), endTime - startTime);
            }
        }
        return Status.OK_STATUS;
    }

    private List<IResource> completeValidationSet(JaxrsMetamodel metamodel, IFile ... changedResources) throws CoreException {
        IProject project = metamodel.getProject();
        HashSet<Object> resources = new HashSet<Object>();
        resources.addAll(Arrays.asList(changedResources));
        Set<EnumElementKind> elementKindChanges = this.analyzeChangeResources(metamodel, changedResources);
        boolean applicationsChanged = elementKindChanges.contains(EnumElementKind.APPLICATION_JAVA) || elementKindChanges.contains(EnumElementKind.APPLICATION_WEBXML);
        boolean resourcesChanged = elementKindChanges.contains(EnumElementKind.ROOT_RESOURCE) || elementKindChanges.contains(EnumElementKind.SUBRESOURCE) || elementKindChanges.contains(EnumElementKind.SUBRESOURCE_LOCATOR) || elementKindChanges.contains(EnumElementKind.UNDEFINED_RESOURCE);
        boolean filtersChanged = elementKindChanges.contains(EnumElementKind.CONTAINER_FILTER) || elementKindChanges.contains(EnumElementKind.CONTAINER_REQUEST_FILTER) || elementKindChanges.contains(EnumElementKind.CONTAINER_RESPONSE_FILTER) || elementKindChanges.contains(EnumElementKind.UNDEFINED_PROVIDER);
        boolean interceptorsChanged = elementKindChanges.contains(EnumElementKind.ENTITY_INTERCEPTOR) || elementKindChanges.contains(EnumElementKind.ENTITY_READER_INTERCEPTOR) || elementKindChanges.contains(EnumElementKind.ENTITY_WRITER_INTERCEPTOR);
        boolean nameBindingChanged = elementKindChanges.contains(EnumElementKind.NAME_BINDING);
        if (applicationsChanged) {
            resources.addAll(this.getApplicationUnderlyingResources(metamodel));
            resources.add(project);
        }
        if (applicationsChanged || resourcesChanged) {
            resources.addAll(this.getFiltersAndInterceptorsUnderlyingResources(metamodel));
        }
        if (filtersChanged || interceptorsChanged) {
            resources.addAll(this.getApplicationUnderlyingResources(metamodel));
            resources.addAll(this.getResourceUnderlyingResources(metamodel));
        }
        if (nameBindingChanged) {
            resources.addAll(this.getApplicationUnderlyingResources(metamodel));
            resources.addAll(this.getFiltersAndInterceptorsUnderlyingResources(metamodel));
            resources.addAll(this.getResourceUnderlyingResources(metamodel));
        }
        List knownTypes = metamodel.getAllJavaElements(7);
        IFile[] iFileArray = changedResources;
        int n = changedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile changedResource = iFileArray[n2];
            ICompilationUnit changedCompilationUnit = JdtUtils.getCompilationUnit((IResource)changedResource);
            if (changedCompilationUnit != null) {
                Set foundRelatedTypes = JavaElementsSearcher.findRelatedTypes((IType)changedCompilationUnit.findPrimaryType(), (List)knownTypes, (IProgressMonitor)new NullProgressMonitor());
                for (IType relatedType : foundRelatedTypes) {
                    resources.add(relatedType.getResource());
                }
            }
            ++n2;
        }
        if (elementKindChanges.contains(EnumElementKind.PARAM_CONVERTER_PROVIDER)) {
            resources.addAll(this.getResourceUnderlyingResources(metamodel));
        }
        if (!elementKindChanges.isEmpty()) {
            resources.add(project);
        }
        ArrayList<IResource> result = new ArrayList<IResource>(resources);
        Collections.sort(result, new Comparator<IResource>(){

            @Override
            public int compare(IResource a, IResource b) {
                return a.getType() - b.getType();
            }
        });
        return result;
    }

    private Set<EnumElementKind> analyzeChangeResources(JaxrsMetamodel metamodel, IFile[] changedResources) {
        HashSet<EnumElementKind> elementKindChanges = new HashSet<EnumElementKind>();
        IFile[] iFileArray = changedResources;
        int n = changedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile changedResource = iFileArray[n2];
            Set previousElementKinds = metamodel.getShadowElementKinds((IResource)changedResource);
            IJaxrsElement currentElement = metamodel.findElement((IResource)changedResource);
            if (previousElementKinds != null) {
                elementKindChanges.addAll(previousElementKinds);
            }
            if (currentElement != null) {
                elementKindChanges.add(currentElement.getElementKind());
            }
            if (currentElement == null) {
                metamodel.removeShadowedElement(changedResource);
            } else {
                metamodel.addShadowedElement(currentElement);
            }
            ++n2;
        }
        return elementKindChanges;
    }

    private Set<IResource> getFiltersAndInterceptorsUnderlyingResources(JaxrsMetamodel metamodel) {
        HashSet<IResource> providerResources = new HashSet<IResource>();
        Set providers = metamodel.findAllProviders();
        for (IJaxrsProvider provider : providers) {
            switch (provider.getElementKind()) {
                case CONTAINER_REQUEST_FILTER: 
                case CONTAINER_RESPONSE_FILTER: 
                case CONTAINER_FILTER: 
                case ENTITY_READER_INTERCEPTOR: 
                case ENTITY_WRITER_INTERCEPTOR: 
                case ENTITY_INTERCEPTOR: {
                    providerResources.add(provider.getResource());
                    break;
                }
            }
        }
        return providerResources;
    }

    private Set<IResource> getApplicationUnderlyingResources(JaxrsMetamodel metamodel) {
        Logger.debug("Adding all JAX-RS Applications and project in the set of files to validate...");
        HashSet<IResource> applicationResources = new HashSet<IResource>();
        Set applications = metamodel.findAllApplications();
        for (IJaxrsApplication application : applications) {
            applicationResources.add(application.getResource());
        }
        return applicationResources;
    }

    private Set<IResource> getResourceUnderlyingResources(JaxrsMetamodel metamodel) {
        Logger.debug("Adding all JAX-RS Resources (and children) and project in the set of files to validate...");
        HashSet<IResource> resourceResources = new HashSet<IResource>();
        Set resources = metamodel.findAllResources();
        for (IJaxrsResource resource : resources) {
            resourceResources.add(resource.getResource());
        }
        return resourceResources;
    }

    private static CompilationUnit getAST(IJaxrsElement element) throws JavaModelException {
        IMember javaElement;
        if (element instanceof JaxrsJavaElement && (javaElement = ((JaxrsJavaElement)element).getJavaElement()) != null) {
            return JdtUtils.parse((ICompilationUnit)javaElement.getCompilationUnit(), (IProgressMonitor)new NullProgressMonitor());
        }
        return null;
    }

    public void validate(IValidator validatorManager, IProject rootProject, Collection<IRegion> dirtyRegions, IValidationContext helper, IReporter reporter, EditorValidationContext validationContext, IProjectValidationContext projectContext, IFile changedFile) {
        block9: {
            long startTime = System.currentTimeMillis();
            Logger.debug("*** Validating project {} after file {} changed... ***", changedFile.getProject().getName(), changedFile.getFullPath());
            try {
                try {
                    ContextValidationHelper validationHelper = new ContextValidationHelper();
                    validationHelper.setProject(rootProject);
                    validationHelper.setValidationContextManager((IValidationContextManager)validationContext);
                    this.init(rootProject, validationHelper, projectContext, validatorManager, reporter);
                    this.setAsYouTypeValidation(true);
                    if (reporter instanceof ITypedReporter) {
                        ((ITypedReporter)reporter).addTypeForFile(this.getProblemType());
                    }
                    this.document = validationContext.getDocument();
                    JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IProject)changedFile.getProject());
                    ICompilationUnit compilationUnit = JdtUtils.getCompilationUnit((IResource)changedFile);
                    if (metamodel != null && compilationUnit != null) {
                        CompilationUnit ast = JdtUtils.parse((ICompilationUnit)compilationUnit, (IProgressMonitor)new NullProgressMonitor());
                        HashSet<JaxrsJavaElement> changedWorkingCopies = new HashSet<JaxrsJavaElement>();
                        Set changedElements = metamodel.findElements((IResource)changedFile);
                        for (IJaxrsElement iJaxrsElement : changedElements) {
                            if (!(iJaxrsElement instanceof JaxrsJavaElement)) continue;
                            JaxrsJavaElement changedJavaElement = (JaxrsJavaElement)iJaxrsElement;
                            JaxrsJavaElement workingCopyElement = (JaxrsJavaElement)changedJavaElement.getWorkingCopy();
                            workingCopyElement.update((IJavaElement)changedJavaElement.getJavaElement(), ast);
                            changedWorkingCopies.add(workingCopyElement);
                        }
                        for (IJaxrsElement iJaxrsElement : changedWorkingCopies) {
                            Logger.debug("Removing message before validating {}", iJaxrsElement.getName());
                            reporter.removeAllMessages(validatorManager, (Object)iJaxrsElement.getResource());
                        }
                        this.validate(changedWorkingCopies, metamodel, false);
                    }
                }
                catch (CoreException e) {
                    Logger.error("Failed to validate changed file " + changedFile.getName() + " in project " + changedFile.getProject(), e);
                    long endTime = System.currentTimeMillis();
                    Logger.debug("As-you-type validation done in {} ms.", endTime - startTime);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                Logger.debug("As-you-type validation done in {} ms.", endTime - startTime);
                throw throwable;
            }
            long endTime = System.currentTimeMillis();
            Logger.debug("As-you-type validation done in {} ms.", endTime - startTime);
        }
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext validationContext, ValidatorManager manager, IReporter reporter) throws ValidationException {
        block6: {
            long startTime = System.currentTimeMillis();
            Logger.debug("*** Validating all files in project {} ***", project.getName());
            this.init(project, validationHelper, validationContext, (IValidator)manager, reporter, false);
            try {
                try {
                    JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IProject)project);
                    if (metamodel != null) {
                        this.displaySubtask(JaxrsValidationMessages.VALIDATING_PROJECT, new String[]{project.getName()});
                        List allElements = metamodel.getAllElements();
                        this.validate(allElements, metamodel, true);
                    }
                }
                catch (CoreException e) {
                    Logger.error("Failed to validate project '", e);
                    long endTime = System.currentTimeMillis();
                    Logger.debug("Full validation of project '{}' done in {} ms.", project.getName(), endTime - startTime);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                Logger.debug("Full validation of project '{}' done in {} ms.", project.getName(), endTime - startTime);
                throw throwable;
            }
            long endTime = System.currentTimeMillis();
            Logger.debug("Full validation of project '{}' done in {} ms.", project.getName(), endTime - startTime);
        }
        return Status.OK_STATUS;
    }

    private void validate(Collection<? extends IJaxrsElement> elements, JaxrsMetamodel metamodel, boolean validateMetamodel) throws CoreException {
        ArrayList<IJaxrsElement> elementsToValidate = new ArrayList<IJaxrsElement>();
        int previousMetamodelProblemSeverity = metamodel.getProblemSeverity();
        List endpoints = metamodel.getAllEndpoints();
        HashMap<String, Integer> endpointProblemSeverities = new HashMap<String, Integer>();
        for (IJaxrsEndpoint iJaxrsEndpoint : endpoints) {
            endpointProblemSeverities.put(iJaxrsEndpoint.getIdentifier(), iJaxrsEndpoint.getProblemLevel());
        }
        for (IJaxrsElement iJaxrsElement : elements) {
            if (iJaxrsElement.isBinary() || iJaxrsElement instanceof JaxrsJavaElement && !((JaxrsJavaElement)iJaxrsElement).isBasedOnJavaType()) continue;
            elementsToValidate.add(iJaxrsElement);
            JaxrsMetamodelValidator.removeMarkers(iJaxrsElement);
        }
        for (IJaxrsElement iJaxrsElement : elementsToValidate) {
            IJaxrsElementValidator<? extends IJaxrsElement> validator = this.getValidator(iJaxrsElement);
            if (validator == null) continue;
            validator.validate((IJaxrsElement)iJaxrsElement, JaxrsMetamodelValidator.getAST(iJaxrsElement));
        }
        if (validateMetamodel) {
            this.validate(metamodel);
        }
        for (IJaxrsEndpoint iJaxrsEndpoint : endpoints) {
            int previousProblemLevel = (Integer)endpointProblemSeverities.get(iJaxrsEndpoint.getIdentifier());
            int currentProblemLevel = iJaxrsEndpoint.getProblemLevel();
            if (currentProblemLevel == previousProblemLevel) continue;
            JBossJaxrsCorePlugin.notifyEndpointProblemLevelChanged((IJaxrsEndpoint)iJaxrsEndpoint);
        }
        int n = metamodel.getProblemSeverity();
        if (n != previousMetamodelProblemSeverity) {
            JBossJaxrsCorePlugin.notifyMetamodelProblemLevelChanged((IJaxrsMetamodel)metamodel);
        }
    }

    private IJaxrsElementValidator<? extends IJaxrsElement> getValidator(IJaxrsElement element) {
        switch (element.getElementKind().getCategory()) {
            case APPLICATION: {
                IJaxrsApplication application = (IJaxrsApplication)element;
                if (application.isJavaApplication()) {
                    return new JaxrsJavaApplicationValidatorDelegate(this);
                }
                return new JaxrsWebxmlApplicationValidatorDelegate(this);
            }
            case HTTP_METHOD: {
                return new JaxrsHttpMethodValidatorDelegate(this);
            }
            case NAME_BINDING: {
                return new JaxrsNameBindingValidatorDelegate(this);
            }
            case PARAM_CONVERTER_PROVIDER: {
                return new JaxrsParamConverterProviderValidatorDelegate(this);
            }
            case PROVIDER: {
                return new JaxrsProviderValidatorDelegate(this);
            }
            case RESOURCE: {
                return new JaxrsResourceValidatorDelegate(this);
            }
            case RESOURCE_FIELD: {
                return new JaxrsResourceFieldValidatorDelegate(this);
            }
            case RESOURCE_PROPERTY: {
                return new JaxrsResourcePropertyValidatorDelegate(this);
            }
            case RESOURCE_METHOD: {
                return new JaxrsResourceMethodValidatorDelegate(this);
            }
            case PARAMETER_AGGREGATOR: {
                return new JaxrsParameterAggregatorValidatorDelegate(this);
            }
            case PARAMETER_AGGREGATOR_FIELD: {
                return new JaxrsParameterAggregatorFieldValidatorDelegate(this);
            }
            case PARAMETER_AGGREGATOR_PROPERTY: {
                return new JaxrsParameterAggregatorPropertyValidatorDelegate(this);
            }
        }
        return null;
    }

    private void validate(JaxrsMetamodel metamodel) throws CoreException {
        new JaxrsMetamodelValidatorDelegate(this).validate(metamodel);
    }

    protected String getMessageBundleName() {
        return BUNDLE_NAME;
    }

    protected String getPreference(IProject project, String preferenceKey) {
        return JaxrsPreferences.getInstance().getProjectPreference(project, preferenceKey);
    }

    public int getMaxNumberOfMarkersPerFile(IProject project) {
        return JaxrsPreferences.getMaxNumberOfProblemMarkersPerFile(project);
    }

    public String getId() {
        return ID;
    }

    public String getBuilderId() {
        return "org.jboss.tools.ws.jaxrs.metamodelBuilder";
    }

    public IValidatingProjectTree getValidatingProjects(IProject project) {
        return ValidatingProjectTreeLocator.getInstance().getValidatingProjects(project);
    }

    public void registerPreferenceInfo() {
        PreferenceInfoManager.register((String)this.getProblemType(), (IPreferenceInfo)new JaxrsPreferenceInfo());
    }

    public static void removeJaxrsMarkers(IProject project) throws CoreException {
        if (project == null || !project.isOpen()) {
            return;
        }
        project.deleteMarkers("org.jboss.tools.ws.jaxrs.metamodelMarker", true, 1);
    }

    public static void removeAllJaxrsMarkers(IProject project) throws CoreException {
        if (project == null || !project.isOpen()) {
            return;
        }
        project.deleteMarkers("org.jboss.tools.ws.jaxrs.metamodelMarker", true, 2);
    }

    public static void removeMarkers(IJaxrsElement element) throws CoreException {
        if (element == null || element.getResource() == null) {
            return;
        }
        element.getResource().deleteMarkers("org.jboss.tools.ws.jaxrs.metamodelMarker", true, 1);
        ((JaxrsBaseElement)element).resetProblemLevel();
    }

    @Override
    public IMarker addMarker(JaxrsBaseElement element, ISourceRange range, String message, String[] messageArguments, String preferenceKey) throws CoreException {
        this.addProblem(element, range, message, messageArguments, preferenceKey, -1);
        return null;
    }

    @Override
    public IMarker addMarker(JaxrsBaseElement element, ISourceRange range, String message, String[] messageArguments, String preferenceKey, int quickFixId) throws CoreException {
        this.addProblem(element, range, message, messageArguments, preferenceKey, quickFixId);
        return null;
    }

    private void addProblem(JaxrsBaseElement element, ISourceRange range, String message, String[] messageArguments, String preferenceKey, int quickfixId) throws CoreException {
        if (element == null || range == null) {
            return;
        }
        IResource resource = element.getResource();
        if (this.asYouTypeValidation) {
            Logger.debug("Reporting message '{}' on resource '{}'", message, resource.getFullPath().toString());
            IMessage validationMessage = this.addMessage(resource, range.getOffset(), range.getLength(), preferenceKey, message, messageArguments);
            if (validationMessage != null) {
                element.setProblemSeverity(validationMessage.getSeverity());
            }
        } else {
            Logger.debug("Reporting marker '{}' on resource '{}'", message, resource.getFullPath().toString());
            IMarker marker = this.addError(message, preferenceKey, messageArguments, range.getLength(), range.getOffset(), resource, quickfixId);
            if (marker != null) {
                marker.setAttribute(JAXRS_PROBLEM_TYPE, (Object)preferenceKey);
                element.setProblemSeverity(marker.getAttribute("severity", 0));
            }
        }
    }

    @Override
    public IMarker addMarker(JaxrsMetamodel metamodel, String message, String[] messageArguments, String preferenceKey) throws CoreException {
        IProject project = metamodel.getProject();
        if (this.asYouTypeValidation) {
            Logger.debug("Reporting message '{}' on resource '{}'", message, project.getFullPath().toString());
            IMessage validationMessage = this.addMessage((IResource)project, 0, 0, preferenceKey, message, messageArguments);
            if (validationMessage != null) {
                metamodel.setProblemSeverity(validationMessage.getSeverity());
            }
        } else {
            Logger.debug("Reporting marker '{}' on resource '{}'", message, project.getFullPath().toString());
            IMarker marker = this.addError(message, preferenceKey, messageArguments, 0, 0, (IResource)project);
            if (marker != null) {
                marker.setAttribute(JAXRS_PROBLEM_TYPE, (Object)preferenceKey);
                metamodel.setProblemSeverity(marker.getAttribute("severity", 0));
            }
        }
        return null;
    }

    public boolean shouldValidateAsYouType(IProject project) {
        return this.shouldValidate(project);
    }

    class JaxrsPreferenceInfo
    implements IPreferenceInfo {
        JaxrsPreferenceInfo() {
        }

        public String getPreferencePageId() {
            return JaxrsMetamodelValidator.PREFERENCE_PAGE_ID;
        }

        public String getPropertyPageId() {
            return JaxrsMetamodelValidator.PROPERTY_PAGE_ID;
        }

        public String getPluginId() {
            return "org.jboss.tools.ws.jaxrs.ui";
        }
    }
}

