/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.JavaElementsSearcher;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementCategory;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodParameter;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResource;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.AbstractJaxrsElementValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public abstract class JaxrsParameterAggregatorElementValidatorDelegate<T extends JaxrsParameterAggregatorElement<?>>
extends AbstractJaxrsElementValidatorDelegate<T> {
    public JaxrsParameterAggregatorElementValidatorDelegate(IMarkerManager markerManager) {
        super(markerManager);
    }

    void validatePathParamAnnotation(JaxrsParameterAggregatorElement<?> aggregatorElement, CompilationUnit ast) throws CoreException {
        String pathParamValue;
        Annotation pathParamAnnotation = aggregatorElement.getAnnotation("javax.ws.rs.PathParam");
        if (pathParamAnnotation != null && pathParamAnnotation.getValue() != null && !alphaNumPattern.matcher(pathParamValue = pathParamAnnotation.getValue()).matches()) {
            ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)pathParamAnnotation.getJavaAnnotation(), (String)"value", (CompilationUnit)ast);
            this.markerManager.addMarker((JaxrsBaseElement)aggregatorElement, range, JaxrsValidationMessages.RESOURCE_METHOD_INVALID_PATHPARAM_ANNOTATION_VALUE, new String[]{pathParamValue}, JaxrsPreferences.RESOURCE_METHOD_INVALID_PATHPARAM_ANNOTATION_VALUE);
        }
    }

    void validateNoUnboundPathAnnotationTemplateParameters(T element, CompilationUnit ast) throws CoreException {
        if (!element.hasAnnotation("javax.ws.rs.PathParam")) {
            return;
        }
        JaxrsMetamodel metamodel = element.getMetamodel();
        List knownTypes = metamodel.getAllJavaElements(7);
        IType parentType = element.getJavaElement().getDeclaringType();
        Set relatedTypes = JavaElementsSearcher.findRelatedTypes((IType)parentType, (List)knownTypes, (IProgressMonitor)new NullProgressMonitor());
        for (IType relatedType : relatedTypes) {
            JaxrsResource relatedResource = (JaxrsResource)metamodel.findElement(relatedType.getFullyQualifiedName(), EnumElementCategory.RESOURCE);
            if (relatedResource == null) continue;
            for (IJaxrsResourceMethod resourceMethod : relatedResource.getAllMethods()) {
                for (IJavaMethodParameter methodParameter : resourceMethod.getJavaMethodParameters()) {
                    if (!methodParameter.hasAnnotation("javax.ws.rs.BeanParam")) continue;
                    this.validateNoUnboundPathAnnotationTemplateParameters(element, resourceMethod, ast);
                }
            }
        }
    }

    private void validateNoUnboundPathAnnotationTemplateParameters(T parameterAggregatorElement, IJaxrsResourceMethod resourceMethod, CompilationUnit ast) throws CoreException {
        Annotation pathParamAnnotation = parameterAggregatorElement.getAnnotation("javax.ws.rs.PathParam");
        String pathParamValue = pathParamAnnotation.getValue();
        Map resourceMethodPathTemplateParameters = resourceMethod.getPathTemplateParameters();
        if (resourceMethodPathTemplateParameters.containsKey(pathParamValue)) {
            return;
        }
        IJaxrsResource parentResource = resourceMethod.getParentResource();
        Map parentResourcePathTemplateParameters = parentResource.getPathTemplateParameters();
        if (parentResourcePathTemplateParameters.containsKey(pathParamValue)) {
            return;
        }
        ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)pathParamAnnotation.getJavaAnnotation(), (String)"value", (CompilationUnit)ast);
        this.markerManager.addMarker((JaxrsBaseElement)parameterAggregatorElement, range, JaxrsValidationMessages.RESOURCE_FIELD_UNBOUND_PATHPARAM_ANNOTATION_VALUE, new String[]{pathParamValue, parentResource.getJavaElement().getFullyQualifiedName()}, JaxrsPreferences.RESOURCE_ELEMENT_UNBOUND_PATHPARAM_ANNOTATION_VALUE);
    }
}

