/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.AbstractJaxrsElementValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsParameterValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public abstract class JaxrsResourceElementValidatorDelegate<T extends JaxrsResourceElement<?>>
extends AbstractJaxrsElementValidatorDelegate<T> {
    public JaxrsResourceElementValidatorDelegate(IMarkerManager markerManager) {
        super(markerManager);
    }

    void validateNotUnboundPathParamAnnotationValue(T resourceElement, CompilationUnit ast) throws CoreException {
        Annotation pathParamAnnotation = resourceElement.getAnnotation("javax.ws.rs.PathParam");
        if (pathParamAnnotation == null) {
            return;
        }
        JaxrsResource parentResource = resourceElement.getParentResource();
        HashSet pathTemplateParameters = new HashSet();
        pathTemplateParameters.addAll(parentResource.getPathTemplateParameters().keySet());
        Collection resourceMethods = parentResource.getMethods().values();
        for (JaxrsResourceMethod resourceMethod : resourceMethods) {
            pathTemplateParameters.addAll(resourceMethod.getPathTemplateParameters().keySet());
        }
        if (!pathTemplateParameters.contains(pathParamAnnotation.getValue())) {
            ISourceRange annotationValueRange = JdtUtils.resolveMemberPairValueRange((IAnnotation)pathParamAnnotation.getJavaAnnotation(), (String)"value", (CompilationUnit)ast);
            this.markerManager.addMarker((JaxrsBaseElement)resourceElement, annotationValueRange, JaxrsValidationMessages.RESOURCE_FIELD_UNBOUND_PATHPARAM_ANNOTATION_VALUE, new String[]{pathParamAnnotation.getValue(), ((IType)parentResource.getJavaElement()).getFullyQualifiedName()}, JaxrsPreferences.RESOURCE_ELEMENT_UNBOUND_PATHPARAM_ANNOTATION_VALUE);
        }
    }

    void validateParameterType(T resourceElement) throws CoreException {
        Set allParamConverterProviders = resourceElement.getMetamodel().findAllParamConverterProviders();
        if (allParamConverterProviders != null && !allParamConverterProviders.isEmpty()) {
            return;
        }
        JaxrsParameterValidatorDelegate parameterValidatorDelegate = new JaxrsParameterValidatorDelegate();
        SourceType type = resourceElement.getType();
        if (!type.exists()) {
            return;
        }
        boolean isValid = parameterValidatorDelegate.validate(type);
        if (!isValid) {
            this.markerManager.addMarker((JaxrsBaseElement)resourceElement, resourceElement.getJavaElement().getNameRange(), JaxrsValidationMessages.RESOURCE_METHOD_INVALID_ANNOTATED_PARAMETER_TYPE, new String[]{type.getErasureName()}, JaxrsPreferences.RESOURCE_METHOD_INVALID_ANNOTATED_PARAMETER_TYPE);
        }
    }
}

