/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.navigation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsNameBinding;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelLocator;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.navigation.JaxrsNameBindingAnnotationHyperlink;

public class JaxrsNameBindingHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof JavaEditor)) {
            return null;
        }
        int offset = region.getOffset();
        IJavaElement input = EditorUtility.getActiveEditorJavaInput();
        if (input == null) {
            return null;
        }
        JaxrsMetamodel metamodel = this.getMetamodel(input);
        if (metamodel == null) {
            return null;
        }
        IRegion wordRegion = this.getCurrentWordRegion(textEditor, offset);
        if (wordRegion == null || wordRegion.getLength() == 0) {
            return null;
        }
        IJavaElement[] selectedJavaElements = this.getSelectedElements(input, wordRegion);
        List<IJaxrsJavaElement> targets = this.findTargets(metamodel, selectedJavaElements, (ICompilationUnit)input.getAncestor(5));
        if (targets != null && !targets.isEmpty()) {
            IHyperlink[] result = new IHyperlink[targets.size()];
            int i = 0;
            while (i < targets.size()) {
                result[i] = new JaxrsNameBindingAnnotationHyperlink(targets.get(i), wordRegion);
                ++i;
            }
            return result;
        }
        return null;
    }

    private IJavaElement[] getSelectedElements(IJavaElement input, IRegion wordRegion) {
        try {
            return ((ICodeAssist)input).codeSelect(wordRegion.getOffset(), wordRegion.getLength());
        }
        catch (JavaModelException e) {
            Logger.debug("Failed to retrieve the selected Java Elements in the editor for" + input.getElementName(), new Object[]{e});
            return new IJavaElement[0];
        }
    }

    private List<IJaxrsJavaElement> findTargets(JaxrsMetamodel metamodel, IJavaElement[] selectedJavaElements, ICompilationUnit currentCompilationUnit) {
        ArrayList<IJaxrsJavaElement> targetElements = new ArrayList<IJaxrsJavaElement>();
        IJavaElement[] iJavaElementArray = selectedJavaElements;
        int n = selectedJavaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement selectedJavaElement = iJavaElementArray[n2];
            IJaxrsElement associatedJaxrsElement = metamodel.findElement(selectedJavaElement);
            if (associatedJaxrsElement != null && associatedJaxrsElement.getElementKind() == EnumElementKind.NAME_BINDING) {
                JaxrsNameBinding nameBinding = (JaxrsNameBinding)associatedJaxrsElement;
                Set matchingElements = metamodel.findElementsByAnnotation(nameBinding.getJavaClassName());
                for (IJaxrsElement matchingElement : matchingElements) {
                    IJavaElement matchingJavaElement = ((IJaxrsJavaElement)matchingElement).getJavaElement();
                    if (matchingJavaElement.getAncestor(5).equals(currentCompilationUnit)) continue;
                    targetElements.add((IJaxrsJavaElement)matchingElement);
                }
            }
            ++n2;
        }
        return targetElements;
    }

    private IRegion getCurrentWordRegion(ITextEditor textEditor, int offset) {
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IRegion wordRegion = JavaWordFinder.findWord((IDocument)document, (int)offset);
        return wordRegion;
    }

    private JaxrsMetamodel getMetamodel(IJavaElement input) {
        try {
            return JaxrsMetamodelLocator.get((IJavaProject)input.getJavaProject());
        }
        catch (CoreException e) {
            Logger.error("Failed to retrieve JAX-RS Metamodel for " + input.getElementName(), e);
            return null;
        }
    }
}

