/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.quickfix;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelLocator;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.quickfix.AddHttpMethodRetentionAnnotationMarkerResolution;
import org.jboss.tools.ws.jaxrs.ui.quickfix.AddHttpMethodRetentionValueCompletionProposal;
import org.jboss.tools.ws.jaxrs.ui.quickfix.AddHttpMethodTargetAnnotationMarkerResolution;
import org.jboss.tools.ws.jaxrs.ui.quickfix.AddHttpMethodTargetValuesCompletionProposal;
import org.jboss.tools.ws.jaxrs.ui.quickfix.AddHttpMethodValueCompletionProposal;
import org.jboss.tools.ws.jaxrs.ui.quickfix.AddNameBindingRetentionAnnotationMarkerResolution;
import org.jboss.tools.ws.jaxrs.ui.quickfix.AddNameBindingRetentionValueCompletionProposal;
import org.jboss.tools.ws.jaxrs.ui.quickfix.AddNameBindingTargetAnnotationMarkerResolution;
import org.jboss.tools.ws.jaxrs.ui.quickfix.UpdateHttpMethodRetentionAnnotationValueMarkerResolution;
import org.jboss.tools.ws.jaxrs.ui.quickfix.UpdateHttpMethodTargetAnnotationValueMarkerResolution;
import org.jboss.tools.ws.jaxrs.ui.quickfix.UpdateNameBindingRetentionAnnotationValueMarkerResolution;

public class JaxrsMarkerResolutionGenerator
implements IMarkerResolutionGenerator2,
IQuickFixProcessor {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        return this.getMarkerResolutions(marker);
    }

    public boolean hasResolutions(IMarker marker) {
        return this.getMarkerResolutions(marker).length > 0;
    }

    private IMarkerResolution[] getMarkerResolutions(IMarker marker) {
        try {
            int quickfixId = this.getQuickFixID(marker);
            ICompilationUnit compilationUnit = JdtUtils.getCompilationUnit((IResource)marker.getResource());
            IType type = (IType)JdtUtils.getElementAt((ICompilationUnit)compilationUnit, (int)marker.getAttribute("charStart", 0), (int)7);
            if (type != null) {
                switch (quickfixId) {
                    case 3: {
                        return new IMarkerResolution[]{new AddHttpMethodTargetAnnotationMarkerResolution(type)};
                    }
                    case 7: {
                        return new IMarkerResolution[]{new AddNameBindingTargetAnnotationMarkerResolution(type)};
                    }
                    case 4: {
                        return new IMarkerResolution[]{new UpdateHttpMethodTargetAnnotationValueMarkerResolution(type)};
                    }
                    case 8: {
                        return new IMarkerResolution[]{new UpdateHttpMethodTargetAnnotationValueMarkerResolution(type)};
                    }
                    case 1: {
                        return new IMarkerResolution[]{new AddHttpMethodRetentionAnnotationMarkerResolution(type)};
                    }
                    case 5: {
                        return new IMarkerResolution[]{new AddNameBindingRetentionAnnotationMarkerResolution(type)};
                    }
                    case 2: {
                        return new IMarkerResolution[]{new UpdateHttpMethodRetentionAnnotationValueMarkerResolution(type)};
                    }
                    case 6: {
                        return new IMarkerResolution[]{new UpdateNameBindingRetentionAnnotationValueMarkerResolution(type)};
                    }
                }
            }
        }
        catch (CoreException e) {
            Logger.error("Failed to retrieve marker resolution", e);
        }
        return new IMarkerResolution[0];
    }

    private int getQuickFixID(IMarker marker) throws CoreException {
        return marker.getAttribute("Message_id", -1);
    }

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return false;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        CompilationUnit astRoot = context.getASTRoot();
        ArrayList<IJavaCompletionProposal> completionProposals = new ArrayList<IJavaCompletionProposal>();
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation javaElement;
            ASTNode coveredNode;
            String qualifiedName;
            IJavaCompletionProposal completionProposal;
            IProblemLocation problemLocation = iProblemLocationArray[n2];
            if (problemLocation.getMarkerType().equals("org.eclipse.jdt.core.problem") && problemLocation.getProblemId() == 16777825 && (completionProposal = this.generateMissingAttributesCompletionProposal(qualifiedName = this.getQualifiedName(coveredNode = problemLocation.getCoveredNode(astRoot)), problemLocation, javaElement = this.getJavaAnnotation(coveredNode))) != null) {
                completionProposals.add(completionProposal);
            }
            ++n2;
        }
        return completionProposals.toArray(new IJavaCompletionProposal[completionProposals.size()]);
    }

    private String getQualifiedName(ASTNode node) {
        ITypeBinding binding;
        if (node instanceof Expression && (binding = ((Expression)node).resolveTypeBinding()) != null) {
            return binding.getQualifiedName();
        }
        return null;
    }

    private IAnnotation getJavaAnnotation(ASTNode node) {
        if (node instanceof Annotation) {
            IAnnotationBinding binding = ((Annotation)node).resolveAnnotationBinding();
            if (binding != null) {
                return (IAnnotation)binding.getJavaElement();
            }
        } else if (node instanceof SimpleName) {
            return this.getJavaAnnotation(node.getParent());
        }
        return null;
    }

    private IJavaCompletionProposal generateMissingAttributesCompletionProposal(String qualifiedName, IProblemLocation problemLocation, IAnnotation annotation) throws JavaModelException {
        if (qualifiedName == null || annotation == null) {
            return null;
        }
        IJaxrsElement jaxrsElement = JaxrsMarkerResolutionGenerator.findJaxrsElement(annotation.getParent());
        if (jaxrsElement == null) {
            return null;
        }
        ICompilationUnit compilationUnit = (ICompilationUnit)annotation.getAncestor(5);
        if (qualifiedName.equals("java.lang.annotation.Target")) {
            switch (jaxrsElement.getElementKind()) {
                case HTTP_METHOD: {
                    return new AddHttpMethodTargetValuesCompletionProposal(compilationUnit, JaxrsMarkerResolutionGenerator.findEffectiveSourceRange(compilationUnit, problemLocation));
                }
                case NAME_BINDING: {
                    return new AddHttpMethodTargetValuesCompletionProposal(compilationUnit, JaxrsMarkerResolutionGenerator.findEffectiveSourceRange(compilationUnit, problemLocation));
                }
            }
            return null;
        }
        if (qualifiedName.equals("java.lang.annotation.Retention")) {
            switch (jaxrsElement.getElementKind()) {
                case HTTP_METHOD: {
                    return new AddHttpMethodRetentionValueCompletionProposal(compilationUnit, JaxrsMarkerResolutionGenerator.findEffectiveSourceRange(compilationUnit, problemLocation));
                }
                case NAME_BINDING: {
                    return new AddNameBindingRetentionValueCompletionProposal(compilationUnit, JaxrsMarkerResolutionGenerator.findEffectiveSourceRange(compilationUnit, problemLocation));
                }
            }
            return null;
        }
        if (qualifiedName.equals("javax.ws.rs.HttpMethod")) {
            IJavaElement httpMethodType = annotation.getAncestor(7);
            return new AddHttpMethodValueCompletionProposal(compilationUnit, "\"" + httpMethodType.getElementName() + "\"", JaxrsMarkerResolutionGenerator.findEffectiveSourceRange(compilationUnit, problemLocation));
        }
        return null;
    }

    public static SourceRange findEffectiveSourceRange(ICompilationUnit compilationUnit, IProblemLocation problemLocation) {
        try {
            String source = compilationUnit.getSource();
            int position = problemLocation.getOffset() + problemLocation.getLength();
            char c = '\u0000';
            while ((c = source.charAt(position)) == ' ') {
                ++position;
            }
            if (c == '(') {
                ++position;
                while ((c = source.charAt(position)) == ' ') {
                    ++position;
                }
                if (c == ')') {
                    return new SourceRange(problemLocation.getOffset(), position - problemLocation.getOffset() + 1);
                }
            }
            return new SourceRange(problemLocation.getOffset(), problemLocation.getLength());
        }
        catch (JavaModelException javaModelException) {
            return new SourceRange(problemLocation.getOffset(), problemLocation.getLength());
        }
    }

    private static IJaxrsElement findJaxrsElement(IJavaElement javaElement) {
        if (javaElement != null) {
            try {
                return JaxrsMetamodelLocator.get((IJavaProject)javaElement.getJavaProject()).findElement(javaElement);
            }
            catch (CoreException e) {
                Logger.error("Failed to retrieve JAX-RS Elements associated with '" + javaElement.getElementName() + "'", e);
            }
        }
        return null;
    }
}

