/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.view;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.ws.jaxrs.ui.JBossJAXRSUIMessages;
import org.jboss.tools.ws.ui.views.WSProperty;

public class PropertiesList
extends Composite {
    private static final String DELIMITER = "=";
    private Button addButton;
    private Button removeAllButton;
    private Button removeButton;
    private Button editButton;
    private Text addText;
    private Label warningLabel;
    private ListViewer listViewer;
    private Set<WSProperty> wsProperties = new LinkedHashSet<WSProperty>();
    private List<Listener> propertiesListeners = new ArrayList<Listener>();
    private String mWarning = null;

    public PropertiesList(Composite parent, int style) {
        super(parent, style);
        int additionalStyles = 0;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.warningLabel = new Label((Composite)this, 0);
        GridData wlGridData = new GridData(768);
        wlGridData.horizontalSpan = 2;
        this.warningLabel.setLayoutData((Object)wlGridData);
        this.warningLabel.setForeground(this.warningLabel.getDisplay().getSystemColor(3));
        this.warningLabel.setBackground(parent.getBackground());
        this.addText = new Text((Composite)this, 0x800 | additionalStyles);
        this.addText.setLayoutData((Object)new GridData(768));
        this.addText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                PropertiesList.this.updatePropertyButtons();
            }
        });
        this.addButton = new Button((Composite)this, 0);
        this.addButton.setLayoutData((Object)new GridData(256));
        this.addButton.setText("Add");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesList.this.addStringToList();
                PropertiesList.this.fireChangedEvent();
            }
        });
        this.addButton.setEnabled(false);
        Composite mSpacerComposite = new Composite((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.heightHint = 10;
        gridData.horizontalSpan = 2;
        mSpacerComposite.setLayoutData((Object)gridData);
        mSpacerComposite.setLayout((Layout)new GridLayout());
        mSpacerComposite.setBackground(parent.getBackground());
        org.eclipse.swt.widgets.List propsList = new org.eclipse.swt.widgets.List((Composite)this, 2560);
        GridData propsListData = new GridData(272);
        propsListData.verticalSpan = 3;
        propsList.setLayoutData((Object)propsListData);
        propsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesList.this.updatePropertyButtons();
            }
        });
        this.listViewer = new ListViewer(propsList);
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                WSProperty rProperty = (WSProperty)element;
                return rProperty.toString();
            }
        });
        this.listViewer.setInput(this.wsProperties);
        this.editButton = new Button((Composite)this, 0);
        this.editButton.setLayoutData((Object)new GridData(256));
        this.editButton.setText("Edit");
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesList.this.editInList();
                PropertiesList.this.fireChangedEvent();
            }
        });
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setLayoutData((Object)new GridData(256));
        this.removeButton.setText("Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesList.this.removeFromList();
                PropertiesList.this.fireChangedEvent();
            }
        });
        this.removeAllButton = new Button((Composite)this, 0);
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.setLayoutData((Object)new GridData(256));
        this.removeAllButton.setText("Remove All");
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesList.this.removeAll();
                PropertiesList.this.updatePropertyButtons();
                PropertiesList.this.fireChangedEvent();
            }
        });
        this.updatePropertyButtons();
    }

    public void removeAll() {
        this.wsProperties.clear();
        this.listViewer.refresh();
        this.updatePropertyButtons();
    }

    public void setProperties(Set<WSProperty> properties) {
        this.wsProperties = properties;
        this.listViewer.setInput(this.wsProperties);
    }

    private void addStringToList() {
        if (this.addText.getText().length() > 0) {
            String text = this.addText.getText().trim();
            if (text.indexOf(38) > -1) {
                this.openDelimiterDialog(JBossJAXRSUIMessages.DelimitedStringList_Msg_Text_ParseByAmpersand, JBossJAXRSUIMessages.DelimitedStringList_Msg_Title_ParseByAmpersand, text, "&");
            } else if (text.indexOf(44) > -1) {
                this.openDelimiterDialog(JBossJAXRSUIMessages.DelimitedStringList_Msg_Text_ParseByComma, JBossJAXRSUIMessages.DelimitedStringList_Msg_Title_ParseByComma, text, ",");
            } else {
                WSProperty prop = PropertiesList.parseString(text);
                if (!this.wsProperties.add(prop)) {
                    this.wsProperties.remove(prop);
                    this.wsProperties.add(prop);
                }
            }
            this.removeAllButton.setEnabled(true);
            this.addText.setSelection(0, text.length());
            this.addText.setFocus();
            this.listViewer.refresh();
        }
    }

    private void openDelimiterDialog(String dialogText, String dialogTitle, String text, String delimiter) {
        MessageDialog dialog = new MessageDialog(null, dialogTitle, null, dialogText, 3, new String[]{JBossJAXRSUIMessages.DelimitedStringList_Msg_Yes_Btn, JBossJAXRSUIMessages.DelimitedStringList_Msg_No_Btn}, 0);
        int result = dialog.open();
        if (result == 0) {
            this.wsProperties.addAll(PropertiesList.parseString(text, delimiter));
        }
    }

    public static WSProperty parseString(String prop) {
        String[] p = prop.split(DELIMITER);
        return new WSProperty(p[0], p[1]);
    }

    public static Set<WSProperty> parseString(String str_list, String delimiter) {
        LinkedHashSet<WSProperty> properties = new LinkedHashSet<WSProperty>();
        StringTokenizer tk = new StringTokenizer(str_list, delimiter);
        while (tk.hasMoreTokens()) {
            properties.add(PropertiesList.parseString(tk.nextToken()));
        }
        return properties;
    }

    private void editInList() {
        InputDialog editDialog;
        WSProperty selection = this.getSelection();
        if (selection != null && (editDialog = new InputDialog(this.getShell(), JBossJAXRSUIMessages.JBossWS_DelimitedStringList_EditValue_Dialog_Title, JBossJAXRSUIMessages.JBossWS_DelimitedStringList_EditValue_Dialog_Message, selection.toString(), null)).open() == 0) {
            WSProperty prop = PropertiesList.parseString(editDialog.getValue());
            if (!this.wsProperties.add(prop)) {
                this.wsProperties.remove(prop);
                this.wsProperties.add(prop);
            }
            this.listViewer.refresh();
        }
        this.updatePropertyButtons();
    }

    private void removeFromList() {
        WSProperty wProp = this.getSelection();
        if (wProp != null) {
            this.wsProperties.remove(wProp);
        }
        this.listViewer.refresh();
        this.updatePropertyButtons();
    }

    public WSProperty getSelection() {
        Object obj = this.listViewer.getStructuredSelection().getFirstElement();
        return obj == null ? null : (WSProperty)obj;
    }

    public void updatePropertyButtons() {
        String value;
        this.removeButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.removeAllButton.setEnabled(false);
        if (!this.wsProperties.isEmpty()) {
            this.removeAllButton.setEnabled(true);
            if (this.getSelection() != null) {
                this.removeButton.setEnabled(true);
                this.editButton.setEnabled(true);
            }
        }
        boolean flag = (value = this.addText.getText()) != null && value.trim().length() > 0;
        boolean valid = this.validateText(value);
        if (!valid) {
            this.warningLabel.setText(this.mWarning);
        } else {
            this.warningLabel.setText("");
        }
        this.addButton.setEnabled(flag && valid);
    }

    private boolean validateText(String text) {
        if (text != null && text.trim().length() > 0 && text.indexOf(DELIMITER) == -1) {
            this.mWarning = JBossJAXRSUIMessages.DelimitedStringList_NO_EQUALS_DELIMITER_WARNING;
            return false;
        }
        this.mWarning = null;
        return true;
    }

    public boolean setFocus() {
        if (this.addText != null) {
            return this.addText.setFocus();
        }
        return false;
    }

    public void addPropertiesListener(Listener listener) {
        this.propertiesListeners.add(listener);
    }

    private void fireChangedEvent() {
        Event e = new Event();
        e.data = this.wsProperties;
        for (Listener listener : this.propertiesListeners) {
            listener.handleEvent(e);
        }
    }
}

